/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.iotdb.db.mpp.common.header.HeaderConstant;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class NodeManageMemoryMergeOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final Set<String> data;
    private final Operator child;

    public NodeManageMemoryMergeOperator(OperatorContext operatorContext, Set<String> data, Operator child) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.data = data;
        this.child = Objects.requireNonNull(child, "child operator is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() {
        TsBlock block = this.child.next();
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(HeaderConstant.showChildPathsHeader.getRespDataTypes());
        TreeSet<String> nodePaths = new TreeSet<String>(this.data);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            nodePaths.add(block.getColumn(0).getBinary(i).toString());
        }
        nodePaths.forEach(path -> {
            tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
            tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary(path));
            tsBlockBuilder.declarePosition();
        });
        return tsBlockBuilder.build();
    }

    @Override
    public boolean hasNext() {
        return this.child.hasNext();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public boolean isFinished() {
        return this.child.isFinished();
    }
}

