/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;

public abstract class SchemaQueryScanOperator
implements SourceOperator {
    protected OperatorContext operatorContext;
    protected TsBlock tsBlock;
    private boolean hasCachedTsBlock;
    protected int limit;
    protected int offset;
    protected PartialPath partialPath;
    protected boolean isPrefixPath;
    protected PlanNodeId sourceId;

    protected SchemaQueryScanOperator(PlanNodeId sourceId, OperatorContext operatorContext, int limit, int offset, PartialPath partialPath, boolean isPrefixPath) {
        this.operatorContext = operatorContext;
        this.limit = limit;
        this.offset = offset;
        this.partialPath = partialPath;
        this.isPrefixPath = isPrefixPath;
        this.sourceId = sourceId;
    }

    protected abstract TsBlock createTsBlock();

    public PartialPath getPartialPath() {
        return this.partialPath;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean isPrefixPath() {
        return this.isPrefixPath;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        this.hasCachedTsBlock = false;
        return this.tsBlock;
    }

    @Override
    public boolean hasNext() {
        if (this.tsBlock == null) {
            this.tsBlock = this.createTsBlock();
            if (this.tsBlock.getPositionCount() > 0) {
                this.hasCachedTsBlock = true;
            }
        }
        return this.hasCachedTsBlock;
    }

    @Override
    public boolean isFinished() {
        return !this.hasNext();
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }
}

