/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.header.HeaderConstant;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.schema.SchemaQueryScanOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class TimeSeriesSchemaScanOperator
extends SchemaQueryScanOperator {
    private String key;
    private String value;
    private boolean isContains;
    private boolean orderByHeat;

    public TimeSeriesSchemaScanOperator(PlanNodeId planNodeId, OperatorContext operatorContext, int limit, int offset, PartialPath partialPath, String key, String value, boolean isContains, boolean orderByHeat, boolean isPrefixPath) {
        super(planNodeId, operatorContext, limit, offset, partialPath, isPrefixPath);
        this.isContains = isContains;
        this.key = key;
        this.value = value;
        this.orderByHeat = orderByHeat;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isContains() {
        return this.isContains;
    }

    public boolean isOrderByHeat() {
        return this.orderByHeat;
    }

    @Override
    protected TsBlock createTsBlock() {
        TsBlockBuilder builder = new TsBlockBuilder(HeaderConstant.showTimeSeriesHeader.getRespDataTypes());
        try {
            ((List)((SchemaDriverContext)this.operatorContext.getInstanceContext().getDriverContext()).getSchemaRegion().showTimeseries((ShowTimeSeriesPlan)this.convertToPhysicalPlan(), (QueryContext)this.operatorContext.getInstanceContext()).left).forEach(series -> this.setColumns((ShowTimeSeriesResult)series, builder));
        }
        catch (MetadataException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return builder.build();
    }

    private ShowTimeSeriesPlan convertToPhysicalPlan() {
        return new ShowTimeSeriesPlan(this.partialPath, this.isContains, this.key, this.value, this.limit, this.offset, this.orderByHeat);
    }

    private void setColumns(ShowTimeSeriesResult series, TsBlockBuilder builder) {
        builder.getTimeColumnBuilder().writeLong(series.getLastTime());
        this.writeValueColumn(builder, 0, series.getName());
        this.writeValueColumn(builder, 1, series.getAlias());
        this.writeValueColumn(builder, 2, series.getSgName());
        this.writeValueColumn(builder, 3, series.getDataType().toString());
        this.writeValueColumn(builder, 4, series.getEncoding().toString());
        this.writeValueColumn(builder, 5, series.getCompressor().toString());
        this.writeValueColumn(builder, 6, this.mapToString(series.getTag()));
        this.writeValueColumn(builder, 7, this.mapToString(series.getAttribute()));
        builder.declarePosition();
    }

    private void writeValueColumn(TsBlockBuilder builder, int columnIndex, String value) {
        if (value == null) {
            builder.getColumnBuilder(columnIndex).appendNull();
        } else {
            builder.getColumnBuilder(columnIndex).writeBinary(new Binary(value));
        }
    }

    private String mapToString(Map<String, String> map) {
        return map.entrySet().stream().map(e -> "\"" + (String)e.getKey() + "\":\"" + (String)e.getValue() + "\"").collect(Collectors.joining(","));
    }
}

