/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.mpp.aggregation.Aggregator;
import org.apache.iotdb.db.mpp.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.AggregationOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.RawDataAggregationOperator;
import org.apache.iotdb.db.mpp.execution.operator.source.AlignedSeriesScanUtil;
import org.apache.iotdb.db.mpp.execution.operator.source.DataSourceOperator;
import org.apache.iotdb.db.mpp.execution.operator.source.SeriesAggregationScanOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class AlignedSeriesAggregationScanOperator
implements DataSourceOperator {
    private final OperatorContext operatorContext;
    private final PlanNodeId sourceId;
    private final AlignedSeriesScanUtil alignedSeriesScanUtil;
    private final int subSensorSize;
    private final boolean ascending;
    private List<Aggregator> aggregators;
    private ITimeRangeIterator timeRangeIterator;
    private TimeRange curTimeRange;
    private boolean isGroupByQuery;
    private TsBlock preCachedData;
    private TsBlockBuilder tsBlockBuilder;
    private TsBlock resultTsBlock;
    private boolean hasCachedTsBlock = false;
    private boolean finished = false;

    public AlignedSeriesAggregationScanOperator(PlanNodeId sourceId, AlignedPath seriesPath, OperatorContext context, List<Aggregator> aggregators, Filter timeFilter, boolean ascending, GroupByTimeParameter groupByTimeParameter) {
        this.sourceId = sourceId;
        this.operatorContext = context;
        this.ascending = ascending;
        this.alignedSeriesScanUtil = new AlignedSeriesScanUtil(seriesPath, new HashSet<String>(seriesPath.getMeasurementList()), context.getInstanceContext(), timeFilter, null, ascending);
        this.subSensorSize = seriesPath.getMeasurementList().size();
        this.aggregators = aggregators;
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (Aggregator aggregator : aggregators) {
            dataTypes.addAll(Arrays.asList(aggregator.getOutputType()));
        }
        this.tsBlockBuilder = new TsBlockBuilder(dataTypes);
        this.timeRangeIterator = SeriesAggregationScanOperator.initTimeRangeIterator(groupByTimeParameter, ascending, true);
        this.isGroupByQuery = groupByTimeParameter != null;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        if (this.hasCachedTsBlock || this.hasNext()) {
            this.hasCachedTsBlock = false;
            return this.resultTsBlock;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        if (this.hasCachedTsBlock) {
            return true;
        }
        try {
            if (!this.timeRangeIterator.hasNextTimeRange()) {
                return false;
            }
            this.curTimeRange = this.timeRangeIterator.nextTimeRange();
            for (Aggregator aggregator : this.aggregators) {
                aggregator.reset();
                aggregator.updateTimeRange(this.curTimeRange);
            }
            if (this.calcFromCacheData(this.curTimeRange)) {
                this.updateResultTsBlockFromAggregators();
                return true;
            }
            if (this.readAndCalcFromPage(this.curTimeRange)) {
                this.updateResultTsBlockFromAggregators();
                return true;
            }
            if (this.readAndCalcFromChunk(this.curTimeRange)) {
                this.updateResultTsBlockFromAggregators();
                return true;
            }
            while (this.alignedSeriesScanUtil.hasNextFile()) {
                if (this.canUseCurrentFileStatistics()) {
                    Statistics fileTimeStatistics = this.alignedSeriesScanUtil.currentFileTimeStatistics();
                    if (fileTimeStatistics.getStartTime() > this.curTimeRange.getMax()) {
                        if (this.ascending) {
                            this.updateResultTsBlockFromAggregators();
                            return true;
                        }
                        this.alignedSeriesScanUtil.skipCurrentFile();
                        continue;
                    }
                    if (this.curTimeRange.contains(fileTimeStatistics.getStartTime(), fileTimeStatistics.getEndTime())) {
                        Statistics[] statisticsList = new Statistics[this.subSensorSize];
                        for (int i = 0; i < this.subSensorSize; ++i) {
                            statisticsList[i] = this.alignedSeriesScanUtil.currentFileStatistics(i);
                        }
                        this.calcFromStatistics(statisticsList);
                        this.alignedSeriesScanUtil.skipCurrentFile();
                        if (!RawDataAggregationOperator.isEndCalc(this.aggregators) || this.isGroupByQuery) continue;
                        break;
                    }
                }
                if (!this.readAndCalcFromChunk(this.curTimeRange)) continue;
                this.updateResultTsBlockFromAggregators();
                return true;
            }
            this.updateResultTsBlockFromAggregators();
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while scanning the file", e);
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished || (this.finished = !this.hasNext());
    }

    @Override
    public void initQueryDataSource(QueryDataSource dataSource) {
        this.alignedSeriesScanUtil.initQueryDataSource(dataSource);
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    private void updateResultTsBlockFromAggregators() {
        this.resultTsBlock = AggregationOperator.updateResultTsBlockFromAggregators(this.tsBlockBuilder, this.aggregators, this.timeRangeIterator);
        this.hasCachedTsBlock = true;
    }

    private boolean calcFromCacheData(TimeRange curTimeRange) throws IOException {
        this.calcFromBatch(this.preCachedData, curTimeRange);
        return this.preCachedData != null && (!this.ascending ? this.preCachedData.getEndTime() < curTimeRange.getMin() : this.preCachedData.getEndTime() > curTimeRange.getMax()) || RawDataAggregationOperator.isEndCalc(this.aggregators);
    }

    private void calcFromBatch(TsBlock tsBlock, TimeRange curTimeRange) {
        if (tsBlock != null && this.satisfied((TsBlock)tsBlock, curTimeRange, this.ascending)) {
            if (this.ascending && tsBlock.getStartTime() < curTimeRange.getMin() || !this.ascending && tsBlock.getStartTime() > curTimeRange.getMax()) {
                tsBlock = RawDataAggregationOperator.skipOutOfTimeRangePoints(tsBlock, curTimeRange, this.ascending);
            }
            int lastReadRowIndex = 0;
            for (Aggregator aggregator : this.aggregators) {
                if (aggregator.hasFinalResult()) continue;
                lastReadRowIndex = Math.max(lastReadRowIndex, aggregator.processTsBlock((TsBlock)tsBlock));
            }
            if ((tsBlock = lastReadRowIndex >= tsBlock.getPositionCount() ? null : tsBlock.subTsBlock(lastReadRowIndex)) != null && tsBlock.getTsBlockSingleColumnIterator().hasNext()) {
                this.preCachedData = tsBlock;
            }
        }
    }

    private boolean satisfied(TsBlock tsBlock, TimeRange timeRange, boolean ascending) {
        TsBlock.TsBlockSingleColumnIterator tsBlockIterator = tsBlock.getTsBlockSingleColumnIterator();
        if (tsBlockIterator == null || !tsBlockIterator.hasNext()) {
            return false;
        }
        if (ascending && (tsBlockIterator.getEndTime() < timeRange.getMin() || tsBlockIterator.currentTime() > timeRange.getMax())) {
            return false;
        }
        if (!(ascending || tsBlockIterator.getEndTime() <= timeRange.getMax() && tsBlockIterator.currentTime() >= timeRange.getMin())) {
            this.preCachedData = tsBlock;
            return false;
        }
        return true;
    }

    private boolean readAndCalcFromPage(TimeRange curTimeRange) throws IOException {
        while (this.alignedSeriesScanUtil.hasNextPage()) {
            boolean isTsBlockOutOfBound;
            TsBlock tsBlock;
            TsBlock.TsBlockSingleColumnIterator tsBlockIterator;
            if (this.canUseCurrentPageStatistics()) {
                Statistics pageTimeStatistics = this.alignedSeriesScanUtil.currentPageTimeStatistics();
                if (pageTimeStatistics.getStartTime() > curTimeRange.getMax()) {
                    if (this.ascending) {
                        return true;
                    }
                    this.alignedSeriesScanUtil.skipCurrentPage();
                    continue;
                }
                if (this.canUseCurrentPageStatistics() && curTimeRange.contains(pageTimeStatistics.getStartTime(), pageTimeStatistics.getEndTime())) {
                    Statistics[] statisticsList = new Statistics[this.subSensorSize];
                    for (int i = 0; i < this.subSensorSize; ++i) {
                        statisticsList[i] = this.alignedSeriesScanUtil.currentPageStatistics(i);
                    }
                    this.calcFromStatistics(statisticsList);
                    this.alignedSeriesScanUtil.skipCurrentPage();
                    if (!RawDataAggregationOperator.isEndCalc(this.aggregators) || this.isGroupByQuery) continue;
                    return true;
                }
            }
            if ((tsBlockIterator = (tsBlock = this.alignedSeriesScanUtil.nextPage()).getTsBlockSingleColumnIterator()) == null || !tsBlockIterator.hasNext()) continue;
            if (this.ascending && tsBlockIterator.currentTime() > curTimeRange.getMax()) {
                this.preCachedData = tsBlock;
                return true;
            }
            this.calcFromBatch(tsBlock, curTimeRange);
            boolean bl = this.ascending ? tsBlock.getEndTime() > curTimeRange.getMax() : (isTsBlockOutOfBound = tsBlock.getEndTime() < curTimeRange.getMin());
            if (!RawDataAggregationOperator.isEndCalc(this.aggregators) && !isTsBlockOutOfBound) continue;
            return true;
        }
        return false;
    }

    private boolean readAndCalcFromChunk(TimeRange curTimeRange) throws IOException {
        while (this.alignedSeriesScanUtil.hasNextChunk()) {
            if (this.canUseCurrentChunkStatistics()) {
                Statistics chunkTimeStatistics = this.alignedSeriesScanUtil.currentChunkTimeStatistics();
                if (chunkTimeStatistics.getStartTime() > curTimeRange.getMax()) {
                    if (this.ascending) {
                        return true;
                    }
                    this.alignedSeriesScanUtil.skipCurrentChunk();
                    continue;
                }
                if (curTimeRange.contains(chunkTimeStatistics.getStartTime(), chunkTimeStatistics.getEndTime())) {
                    Statistics[] statisticsList = new Statistics[this.subSensorSize];
                    for (int i = 0; i < this.subSensorSize; ++i) {
                        statisticsList[i] = this.alignedSeriesScanUtil.currentChunkStatistics(i);
                    }
                    this.calcFromStatistics(statisticsList);
                    this.alignedSeriesScanUtil.skipCurrentChunk();
                    if (!RawDataAggregationOperator.isEndCalc(this.aggregators) || this.isGroupByQuery) continue;
                    return true;
                }
            }
            if (!this.readAndCalcFromPage(curTimeRange)) continue;
            return true;
        }
        return false;
    }

    private void calcFromStatistics(Statistics[] statistics) {
        for (int i = 0; i < this.aggregators.size(); ++i) {
            Aggregator aggregator = this.aggregators.get(i);
            if (aggregator.hasFinalResult()) continue;
            aggregator.processStatistics(statistics);
        }
    }

    public boolean canUseCurrentFileStatistics() throws IOException {
        Statistics fileStatistics = this.alignedSeriesScanUtil.currentFileTimeStatistics();
        return !this.alignedSeriesScanUtil.isFileOverlapped() && this.containedByTimeFilter(fileStatistics) && !this.alignedSeriesScanUtil.currentFileModified();
    }

    public boolean canUseCurrentChunkStatistics() throws IOException {
        Statistics chunkStatistics = this.alignedSeriesScanUtil.currentChunkTimeStatistics();
        return !this.alignedSeriesScanUtil.isChunkOverlapped() && this.containedByTimeFilter(chunkStatistics) && !this.alignedSeriesScanUtil.currentChunkModified();
    }

    public boolean canUseCurrentPageStatistics() throws IOException {
        Statistics currentPageStatistics = this.alignedSeriesScanUtil.currentPageTimeStatistics();
        if (currentPageStatistics == null) {
            return false;
        }
        return !this.alignedSeriesScanUtil.isPageOverlapped() && this.containedByTimeFilter(currentPageStatistics) && !this.alignedSeriesScanUtil.currentPageModified();
    }

    private boolean containedByTimeFilter(Statistics statistics) {
        Filter timeFilter = this.alignedSeriesScanUtil.getTimeFilter();
        return timeFilter == null || timeFilter.containStartEndTime(statistics.getStartTime(), statistics.getEndTime());
    }
}

