/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.source;

import java.io.IOException;
import java.util.HashSet;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.source.AlignedSeriesScanUtil;
import org.apache.iotdb.db.mpp.execution.operator.source.DataSourceOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class AlignedSeriesScanOperator
implements DataSourceOperator {
    private final OperatorContext operatorContext;
    private final AlignedSeriesScanUtil seriesScanUtil;
    private final PlanNodeId sourceId;
    private TsBlock tsBlock;
    private boolean hasCachedTsBlock = false;
    private boolean finished = false;

    public AlignedSeriesScanOperator(PlanNodeId sourceId, AlignedPath seriesPath, OperatorContext context, Filter timeFilter, Filter valueFilter, boolean ascending) {
        this.sourceId = sourceId;
        this.operatorContext = context;
        this.seriesScanUtil = new AlignedSeriesScanUtil(seriesPath, new HashSet<String>(seriesPath.getMeasurementList()), context.getInstanceContext(), timeFilter, valueFilter, ascending);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        if (this.hasCachedTsBlock || this.hasNext()) {
            this.hasCachedTsBlock = false;
            return this.tsBlock;
        }
        throw new IllegalStateException("no next batch");
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.hasCachedTsBlock) {
                return true;
            }
            if (this.readPageData()) {
                this.hasCachedTsBlock = true;
                return true;
            }
            if (this.readChunkData()) {
                this.hasCachedTsBlock = true;
                return true;
            }
            while (this.seriesScanUtil.hasNextFile()) {
                if (!this.readChunkData()) continue;
                this.hasCachedTsBlock = true;
                return true;
            }
            return this.hasCachedTsBlock;
        }
        catch (IOException e) {
            throw new RuntimeException("Error happened while scanning the file", e);
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished || (this.finished = !this.hasNext());
    }

    private boolean readChunkData() throws IOException {
        while (this.seriesScanUtil.hasNextChunk()) {
            if (!this.readPageData()) continue;
            return true;
        }
        return false;
    }

    private boolean readPageData() throws IOException {
        while (this.seriesScanUtil.hasNextPage()) {
            this.tsBlock = this.seriesScanUtil.nextPage();
            if (this.isEmpty(this.tsBlock)) continue;
            return true;
        }
        return false;
    }

    private boolean isEmpty(TsBlock tsBlock) {
        return tsBlock == null || tsBlock.isEmpty();
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public void initQueryDataSource(QueryDataSource dataSource) {
        this.seriesScanUtil.initQueryDataSource(dataSource);
    }
}

