/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.SchemaNodeManagementPartition;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.MeasurementNotExistException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.metadata.MetadataConstant;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.common.header.HeaderConstant;
import org.apache.iotdb.db.mpp.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.mpp.common.schematree.PathPatternTree;
import org.apache.iotdb.db.mpp.common.schematree.SchemaTree;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.analyze.ColumnPaginationController;
import org.apache.iotdb.db.mpp.plan.analyze.ConcatPathRewriter;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.mpp.plan.analyze.GroupByLevelController;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.FillDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.FilterNullParameter;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementNode;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;
import org.apache.iotdb.db.mpp.plan.statement.component.FillComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.FillPolicy;
import org.apache.iotdb.db.mpp.plan.statement.component.GroupByTimeComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.mpp.plan.statement.crud.DeleteDataStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowsOfOneDeviceStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.mpp.plan.statement.internal.InternalCreateTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.internal.LastPointFetchStatement;
import org.apache.iotdb.db.mpp.plan.statement.internal.SchemaFetchStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountDevicesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountLevelTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountNodesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowChildNodesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowChildPathsStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowClusterStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowDevicesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowTTLStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.ExplainStatement;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.GroupByFilter;
import org.apache.iotdb.tsfile.read.filter.GroupByMonthFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Analyzer {
    private static final Logger logger = LoggerFactory.getLogger(Analyzer.class);
    private final MPPQueryContext context;
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;
    private final TypeProvider typeProvider;

    public Analyzer(MPPQueryContext context, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        this.context = context;
        this.partitionFetcher = partitionFetcher;
        this.schemaFetcher = schemaFetcher;
        this.typeProvider = new TypeProvider();
    }

    public Analysis analyze(Statement statement) {
        return (Analysis)new AnalyzeVisitor().process(statement, this.context);
    }

    private String getLogHeader() {
        return String.format("Query[%s]:", this.context.getQueryId());
    }

    private GroupByFilter initGroupByFilter(GroupByTimeComponent groupByTimeComponent) {
        if (groupByTimeComponent.isIntervalByMonth() || groupByTimeComponent.isSlidingStepByMonth()) {
            return new GroupByMonthFilter(groupByTimeComponent.getInterval(), groupByTimeComponent.getSlidingStep(), groupByTimeComponent.getStartTime(), groupByTimeComponent.getEndTime(), groupByTimeComponent.isSlidingStepByMonth(), groupByTimeComponent.isIntervalByMonth(), TimeZone.getTimeZone("+00:00"));
        }
        return new GroupByFilter(groupByTimeComponent.getInterval(), groupByTimeComponent.getSlidingStep(), groupByTimeComponent.getStartTime(), groupByTimeComponent.getEndTime());
    }

    private final class AnalyzeVisitor
    extends StatementVisitor<Analysis, MPPQueryContext> {
        private AnalyzeVisitor() {
        }

        @Override
        public Analysis visitNode(StatementNode node, MPPQueryContext context) {
            throw new UnsupportedOperationException("Unsupported statement type: " + node.getClass().getName());
        }

        @Override
        public Analysis visitExplain(ExplainStatement explainStatement, MPPQueryContext context) {
            Analysis analysis = this.visitQuery(explainStatement.getQueryStatement(), context);
            analysis.setStatement(explainStatement);
            analysis.setFinishQueryAfterAnalyze(true);
            return analysis;
        }

        @Override
        public Analysis visitQuery(QueryStatement queryStatement, MPPQueryContext context) {
            Analysis analysis = new Analysis();
            try {
                List<Pair<Expression, String>> outputExpressions;
                queryStatement.semanticCheck();
                PathPatternTree patternTree = new PathPatternTree();
                queryStatement = (QueryStatement)new ConcatPathRewriter().rewrite(queryStatement, patternTree);
                analysis.setStatement(queryStatement);
                logger.info("{} fetch query schema...", (Object)Analyzer.this.getLogHeader());
                SchemaTree schemaTree = Analyzer.this.schemaFetcher.fetchSchema(patternTree);
                logger.info("{} fetch schema done", (Object)Analyzer.this.getLogHeader());
                if (schemaTree.isEmpty()) {
                    analysis.setFinishQueryAfterAnalyze(true);
                    return analysis;
                }
                Pair<Filter, Boolean> resultPair = this.analyzeGlobalTimeFilter(queryStatement);
                Filter globalTimeFilter = (Filter)resultPair.left;
                boolean hasValueFilter = (Boolean)resultPair.right;
                analysis.setGlobalTimeFilter(globalTimeFilter);
                analysis.setHasValueFilter(hasValueFilter);
                if (queryStatement.isLastQuery()) {
                    if (hasValueFilter) {
                        throw new SemanticException("Only time filters are supported in LAST query");
                    }
                    return this.analyzeLast(analysis, schemaTree.getAllMeasurement(), schemaTree);
                }
                if (queryStatement.isAlignByDevice()) {
                    HashMap<String, Set<Expression>> deviceToTransformExpressions = new HashMap<String, Set<Expression>>();
                    Set<PartialPath> deviceList = this.analyzeFrom(queryStatement, schemaTree);
                    HashMap<String, Set<String>> deviceToMeasurementsMap = new HashMap<String, Set<String>>();
                    outputExpressions = this.analyzeSelect(queryStatement, schemaTree, deviceList, deviceToTransformExpressions, deviceToMeasurementsMap);
                    HashMap<String, List<Integer>> deviceToMeasurementIndexesMap = new HashMap<String, List<Integer>>();
                    List allMeasurements = outputExpressions.stream().map(Pair::getLeft).map(Expression::getExpressionString).distinct().collect(Collectors.toList());
                    for (String deviceName : deviceToMeasurementsMap.keySet()) {
                        ArrayList measurementsUnderDevice = new ArrayList((Collection)deviceToMeasurementsMap.get(deviceName));
                        ArrayList<Integer> indexes = new ArrayList<Integer>();
                        for (Object measurement : measurementsUnderDevice) {
                            indexes.add(allMeasurements.indexOf(measurement) + 1);
                        }
                        deviceToMeasurementIndexesMap.put(deviceName, indexes);
                    }
                    analysis.setDeviceToMeasurementIndexesMap(deviceToMeasurementIndexesMap);
                    HashMap deviceToSourceExpressions = new HashMap();
                    boolean isValueFilterAggregation = queryStatement.isAggregationQuery() && hasValueFilter;
                    HashMap<String, Boolean> deviceToIsRawDataSource = new HashMap<String, Boolean>();
                    HashMap<String, Set<Expression>> deviceToAggregationExpressions = new HashMap<String, Set<Expression>>();
                    HashMap<String, Set<Expression>> deviceToAggregationTransformExpressions = new HashMap<String, Set<Expression>>();
                    for (String deviceName : deviceToTransformExpressions.keySet()) {
                        Set transformExpressions = (Set)deviceToTransformExpressions.get(deviceName);
                        LinkedHashSet<Expression> aggregationExpressions = new LinkedHashSet<Expression>();
                        LinkedHashSet<Expression> aggregationTransformExpressions = new LinkedHashSet<Expression>();
                        boolean isHasRawDataInputAggregation = false;
                        if (queryStatement.isAggregationQuery()) {
                            isHasRawDataInputAggregation = this.analyzeAggregation(transformExpressions, aggregationExpressions, aggregationTransformExpressions);
                            deviceToAggregationExpressions.put(deviceName, aggregationExpressions);
                            deviceToAggregationTransformExpressions.put(deviceName, aggregationTransformExpressions);
                        }
                        boolean isRawDataSource = !queryStatement.isAggregationQuery() || isValueFilterAggregation || isHasRawDataInputAggregation;
                        for (Expression expression : transformExpressions) {
                            this.updateSource(expression, deviceToSourceExpressions.computeIfAbsent(deviceName, key -> new LinkedHashSet()), isRawDataSource);
                        }
                        deviceToIsRawDataSource.put(deviceName, isRawDataSource);
                    }
                    analysis.setDeviceToAggregationExpressions(deviceToAggregationExpressions);
                    analysis.setDeviceToAggregationTransformExpressions(deviceToAggregationTransformExpressions);
                    analysis.setDeviceToIsRawDataSource(deviceToIsRawDataSource);
                    if (queryStatement.getWhereCondition() != null) {
                        HashMap<String, Expression> deviceToQueryFilter = new HashMap<String, Expression>();
                        Iterator<PartialPath> deviceIterator = deviceList.iterator();
                        while (deviceIterator.hasNext()) {
                            PartialPath devicePath = deviceIterator.next();
                            Expression queryFilter = null;
                            try {
                                queryFilter = this.analyzeWhereSplitByDevice(queryStatement, devicePath, schemaTree);
                            }
                            catch (SemanticException e) {
                                if (e instanceof MeasurementNotExistException) {
                                    logger.warn(e.getMessage());
                                    deviceIterator.remove();
                                    deviceToSourceExpressions.remove(devicePath.getFullPath());
                                    continue;
                                }
                                throw e;
                            }
                            deviceToQueryFilter.put(devicePath.getFullPath(), queryFilter);
                            queryFilter.inferTypes(Analyzer.this.typeProvider);
                            this.updateSource(queryFilter, deviceToSourceExpressions.computeIfAbsent(devicePath.getFullPath(), key -> new LinkedHashSet()), true);
                        }
                        analysis.setDeviceToQueryFilter(deviceToQueryFilter);
                    }
                    analysis.setDeviceToSourceExpressions(deviceToSourceExpressions);
                    analysis.setDeviceToTransformExpressions(deviceToTransformExpressions);
                } else {
                    outputExpressions = this.analyzeSelect(queryStatement, schemaTree);
                    Set transformExpressions = outputExpressions.stream().map(Pair::getLeft).collect(Collectors.toCollection(LinkedHashSet::new));
                    if (queryStatement.isGroupByLevel()) {
                        HashMap<Expression, Expression> rawPathToGroupedPathMap = new HashMap<Expression, Expression>();
                        Map<Expression, Set<Expression>> groupByLevelExpressions = this.analyzeGroupByLevel(queryStatement, outputExpressions, transformExpressions, rawPathToGroupedPathMap);
                        analysis.setGroupByLevelExpressions(groupByLevelExpressions);
                        analysis.setRawPathToGroupedPathMap(rawPathToGroupedPathMap);
                    }
                    boolean isHasRawDataInputAggregation = false;
                    if (queryStatement.isAggregationQuery()) {
                        HashSet<Expression> aggregationExpressions = new HashSet<Expression>();
                        HashSet<Expression> aggregationTransformExpressions = new HashSet<Expression>();
                        isHasRawDataInputAggregation = this.analyzeAggregation(transformExpressions, aggregationExpressions, aggregationTransformExpressions);
                        analysis.setAggregationExpressions(aggregationExpressions);
                        analysis.setAggregationTransformExpressions(aggregationTransformExpressions);
                    }
                    Iterator<Object> sourceExpressions = new HashSet<Expression>();
                    boolean isValueFilterAggregation = queryStatement.isAggregationQuery() && hasValueFilter;
                    boolean isRawDataSource = !queryStatement.isAggregationQuery() || isValueFilterAggregation || isHasRawDataInputAggregation;
                    for (Expression expression : transformExpressions) {
                        this.updateSource(expression, (Set<Expression>)((Object)sourceExpressions), isRawDataSource);
                    }
                    if (queryStatement.getWhereCondition() != null) {
                        Expression queryFilter = this.analyzeWhere(queryStatement, schemaTree);
                        queryFilter.inferTypes(Analyzer.this.typeProvider);
                        this.updateSource(queryFilter, (Set<Expression>)((Object)sourceExpressions), isRawDataSource);
                        analysis.setQueryFilter(queryFilter);
                    }
                    analysis.setRawDataSource(isRawDataSource);
                    analysis.setSourceExpressions((Set<Expression>)((Object)sourceExpressions));
                    analysis.setTransformExpressions(transformExpressions);
                }
                if (queryStatement.isGroupByTime()) {
                    analysis.setGroupByTimeParameter(new GroupByTimeParameter(queryStatement.getGroupByTimeComponent()));
                }
                if (queryStatement.getFilterNullComponent() != null) {
                    FilterNullParameter filterNullParameter = new FilterNullParameter();
                    filterNullParameter.setFilterNullPolicy(queryStatement.getFilterNullComponent().getWithoutPolicyType());
                    List<Expression> resultFilterNullColumns = queryStatement.isAlignByDevice() ? this.analyzeWithoutNullAlignByDevice(queryStatement, outputExpressions.stream().map(Pair::getLeft).collect(Collectors.toSet())) : this.analyzeWithoutNull(queryStatement, schemaTree, analysis.getTransformExpressions());
                    filterNullParameter.setFilterNullColumns(resultFilterNullColumns);
                    analysis.setFilterNullParameter(filterNullParameter);
                }
                if (queryStatement.getFillComponent() != null) {
                    TSDataType checkedDataType;
                    FillComponent fillComponent = queryStatement.getFillComponent();
                    List fillColumnList = outputExpressions.stream().map(Pair::getLeft).distinct().collect(Collectors.toList());
                    if (fillComponent.getFillPolicy() == FillPolicy.VALUE) {
                        for (Expression fillColumn : fillColumnList) {
                            checkedDataType = Analyzer.this.typeProvider.getType(fillColumn.getExpressionString());
                            if (fillComponent.getFillValue().isDataTypeConsistency(checkedDataType)) continue;
                            throw new SemanticException("FILL: the data type of the fill value should be the same as the output column");
                        }
                    } else if (fillComponent.getFillPolicy() == FillPolicy.LINEAR) {
                        for (Expression fillColumn : fillColumnList) {
                            checkedDataType = Analyzer.this.typeProvider.getType(fillColumn.getExpressionString());
                            if (checkedDataType.isNumeric()) continue;
                            throw new SemanticException(String.format("FILL: dataType %s doesn't support linear fill.", checkedDataType));
                        }
                    }
                    analysis.setFillDescriptor(new FillDescriptor(fillComponent.getFillPolicy(), fillComponent.getFillValue()));
                }
                DatasetHeader datasetHeader = this.analyzeOutput(queryStatement, outputExpressions);
                analysis.setRespDatasetHeader(datasetHeader);
                analysis.setTypeProvider(Analyzer.this.typeProvider);
                HashSet<String> deviceSet = new HashSet();
                if (queryStatement.isAlignByDevice()) {
                    deviceSet = analysis.getDeviceToSourceExpressions().keySet();
                } else {
                    for (Expression expression : analysis.getSourceExpressions()) {
                        deviceSet.add(ExpressionAnalyzer.getDeviceNameInSourceExpression(expression));
                    }
                }
                DataPartition dataPartition = this.fetchDataPartitionByDevices(deviceSet, schemaTree);
                analysis.setDataPartitionInfo(dataPartition);
            }
            catch (StatementAnalyzeException e) {
                logger.error("Meet error when analyzing the query statement: ", (Throwable)e);
                throw new StatementAnalyzeException("Meet error when analyzing the query statement: " + e.getMessage());
            }
            return analysis;
        }

        private List<Pair<Expression, String>> analyzeSelect(QueryStatement queryStatement, SchemaTree schemaTree) {
            ArrayList<Pair<Expression, String>> outputExpressions = new ArrayList<Pair<Expression, String>>();
            ColumnPaginationController paginationController = new ColumnPaginationController(queryStatement.getSeriesLimit(), queryStatement.getSeriesOffset(), queryStatement.isLastQuery() || queryStatement.isGroupByLevel());
            block0: for (ResultColumn resultColumn : queryStatement.getSelectComponent().getResultColumns()) {
                boolean hasAlias = resultColumn.hasAlias();
                List<Expression> resultExpressions = ExpressionAnalyzer.removeWildcardInExpression(resultColumn.getExpression(), schemaTree);
                if (hasAlias && !queryStatement.isGroupByLevel() && resultExpressions.size() > 1) {
                    throw new SemanticException(String.format("alias '%s' can only be matched with one time series", resultColumn.getAlias()));
                }
                for (Expression expression : resultExpressions) {
                    if (paginationController.hasCurOffset()) {
                        paginationController.consumeOffset();
                        continue;
                    }
                    if (!paginationController.hasCurLimit()) continue block0;
                    Expression expressionWithoutAlias = ExpressionAnalyzer.removeAliasFromExpression(expression);
                    String alias = !Objects.equals(expressionWithoutAlias, expression) ? expression.getExpressionString() : null;
                    alias = hasAlias ? resultColumn.getAlias() : alias;
                    outputExpressions.add((Pair<Expression, String>)new Pair((Object)expressionWithoutAlias, (Object)alias));
                    if (queryStatement.isGroupByLevel() && resultColumn.getExpression() instanceof FunctionExpression) {
                        queryStatement.getGroupByLevelComponent().updateIsCountStar((FunctionExpression)resultColumn.getExpression());
                    }
                    ExpressionAnalyzer.updateTypeProvider(expressionWithoutAlias, Analyzer.this.typeProvider);
                    expressionWithoutAlias.inferTypes(Analyzer.this.typeProvider);
                    paginationController.consumeLimit();
                }
            }
            return outputExpressions;
        }

        private Set<PartialPath> analyzeFrom(QueryStatement queryStatement, SchemaTree schemaTree) {
            List<PartialPath> devicePatternList = queryStatement.getFromComponent().getPrefixPaths();
            LinkedHashSet<PartialPath> deviceList = new LinkedHashSet<PartialPath>();
            for (PartialPath devicePattern : devicePatternList) {
                deviceList.addAll(schemaTree.getMatchedDevices(devicePattern).stream().map(DeviceSchemaInfo::getDevicePath).collect(Collectors.toList()));
            }
            return deviceList;
        }

        private List<Pair<Expression, String>> analyzeSelect(QueryStatement queryStatement, SchemaTree schemaTree, Set<PartialPath> deviceList, Map<String, Set<Expression>> deviceToTransformExpressions, Map<String, Set<String>> deviceToMeasurementsMap) {
            ArrayList<Pair<Expression, String>> outputExpressions = new ArrayList<Pair<Expression, String>>();
            ColumnPaginationController paginationController = new ColumnPaginationController(queryStatement.getSeriesLimit(), queryStatement.getSeriesOffset(), false);
            block0: for (ResultColumn resultColumn : queryStatement.getSelectComponent().getResultColumns()) {
                Expression selectExpression = resultColumn.getExpression();
                boolean hasAlias = resultColumn.hasAlias();
                LinkedHashMap<Expression, Map> measurementToDeviceTransformExpressions = new LinkedHashMap<Expression, Map>();
                for (PartialPath device : deviceList) {
                    List<Expression> transformExpressions = ExpressionAnalyzer.concatDeviceAndRemoveWildcard(selectExpression, device, schemaTree, Analyzer.this.typeProvider);
                    for (Expression transformExpression : transformExpressions) {
                        measurementToDeviceTransformExpressions.computeIfAbsent(ExpressionAnalyzer.getMeasurementExpression(transformExpression), key -> new LinkedHashMap()).put(device.getFullPath(), ExpressionAnalyzer.removeAliasFromExpression(transformExpression));
                    }
                }
                if (hasAlias && measurementToDeviceTransformExpressions.keySet().size() > 1) {
                    throw new SemanticException(String.format("alias '%s' can only be matched with one time series", resultColumn.getAlias()));
                }
                for (Expression measurementExpression : measurementToDeviceTransformExpressions.keySet()) {
                    if (paginationController.hasCurOffset()) {
                        paginationController.consumeOffset();
                        continue;
                    }
                    if (!paginationController.hasCurLimit()) continue block0;
                    Map deviceToTransformExpressionOfOneMeasurement = (Map)measurementToDeviceTransformExpressions.get(measurementExpression);
                    deviceToTransformExpressionOfOneMeasurement.values().forEach(expression -> expression.inferTypes(Analyzer.this.typeProvider));
                    this.checkDataTypeConsistencyInAlignByDevice(new ArrayList<Expression>(deviceToTransformExpressionOfOneMeasurement.values()));
                    Expression measurementExpressionWithoutAlias = ExpressionAnalyzer.removeAliasFromExpression(measurementExpression);
                    String alias = !Objects.equals(measurementExpressionWithoutAlias, measurementExpression) ? measurementExpression.getExpressionString() : null;
                    alias = hasAlias ? resultColumn.getAlias() : alias;
                    ExpressionAnalyzer.updateTypeProvider(measurementExpressionWithoutAlias, Analyzer.this.typeProvider);
                    measurementExpressionWithoutAlias.inferTypes(Analyzer.this.typeProvider);
                    outputExpressions.add((Pair<Expression, String>)new Pair((Object)measurementExpressionWithoutAlias, (Object)alias));
                    for (String deviceName : deviceToTransformExpressionOfOneMeasurement.keySet()) {
                        Expression transformExpression = (Expression)deviceToTransformExpressionOfOneMeasurement.get(deviceName);
                        ExpressionAnalyzer.updateTypeProvider(transformExpression, Analyzer.this.typeProvider);
                        transformExpression.inferTypes(Analyzer.this.typeProvider);
                        deviceToTransformExpressions.computeIfAbsent(deviceName, key -> new LinkedHashSet()).add(ExpressionAnalyzer.removeAliasFromExpression(transformExpression));
                        deviceToMeasurementsMap.computeIfAbsent(deviceName, key -> new LinkedHashSet()).add(measurementExpressionWithoutAlias.getExpressionString());
                    }
                    paginationController.consumeLimit();
                }
            }
            return outputExpressions;
        }

        private Pair<Filter, Boolean> analyzeGlobalTimeFilter(QueryStatement queryStatement) {
            Object globalTimeFilter = null;
            boolean hasValueFilter = false;
            if (queryStatement.getWhereCondition() != null) {
                Pair<Filter, Boolean> resultPair = ExpressionAnalyzer.transformToGlobalTimeFilter(queryStatement.getWhereCondition().getPredicate());
                globalTimeFilter = (Filter)resultPair.left;
                hasValueFilter = (Boolean)resultPair.right;
            }
            if (queryStatement.isGroupByTime()) {
                GroupByTimeComponent groupByTimeComponent = queryStatement.getGroupByTimeComponent();
                GroupByFilter groupByFilter = Analyzer.this.initGroupByFilter(groupByTimeComponent);
                globalTimeFilter = globalTimeFilter == null ? groupByFilter : FilterFactory.and((Filter)globalTimeFilter, (Filter)groupByFilter);
            }
            return new Pair(globalTimeFilter, (Object)hasValueFilter);
        }

        private void updateSource(Expression selectExpr, Set<Expression> sourceExpressions, boolean isRawDataSource) {
            sourceExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(selectExpr, isRawDataSource));
        }

        private boolean analyzeAggregation(Set<Expression> transformExpressions, Set<Expression> aggregationExpressions, Set<Expression> aggregationTransformExpressions) {
            boolean isHasRawDataInputAggregation = false;
            for (Expression expression : transformExpressions) {
                for (Expression aggregationExpression : ExpressionAnalyzer.searchAggregationExpressions(expression)) {
                    aggregationExpressions.add(aggregationExpression);
                    aggregationTransformExpressions.addAll(aggregationExpression.getExpressions());
                }
            }
            for (Expression aggregationTransformExpression : aggregationTransformExpressions) {
                if (!ExpressionAnalyzer.checkIsNeedTransform(aggregationTransformExpression)) continue;
                isHasRawDataInputAggregation = true;
                break;
            }
            return isHasRawDataInputAggregation;
        }

        private Expression analyzeWhere(QueryStatement queryStatement, SchemaTree schemaTree) {
            List<Expression> rewrittenPredicates = ExpressionAnalyzer.removeWildcardInQueryFilter(queryStatement.getWhereCondition().getPredicate(), queryStatement.getFromComponent().getPrefixPaths(), schemaTree, Analyzer.this.typeProvider);
            return ExpressionUtils.constructQueryFilter(rewrittenPredicates.stream().distinct().collect(Collectors.toList()));
        }

        private Expression analyzeWhereSplitByDevice(QueryStatement queryStatement, PartialPath devicePath, SchemaTree schemaTree) {
            List<Expression> rewrittenPredicates = ExpressionAnalyzer.removeWildcardInQueryFilterByDevice(queryStatement.getWhereCondition().getPredicate(), devicePath, schemaTree, Analyzer.this.typeProvider);
            return ExpressionUtils.constructQueryFilter(rewrittenPredicates.stream().distinct().collect(Collectors.toList()));
        }

        private Map<Expression, Set<Expression>> analyzeGroupByLevel(QueryStatement queryStatement, List<Pair<Expression, String>> outputExpressions, Set<Expression> transformExpressions, Map<Expression, Expression> rawPathToGroupedPathMap) {
            GroupByLevelController groupByLevelController = new GroupByLevelController(queryStatement.getGroupByLevelComponent().getLevels(), Analyzer.this.typeProvider);
            for (int i = 0; i < outputExpressions.size(); ++i) {
                Pair<Expression, String> measurementWithAlias = outputExpressions.get(i);
                boolean isCountStar = queryStatement.getGroupByLevelComponent().isCountStar(i);
                groupByLevelController.control(isCountStar, (Expression)measurementWithAlias.left, (String)measurementWithAlias.right);
            }
            Map<Expression, Set<Expression>> rawGroupByLevelExpressions = groupByLevelController.getGroupedPathMap();
            rawPathToGroupedPathMap.putAll(groupByLevelController.getRawPathToGroupedPathMap());
            LinkedHashMap<Expression, Set<Expression>> groupByLevelExpressions = new LinkedHashMap<Expression, Set<Expression>>();
            ColumnPaginationController paginationController = new ColumnPaginationController(queryStatement.getSeriesLimit(), queryStatement.getSeriesOffset(), false);
            for (Expression groupedExpression : rawGroupByLevelExpressions.keySet()) {
                if (paginationController.hasCurOffset()) {
                    paginationController.consumeOffset();
                    continue;
                }
                if (!paginationController.hasCurLimit()) break;
                groupByLevelExpressions.put(groupedExpression, rawGroupByLevelExpressions.get(groupedExpression));
                paginationController.consumeLimit();
            }
            outputExpressions.clear();
            for (Expression groupedExpression : groupByLevelExpressions.keySet()) {
                TSDataType dataType = Analyzer.this.typeProvider.getType(((Expression)new ArrayList((Collection)groupByLevelExpressions.get(groupedExpression)).get(0)).getExpressionString());
                Analyzer.this.typeProvider.setType(groupedExpression.getExpressionString(), dataType);
                outputExpressions.add((Pair<Expression, String>)new Pair((Object)groupedExpression, (Object)groupByLevelController.getAlias(groupedExpression.getExpressionString())));
            }
            transformExpressions.clear();
            transformExpressions.addAll(groupByLevelExpressions.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
            return groupByLevelExpressions;
        }

        private List<Expression> analyzeWithoutNullAlignByDevice(QueryStatement queryStatement, Set<Expression> outputExpressions) {
            ArrayList<Expression> resultFilterNullColumns = new ArrayList<Expression>();
            List<Expression> rawFilterNullColumns = queryStatement.getFilterNullComponent().getWithoutNullColumns();
            if (rawFilterNullColumns.isEmpty()) {
                resultFilterNullColumns.addAll(outputExpressions);
                return resultFilterNullColumns;
            }
            for (Expression filterNullColumn : rawFilterNullColumns) {
                if (!outputExpressions.contains(filterNullColumn)) {
                    throw new SemanticException(String.format("The without null column '%s' don't match the columns queried.", filterNullColumn));
                }
                resultFilterNullColumns.add(filterNullColumn);
            }
            return resultFilterNullColumns;
        }

        private List<Expression> analyzeWithoutNull(QueryStatement queryStatement, SchemaTree schemaTree, Set<Expression> transformExpressions) {
            ArrayList<Expression> resultFilterNullColumns = new ArrayList<Expression>();
            List<Expression> rawFilterNullColumns = queryStatement.getFilterNullComponent().getWithoutNullColumns();
            if (rawFilterNullColumns.isEmpty()) {
                resultFilterNullColumns.addAll(transformExpressions);
                return resultFilterNullColumns;
            }
            for (Expression filterNullColumn : rawFilterNullColumns) {
                List<Expression> resultExpressions = ExpressionAnalyzer.removeWildcardInExpression(filterNullColumn, schemaTree);
                for (Expression expression : resultExpressions) {
                    Expression expressionWithoutAlias = ExpressionAnalyzer.removeAliasFromExpression(expression);
                    if (!transformExpressions.contains(expressionWithoutAlias)) {
                        throw new SemanticException(String.format("The without null column '%s' don't match the columns queried.", filterNullColumn));
                    }
                    resultFilterNullColumns.add(expressionWithoutAlias);
                }
            }
            return resultFilterNullColumns;
        }

        private DatasetHeader analyzeOutput(QueryStatement queryStatement, List<Pair<Expression, String>> outputExpressions) {
            boolean isIgnoreTimestamp = queryStatement.isAggregationQuery() && !queryStatement.isGroupByTime();
            ArrayList<ColumnHeader> columnHeaders = new ArrayList<ColumnHeader>();
            if (queryStatement.isAlignByDevice()) {
                columnHeaders.add(new ColumnHeader("Device", TSDataType.TEXT, null));
                Analyzer.this.typeProvider.setType("Device", TSDataType.TEXT);
            }
            columnHeaders.addAll(outputExpressions.stream().map(expressionWithAlias -> {
                String columnName = ((Expression)expressionWithAlias.left).getExpressionString();
                String alias = (String)expressionWithAlias.right;
                return new ColumnHeader(columnName, Analyzer.this.typeProvider.getType(columnName), alias);
            }).collect(Collectors.toList()));
            return new DatasetHeader(columnHeaders, isIgnoreTimestamp);
        }

        private Analysis analyzeLast(Analysis analysis, List<MeasurementPath> allSelectedPath, SchemaTree schemaTree) {
            Set sourceExpressions = allSelectedPath.stream().map(TimeSeriesOperand::new).collect(Collectors.toCollection(LinkedHashSet::new));
            sourceExpressions.forEach(expression -> ExpressionAnalyzer.updateTypeProvider(expression, Analyzer.this.typeProvider));
            analysis.setSourceExpressions(sourceExpressions);
            analysis.setRespDatasetHeader(HeaderConstant.LAST_QUERY_HEADER);
            Analyzer.this.typeProvider.setType("timeseries", TSDataType.TEXT);
            Analyzer.this.typeProvider.setType("value", TSDataType.TEXT);
            Analyzer.this.typeProvider.setType("dataType", TSDataType.TEXT);
            Set deviceSet = allSelectedPath.stream().map(PartialPath::getDevice).collect(Collectors.toSet());
            HashMap<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap = new HashMap<String, List<DataPartitionQueryParam>>();
            for (String devicePath : deviceSet) {
                DataPartitionQueryParam queryParam = new DataPartitionQueryParam();
                queryParam.setDevicePath(devicePath);
                sgNameToQueryParamsMap.computeIfAbsent(schemaTree.getBelongedStorageGroup(devicePath), key -> new ArrayList()).add(queryParam);
            }
            DataPartition dataPartition = Analyzer.this.partitionFetcher.getDataPartition(sgNameToQueryParamsMap);
            analysis.setDataPartitionInfo(dataPartition);
            return analysis;
        }

        private DataPartition fetchDataPartitionByDevices(Set<String> deviceSet, SchemaTree schemaTree) {
            HashMap<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap = new HashMap<String, List<DataPartitionQueryParam>>();
            for (String devicePath : deviceSet) {
                DataPartitionQueryParam queryParam = new DataPartitionQueryParam();
                queryParam.setDevicePath(devicePath);
                sgNameToQueryParamsMap.computeIfAbsent(schemaTree.getBelongedStorageGroup(devicePath), key -> new ArrayList()).add(queryParam);
            }
            return Analyzer.this.partitionFetcher.getDataPartition(sgNameToQueryParamsMap);
        }

        private void checkDataTypeConsistencyInAlignByDevice(List<Expression> expressions) {
            TSDataType checkedDataType = Analyzer.this.typeProvider.getType(expressions.get(0).getExpressionString());
            for (Expression expression : expressions) {
                if (Analyzer.this.typeProvider.getType(expression.getExpressionString()) == checkedDataType) continue;
                throw new SemanticException("ALIGN BY DEVICE: the data types of the same measurement column should be the same across devices.");
            }
        }

        @Override
        public Analysis visitLastPointFetch(LastPointFetchStatement statement, MPPQueryContext context) {
            context.setQueryType(QueryType.READ);
            Analysis analysis = new Analysis();
            analysis.setStatement(statement);
            SchemaTree schemaTree = new SchemaTree();
            schemaTree.setStorageGroups(statement.getStorageGroups());
            return this.analyzeLast(analysis, statement.getSelectedPaths(), schemaTree);
        }

        @Override
        public Analysis visitInsert(InsertStatement insertStatement, MPPQueryContext context) {
            context.setQueryType(QueryType.WRITE);
            insertStatement.semanticCheck();
            long[] timeArray = insertStatement.getTimes();
            PartialPath devicePath = insertStatement.getDevice();
            String[] measurements = insertStatement.getMeasurementList();
            if (timeArray.length == 1) {
                InsertRowStatement insertRowStatement = new InsertRowStatement();
                insertRowStatement.setDevicePath(devicePath);
                insertRowStatement.setTime(timeArray[0]);
                insertRowStatement.setMeasurements(measurements);
                insertRowStatement.setDataTypes(new TSDataType[insertStatement.getMeasurementList().length]);
                Object[] values = new Object[insertStatement.getMeasurementList().length];
                System.arraycopy(insertStatement.getValuesList().get(0), 0, values, 0, values.length);
                insertRowStatement.setValues(values);
                insertRowStatement.setNeedInferType(true);
                insertRowStatement.setAligned(insertStatement.isAligned());
                return insertRowStatement.accept(this, context);
            }
            InsertRowsStatement insertRowsStatement = new InsertRowsStatement();
            ArrayList<InsertRowStatement> insertRowStatementList = new ArrayList<InsertRowStatement>();
            for (int i = 0; i < timeArray.length; ++i) {
                InsertRowStatement statement = new InsertRowStatement();
                statement.setDevicePath(devicePath);
                statement.setMeasurements(measurements);
                statement.setTime(timeArray[i]);
                statement.setDataTypes(new TSDataType[insertStatement.getMeasurementList().length]);
                Object[] values = new Object[insertStatement.getMeasurementList().length];
                System.arraycopy(insertStatement.getValuesList().get(i), 0, values, 0, values.length);
                statement.setValues(values);
                statement.setAligned(insertStatement.isAligned());
                statement.setNeedInferType(true);
                insertRowStatementList.add(statement);
            }
            insertRowsStatement.setInsertRowStatementList(insertRowStatementList);
            return insertRowsStatement.accept(this, context);
        }

        @Override
        public Analysis visitCreateTimeseries(CreateTimeSeriesStatement createTimeSeriesStatement, MPPQueryContext context) {
            context.setQueryType(QueryType.WRITE);
            if (createTimeSeriesStatement.getTags() != null && !createTimeSeriesStatement.getTags().isEmpty() && createTimeSeriesStatement.getAttributes() != null && !createTimeSeriesStatement.getAttributes().isEmpty()) {
                for (String tagKey : createTimeSeriesStatement.getTags().keySet()) {
                    if (!createTimeSeriesStatement.getAttributes().containsKey(tagKey)) continue;
                    throw new SemanticException(String.format("Tag and attribute shouldn't have the same property key [%s]", tagKey));
                }
            }
            Analysis analysis = new Analysis();
            analysis.setStatement(createTimeSeriesStatement);
            PathPatternTree patternTree = new PathPatternTree();
            patternTree.appendFullPath(createTimeSeriesStatement.getPath());
            SchemaPartition schemaPartitionInfo = Analyzer.this.partitionFetcher.getOrCreateSchemaPartition(patternTree);
            analysis.setSchemaPartitionInfo(schemaPartitionInfo);
            return analysis;
        }

        @Override
        public Analysis visitCreateAlignedTimeseries(CreateAlignedTimeSeriesStatement createAlignedTimeSeriesStatement, MPPQueryContext context) {
            context.setQueryType(QueryType.WRITE);
            List<String> measurements = createAlignedTimeSeriesStatement.getMeasurements();
            HashSet<String> measurementsSet = new HashSet<String>(measurements);
            if (measurementsSet.size() < measurements.size()) {
                throw new SemanticException("Measurement under an aligned device is not allowed to have the same measurement name");
            }
            Analysis analysis = new Analysis();
            analysis.setStatement(createAlignedTimeSeriesStatement);
            PathPatternTree pathPatternTree = new PathPatternTree();
            for (String measurement : createAlignedTimeSeriesStatement.getMeasurements()) {
                pathPatternTree.appendFullPath(createAlignedTimeSeriesStatement.getDevicePath(), measurement);
            }
            SchemaPartition schemaPartitionInfo = Analyzer.this.partitionFetcher.getOrCreateSchemaPartition(pathPatternTree);
            analysis.setSchemaPartitionInfo(schemaPartitionInfo);
            return analysis;
        }

        @Override
        public Analysis visitInternalCreateTimeseries(InternalCreateTimeSeriesStatement internalCreateTimeSeriesStatement, MPPQueryContext context) {
            context.setQueryType(QueryType.WRITE);
            Analysis analysis = new Analysis();
            analysis.setStatement(internalCreateTimeSeriesStatement);
            PathPatternTree pathPatternTree = new PathPatternTree();
            for (String measurement : internalCreateTimeSeriesStatement.getMeasurements()) {
                pathPatternTree.appendFullPath(internalCreateTimeSeriesStatement.getDevicePath(), measurement);
            }
            SchemaPartition schemaPartitionInfo = Analyzer.this.partitionFetcher.getOrCreateSchemaPartition(pathPatternTree);
            analysis.setSchemaPartitionInfo(schemaPartitionInfo);
            return analysis;
        }

        @Override
        public Analysis visitCreateMultiTimeseries(CreateMultiTimeSeriesStatement createMultiTimeSeriesStatement, MPPQueryContext context) {
            context.setQueryType(QueryType.WRITE);
            Analysis analysis = new Analysis();
            analysis.setStatement(createMultiTimeSeriesStatement);
            PathPatternTree patternTree = new PathPatternTree();
            for (PartialPath path : createMultiTimeSeriesStatement.getPaths()) {
                patternTree.appendFullPath(path);
            }
            SchemaPartition schemaPartitionInfo = Analyzer.this.partitionFetcher.getOrCreateSchemaPartition(patternTree);
            analysis.setSchemaPartitionInfo(schemaPartitionInfo);
            return analysis;
        }

        @Override
        public Analysis visitAlterTimeseries(AlterTimeSeriesStatement alterTimeSeriesStatement, MPPQueryContext context) {
            context.setQueryType(QueryType.WRITE);
            Analysis analysis = new Analysis();
            analysis.setStatement(alterTimeSeriesStatement);
            PathPatternTree patternTree = new PathPatternTree();
            patternTree.appendFullPath(alterTimeSeriesStatement.getPath());
            SchemaPartition schemaPartitionInfo = Analyzer.this.partitionFetcher.getSchemaPartition(patternTree);
            analysis.setSchemaPartitionInfo(schemaPartitionInfo);
            return analysis;
        }

        @Override
        public Analysis visitInsertTablet(InsertTabletStatement insertTabletStatement, MPPQueryContext context) {
            context.setQueryType(QueryType.WRITE);
            DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
            dataPartitionQueryParam.setDevicePath(insertTabletStatement.getDevicePath().getFullPath());
            dataPartitionQueryParam.setTimePartitionSlotList(insertTabletStatement.getTimePartitionSlots());
            DataPartition dataPartition = Analyzer.this.partitionFetcher.getOrCreateDataPartition(Collections.singletonList(dataPartitionQueryParam));
            Analysis analysis = new Analysis();
            analysis.setStatement(insertTabletStatement);
            analysis.setDataPartitionInfo(dataPartition);
            return analysis;
        }

        @Override
        public Analysis visitInsertRow(InsertRowStatement insertRowStatement, MPPQueryContext context) {
            context.setQueryType(QueryType.WRITE);
            DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
            dataPartitionQueryParam.setDevicePath(insertRowStatement.getDevicePath().getFullPath());
            dataPartitionQueryParam.setTimePartitionSlotList(insertRowStatement.getTimePartitionSlots());
            DataPartition dataPartition = Analyzer.this.partitionFetcher.getOrCreateDataPartition(Collections.singletonList(dataPartitionQueryParam));
            Analysis analysis = new Analysis();
            analysis.setStatement(insertRowStatement);
            analysis.setDataPartitionInfo(dataPartition);
            return analysis;
        }

        @Override
        public Analysis visitInsertRows(InsertRowsStatement insertRowsStatement, MPPQueryContext context) {
            context.setQueryType(QueryType.WRITE);
            ArrayList<DataPartitionQueryParam> dataPartitionQueryParams = new ArrayList<DataPartitionQueryParam>();
            for (InsertRowStatement insertRowStatement : insertRowsStatement.getInsertRowStatementList()) {
                DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
                dataPartitionQueryParam.setDevicePath(insertRowStatement.getDevicePath().getFullPath());
                dataPartitionQueryParam.setTimePartitionSlotList(insertRowStatement.getTimePartitionSlots());
                dataPartitionQueryParams.add(dataPartitionQueryParam);
            }
            DataPartition dataPartition = Analyzer.this.partitionFetcher.getOrCreateDataPartition(dataPartitionQueryParams);
            Analysis analysis = new Analysis();
            analysis.setStatement(insertRowsStatement);
            analysis.setDataPartitionInfo(dataPartition);
            return analysis;
        }

        @Override
        public Analysis visitInsertMultiTablets(InsertMultiTabletsStatement insertMultiTabletsStatement, MPPQueryContext context) {
            context.setQueryType(QueryType.WRITE);
            ArrayList<DataPartitionQueryParam> dataPartitionQueryParams = new ArrayList<DataPartitionQueryParam>();
            for (InsertTabletStatement insertTabletStatement : insertMultiTabletsStatement.getInsertTabletStatementList()) {
                DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
                dataPartitionQueryParam.setDevicePath(insertTabletStatement.getDevicePath().getFullPath());
                dataPartitionQueryParam.setTimePartitionSlotList(insertTabletStatement.getTimePartitionSlots());
                dataPartitionQueryParams.add(dataPartitionQueryParam);
            }
            DataPartition dataPartition = Analyzer.this.partitionFetcher.getOrCreateDataPartition(dataPartitionQueryParams);
            Analysis analysis = new Analysis();
            analysis.setStatement(insertMultiTabletsStatement);
            analysis.setDataPartitionInfo(dataPartition);
            return analysis;
        }

        @Override
        public Analysis visitInsertRowsOfOneDevice(InsertRowsOfOneDeviceStatement insertRowsOfOneDeviceStatement, MPPQueryContext context) {
            context.setQueryType(QueryType.WRITE);
            DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
            dataPartitionQueryParam.setDevicePath(insertRowsOfOneDeviceStatement.getDevicePath().getFullPath());
            dataPartitionQueryParam.setTimePartitionSlotList(insertRowsOfOneDeviceStatement.getTimePartitionSlots());
            DataPartition dataPartition = Analyzer.this.partitionFetcher.getOrCreateDataPartition(Collections.singletonList(dataPartitionQueryParam));
            Analysis analysis = new Analysis();
            analysis.setStatement(insertRowsOfOneDeviceStatement);
            analysis.setDataPartitionInfo(dataPartition);
            return analysis;
        }

        @Override
        public Analysis visitShowTimeSeries(ShowTimeSeriesStatement showTimeSeriesStatement, MPPQueryContext context) {
            Analysis analysis = new Analysis();
            analysis.setStatement(showTimeSeriesStatement);
            PathPatternTree patternTree = new PathPatternTree();
            patternTree.appendPathPattern(showTimeSeriesStatement.getPathPattern());
            SchemaPartition schemaPartitionInfo = Analyzer.this.partitionFetcher.getSchemaPartition(patternTree);
            analysis.setSchemaPartitionInfo(schemaPartitionInfo);
            if (showTimeSeriesStatement.isOrderByHeat()) {
                patternTree.constructTree();
                logger.info("{} fetch query schema...", (Object)Analyzer.this.getLogHeader());
                SchemaTree schemaTree = Analyzer.this.schemaFetcher.fetchSchema(patternTree);
                logger.info("{} fetch schema done", (Object)Analyzer.this.getLogHeader());
                List<MeasurementPath> allSelectedPath = schemaTree.getAllMeasurement();
                Set sourceExpressions = allSelectedPath.stream().map(TimeSeriesOperand::new).collect(Collectors.toCollection(LinkedHashSet::new));
                analysis.setSourceExpressions(sourceExpressions);
                Set deviceSet = allSelectedPath.stream().map(PartialPath::getDevice).collect(Collectors.toSet());
                HashMap<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap = new HashMap<String, List<DataPartitionQueryParam>>();
                for (String devicePath : deviceSet) {
                    DataPartitionQueryParam queryParam = new DataPartitionQueryParam();
                    queryParam.setDevicePath(devicePath);
                    sgNameToQueryParamsMap.computeIfAbsent(schemaTree.getBelongedStorageGroup(devicePath), key -> new ArrayList()).add(queryParam);
                }
                DataPartition dataPartition = Analyzer.this.partitionFetcher.getDataPartition(sgNameToQueryParamsMap);
                analysis.setDataPartitionInfo(dataPartition);
            }
            analysis.setRespDatasetHeader(HeaderConstant.showTimeSeriesHeader);
            return analysis;
        }

        @Override
        public Analysis visitShowStorageGroup(ShowStorageGroupStatement showStorageGroupStatement, MPPQueryContext context) {
            Analysis analysis = new Analysis();
            analysis.setStatement(showStorageGroupStatement);
            analysis.setRespDatasetHeader(HeaderConstant.showStorageGroupHeader);
            return analysis;
        }

        @Override
        public Analysis visitShowTTL(ShowTTLStatement showTTLStatement, MPPQueryContext context) {
            Analysis analysis = new Analysis();
            analysis.setStatement(showTTLStatement);
            analysis.setRespDatasetHeader(HeaderConstant.showTTLHeader);
            return analysis;
        }

        @Override
        public Analysis visitShowDevices(ShowDevicesStatement showDevicesStatement, MPPQueryContext context) {
            Analysis analysis = new Analysis();
            analysis.setStatement(showDevicesStatement);
            PathPatternTree patternTree = new PathPatternTree();
            patternTree.appendPathPattern(showDevicesStatement.getPathPattern().concatNode("*"));
            SchemaPartition schemaPartitionInfo = Analyzer.this.partitionFetcher.getSchemaPartition(patternTree);
            analysis.setSchemaPartitionInfo(schemaPartitionInfo);
            analysis.setRespDatasetHeader(showDevicesStatement.hasSgCol() ? HeaderConstant.showDevicesWithSgHeader : HeaderConstant.showDevicesHeader);
            return analysis;
        }

        @Override
        public Analysis visitShowCluster(ShowClusterStatement showClusterStatement, MPPQueryContext context) {
            Analysis analysis = new Analysis();
            analysis.setStatement(showClusterStatement);
            analysis.setRespDatasetHeader(HeaderConstant.showClusterHeader);
            return analysis;
        }

        @Override
        public Analysis visitCountStorageGroup(CountStorageGroupStatement countStorageGroupStatement, MPPQueryContext context) {
            Analysis analysis = new Analysis();
            analysis.setStatement(countStorageGroupStatement);
            analysis.setRespDatasetHeader(HeaderConstant.countStorageGroupHeader);
            return analysis;
        }

        @Override
        public Analysis visitSchemaFetch(SchemaFetchStatement schemaFetchStatement, MPPQueryContext context) {
            Analysis analysis = new Analysis();
            analysis.setStatement(schemaFetchStatement);
            analysis.setSchemaPartitionInfo(schemaFetchStatement.getSchemaPartition());
            return analysis;
        }

        @Override
        public Analysis visitCountDevices(CountDevicesStatement countDevicesStatement, MPPQueryContext context) {
            Analysis analysis = new Analysis();
            analysis.setStatement(countDevicesStatement);
            PathPatternTree patternTree = new PathPatternTree();
            patternTree.appendPathPattern(countDevicesStatement.getPartialPath().concatNode("*"));
            SchemaPartition schemaPartitionInfo = Analyzer.this.partitionFetcher.getSchemaPartition(patternTree);
            analysis.setSchemaPartitionInfo(schemaPartitionInfo);
            analysis.setRespDatasetHeader(HeaderConstant.countDevicesHeader);
            return analysis;
        }

        @Override
        public Analysis visitCountTimeSeries(CountTimeSeriesStatement countTimeSeriesStatement, MPPQueryContext context) {
            Analysis analysis = new Analysis();
            analysis.setStatement(countTimeSeriesStatement);
            PathPatternTree patternTree = new PathPatternTree();
            patternTree.appendPathPattern(countTimeSeriesStatement.getPartialPath());
            SchemaPartition schemaPartitionInfo = Analyzer.this.partitionFetcher.getSchemaPartition(patternTree);
            analysis.setSchemaPartitionInfo(schemaPartitionInfo);
            analysis.setRespDatasetHeader(HeaderConstant.countTimeSeriesHeader);
            return analysis;
        }

        @Override
        public Analysis visitCountLevelTimeSeries(CountLevelTimeSeriesStatement countLevelTimeSeriesStatement, MPPQueryContext context) {
            Analysis analysis = new Analysis();
            analysis.setStatement(countLevelTimeSeriesStatement);
            PathPatternTree patternTree = new PathPatternTree();
            patternTree.appendPathPattern(countLevelTimeSeriesStatement.getPartialPath());
            SchemaPartition schemaPartitionInfo = Analyzer.this.partitionFetcher.getSchemaPartition(patternTree);
            analysis.setSchemaPartitionInfo(schemaPartitionInfo);
            analysis.setRespDatasetHeader(HeaderConstant.countLevelTimeSeriesHeader);
            return analysis;
        }

        @Override
        public Analysis visitCountNodes(CountNodesStatement countStatement, MPPQueryContext context) {
            Analysis analysis = new Analysis();
            analysis.setStatement(countStatement);
            PathPatternTree patternTree = new PathPatternTree();
            patternTree.appendPathPattern(countStatement.getPartialPath());
            SchemaNodeManagementPartition schemaNodeManagementPartition = Analyzer.this.partitionFetcher.getSchemaNodeManagementPartitionWithLevel(patternTree, countStatement.getLevel());
            if (schemaNodeManagementPartition == null) {
                return analysis;
            }
            if (!schemaNodeManagementPartition.getMatchedNode().isEmpty() && schemaNodeManagementPartition.getSchemaPartition().getSchemaPartitionMap().size() == 0) {
                analysis.setFinishQueryAfterAnalyze(true);
            }
            analysis.setMatchedNodes(schemaNodeManagementPartition.getMatchedNode());
            analysis.setSchemaPartitionInfo(schemaNodeManagementPartition.getSchemaPartition());
            analysis.setRespDatasetHeader(HeaderConstant.countNodesHeader);
            return analysis;
        }

        @Override
        public Analysis visitShowChildPaths(ShowChildPathsStatement showChildPathsStatement, MPPQueryContext context) {
            return this.visitSchemaNodeManagementPartition(showChildPathsStatement, showChildPathsStatement.getPartialPath(), HeaderConstant.showChildPathsHeader);
        }

        @Override
        public Analysis visitShowChildNodes(ShowChildNodesStatement showChildNodesStatement, MPPQueryContext context) {
            return this.visitSchemaNodeManagementPartition(showChildNodesStatement, showChildNodesStatement.getPartialPath(), HeaderConstant.showChildNodesHeader);
        }

        private Analysis visitSchemaNodeManagementPartition(Statement statement, PartialPath path, DatasetHeader header) {
            Analysis analysis = new Analysis();
            analysis.setStatement(statement);
            PathPatternTree patternTree = new PathPatternTree();
            patternTree.appendPathPattern(path);
            SchemaNodeManagementPartition schemaNodeManagementPartition = Analyzer.this.partitionFetcher.getSchemaNodeManagementPartition(patternTree);
            if (schemaNodeManagementPartition == null) {
                return analysis;
            }
            if (!schemaNodeManagementPartition.getMatchedNode().isEmpty() && schemaNodeManagementPartition.getSchemaPartition().getSchemaPartitionMap().size() == 0) {
                analysis.setFinishQueryAfterAnalyze(true);
            }
            analysis.setMatchedNodes(schemaNodeManagementPartition.getMatchedNode());
            analysis.setSchemaPartitionInfo(schemaNodeManagementPartition.getSchemaPartition());
            analysis.setRespDatasetHeader(header);
            return analysis;
        }

        @Override
        public Analysis visitDeleteData(DeleteDataStatement deleteDataStatement, MPPQueryContext context) {
            context.setQueryType(QueryType.WRITE);
            Analysis analysis = new Analysis();
            analysis.setStatement(deleteDataStatement);
            PathPatternTree patternTree = new PathPatternTree();
            for (PartialPath pathPattern : deleteDataStatement.getPathList()) {
                patternTree.appendPathPattern(pathPattern);
            }
            SchemaPartition schemaPartition = Analyzer.this.partitionFetcher.getSchemaPartition(patternTree);
            SchemaTree schemaTree = Analyzer.this.schemaFetcher.fetchSchema(patternTree, schemaPartition);
            analysis.setSchemaTree(schemaTree);
            HashMap<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap = new HashMap<String, List<DataPartitionQueryParam>>();
            Map schemaPartitionMap = schemaPartition.getSchemaPartitionMap();
            if (IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
                for (String storageGroup : schemaPartitionMap.keySet()) {
                    sgNameToQueryParamsMap.put(storageGroup, ((Map)schemaPartitionMap.get(storageGroup)).keySet().stream().map(DataPartitionQueryParam::new).collect(Collectors.toList()));
                }
            } else {
                schemaTree.getMatchedDevices(new PartialPath(MetadataConstant.ALL_RESULT_NODES)).forEach(deviceSchemaInfo -> {
                    PartialPath devicePath = deviceSchemaInfo.getDevicePath();
                    DataPartitionQueryParam queryParam = new DataPartitionQueryParam();
                    queryParam.setDevicePath(devicePath.getFullPath());
                    sgNameToQueryParamsMap.computeIfAbsent(schemaTree.getBelongedStorageGroup(devicePath), key -> new ArrayList()).add(queryParam);
                });
            }
            DataPartition dataPartition = Analyzer.this.partitionFetcher.getDataPartition(sgNameToQueryParamsMap);
            analysis.setDataPartitionInfo(dataPartition);
            return analysis;
        }
    }
}

