/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.statement.sys.FlushStatement;

public class FlushTask
implements IConfigTask {
    private FlushStatement flushStatement;

    public FlushTask(FlushStatement flushStatement) {
        this.flushStatement = flushStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        TFlushReq tFlushReq = new TFlushReq();
        ArrayList<String> storageGroups = new ArrayList<String>();
        if (this.flushStatement.getStorageGroups() != null) {
            for (PartialPath partialPath : this.flushStatement.getStorageGroups()) {
                storageGroups.add(partialPath.getFullPath());
            }
            tFlushReq.setStorageGroups(storageGroups);
        }
        if (this.flushStatement.isSeq() != null) {
            tFlushReq.setIsSeq(this.flushStatement.isSeq().toString());
        }
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        if (this.flushStatement.isCluster()) {
            tFlushReq.setDataNodeId(-1);
        } else {
            tFlushReq.setDataNodeId(config.getDataNodeId());
        }
        return configTaskExecutor.flush(tFlushReq);
    }
}

