/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TRegionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionResp;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.common.header.HeaderConstant;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowRegionStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class ShowRegionTask
implements IConfigTask {
    private ShowRegionStatement showRegionStatement;

    public ShowRegionTask() {
    }

    public ShowRegionTask(ShowRegionStatement showRegionStatement) {
        this.showRegionStatement = showRegionStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showRegion(this.showRegionStatement);
    }

    public static void buildTSBlock(TShowRegionResp showRegionResp, SettableFuture<ConfigTaskResult> future) {
        TsBlockBuilder builder = new TsBlockBuilder(HeaderConstant.showRegionHeader.getRespDataTypes());
        if (showRegionResp.getRegionInfoList() != null) {
            for (TRegionInfo regionInfo : showRegionResp.getRegionInfoList()) {
                builder.getTimeColumnBuilder().writeLong(0L);
                builder.getColumnBuilder(0).writeInt(regionInfo.getConsensusGroupId().getId());
                if (regionInfo.getConsensusGroupId().getType().ordinal() == TConsensusGroupType.SchemaRegion.ordinal()) {
                    builder.getColumnBuilder(1).writeBinary(Binary.valueOf((String)String.valueOf(TConsensusGroupType.SchemaRegion)));
                } else if (regionInfo.getConsensusGroupId().getType().ordinal() == TConsensusGroupType.DataRegion.ordinal()) {
                    builder.getColumnBuilder(1).writeBinary(Binary.valueOf((String)String.valueOf(TConsensusGroupType.DataRegion)));
                }
                builder.getColumnBuilder(2).writeBinary(Binary.valueOf((String)(regionInfo.getStatus() == null ? "" : regionInfo.getStatus())));
                builder.getColumnBuilder(3).writeBinary(Binary.valueOf((String)regionInfo.getStorageGroup()));
                builder.getColumnBuilder(4).writeLong(regionInfo.getSlots());
                builder.getColumnBuilder(5).writeInt(regionInfo.getDataNodeId());
                builder.getColumnBuilder(6).writeBinary(Binary.valueOf((String)regionInfo.getClientRpcIp()));
                builder.getColumnBuilder(7).writeInt(regionInfo.getClientRpcPort());
                builder.declarePosition();
            }
        }
        DatasetHeader datasetHeader = HeaderConstant.showRegionHeader;
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

