/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config.executor;

import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.udf.service.UDFExecutableManager;
import org.apache.iotdb.commons.udf.service.UDFRegistrationService;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.db.localconfignode.LocalConfigNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.CountStorageGroupTask;
import org.apache.iotdb.db.mpp.plan.execution.config.ShowStorageGroupTask;
import org.apache.iotdb.db.mpp.plan.execution.config.ShowTTLTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DeleteStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.SetStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.SetTTLStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowRegionStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowTTLStatement;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneConfigTaskExecutor
implements IConfigTaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneConfigTaskExecutor.class);

    public static StandaloneConfigTaskExecutor getInstance() {
        return StandaloneConfigTaskExecutorHolder.INSTANCE;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setStorageGroup(SetStorageGroupStatement setStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        try {
            LocalConfigNode localConfigNode = LocalConfigNode.getInstance();
            localConfigNode.setStorageGroup(setStorageGroupStatement.getStorageGroupPath());
            if (setStorageGroupStatement.getTTL() != null) {
                localConfigNode.setTTL(setStorageGroupStatement.getStorageGroupPath(), setStorageGroupStatement.getTTL());
            }
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        }
        catch (Exception e) {
            LOGGER.error("Failed to set storage group, caused by ", (Throwable)e);
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showStorageGroup(ShowStorageGroupStatement showStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        HashMap<String, TStorageGroupSchema> storageGroupSchemaMap = new HashMap<String, TStorageGroupSchema>();
        try {
            LocalConfigNode localConfigNode = LocalConfigNode.getInstance();
            List<PartialPath> partialPaths = localConfigNode.getMatchedStorageGroups(showStorageGroupStatement.getPathPattern(), showStorageGroupStatement.isPrefixPath());
            for (PartialPath storageGroupPath : partialPaths) {
                IStorageGroupMNode storageGroupMNode = localConfigNode.getStorageGroupNodeByPath(storageGroupPath);
                String storageGroup = storageGroupMNode.getFullPath();
                TStorageGroupSchema storageGroupSchema = storageGroupMNode.getStorageGroupSchema();
                storageGroupSchemaMap.put(storageGroup, storageGroupSchema);
            }
            ShowStorageGroupTask.buildTSBlock(storageGroupSchemaMap, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (MetadataException e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> countStorageGroup(CountStorageGroupStatement countStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        try {
            int storageGroupNum = LocalConfigNode.getInstance().getStorageGroupNum(countStorageGroupStatement.getPartialPath(), countStorageGroupStatement.isPrefixPath());
            CountStorageGroupTask.buildTSBlock(storageGroupNum, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (MetadataException e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createFunction(String udfName, String className, List<String> uris) {
        SettableFuture future = SettableFuture.create();
        try {
            UDFRegistrationService.getInstance().register(udfName, className, uris, UDFExecutableManager.getInstance(), true);
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        }
        catch (Exception e) {
            String message = String.format("Failed to create function %s(%s), URI: %s, because %s.", udfName, className, uris, e.getMessage());
            LOGGER.error(message, (Throwable)e);
            future.setException((Throwable)new StatementExecutionException(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(message)));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> deleteStorageGroup(DeleteStorageGroupStatement deleteStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        try {
            ArrayList<PartialPath> deletePathList = new ArrayList<PartialPath>();
            for (String path : deleteStorageGroupStatement.getPrefixPath()) {
                PartialPath prefixPath = new PartialPath(path);
                deletePathList.addAll(LocalConfigNode.getInstance().getMatchedStorageGroups(prefixPath, false));
            }
            if (deletePathList.isEmpty()) {
                future.setException((Throwable)new IoTDBException(String.format("Path %s does not exist", Arrays.toString(deleteStorageGroupStatement.getPrefixPath().toArray())), TSStatusCode.TIMESERIES_NOT_EXIST.getStatusCode()));
                return future;
            }
            LocalConfigNode.getInstance().deleteStorageGroups(deletePathList);
        }
        catch (MetadataException e) {
            future.setException((Throwable)e);
            return future;
        }
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropFunction(String udfName) {
        SettableFuture future = SettableFuture.create();
        try {
            UDFRegistrationService.getInstance().deregister(udfName);
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        }
        catch (Exception e) {
            String message = String.format("Failed to drop function %s, because %s.", udfName, e.getMessage());
            LOGGER.error(message, (Throwable)e);
            future.setException((Throwable)new StatementExecutionException(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(message)));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setTTL(SetTTLStatement setTTLStatement, String taskName) {
        SettableFuture future = SettableFuture.create();
        try {
            LocalConfigNode.getInstance().setTTL(setTTLStatement.getStorageGroupPath(), setTTLStatement.getTTL());
        }
        catch (IOException | MetadataException e) {
            future.setException(e);
        }
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> flush(TFlushReq tFlushReq) {
        SettableFuture future = SettableFuture.create();
        LocalConfigNode localConfigNode = LocalConfigNode.getInstance();
        TSStatus tsStatus = localConfigNode.executeFlushOperation(tFlushReq);
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new StatementExecutionException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showCluster() {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new StatementExecutionException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Executing show cluster in standalone mode is not supported")));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showTTL(ShowTTLStatement showTTLStatement) {
        SettableFuture future = SettableFuture.create();
        List<PartialPath> storageGroupPaths = showTTLStatement.getPaths();
        HashMap<String, Long> storageGroupToTTL = new HashMap<String, Long>();
        try {
            Map<PartialPath, Long> allStorageGroupToTTL = LocalConfigNode.getInstance().getStorageGroupsTTL();
            for (PartialPath storageGroupPath : storageGroupPaths) {
                if (showTTLStatement.isAll()) {
                    storageGroupToTTL.put(storageGroupPath.getFullPath(), allStorageGroupToTTL.get(storageGroupPath));
                    continue;
                }
                List<PartialPath> matchedStorageGroupPaths = LocalConfigNode.getInstance().getMatchedStorageGroups(storageGroupPath, showTTLStatement.isPrefixPath());
                for (PartialPath matchedStorageGroupPath : matchedStorageGroupPaths) {
                    storageGroupToTTL.put(matchedStorageGroupPath.getFullPath(), allStorageGroupToTTL.get(matchedStorageGroupPath));
                }
            }
        }
        catch (MetadataException e) {
            future.setException((Throwable)e);
        }
        ShowTTLTask.buildTSBlock(storageGroupToTTL, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showRegion(ShowRegionStatement showRegionStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new StatementExecutionException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Executing show regions in standalone mode is not supported")));
        return future;
    }

    private static final class StandaloneConfigTaskExecutorHolder {
        private static final StandaloneConfigTaskExecutor INSTANCE = new StandaloneConfigTaskExecutor();

        private StandaloneConfigTaskExecutorHolder() {
        }
    }
}

