/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.distribution;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.db.mpp.plan.planner.distribution.NodeDistribution;
import org.apache.iotdb.db.mpp.plan.planner.distribution.NodeDistributionType;
import org.apache.iotdb.db.mpp.plan.planner.distribution.NodeGroupContext;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.AbstractSchemaMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.CountSchemaMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaFetchMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaFetchScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaQueryMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaQueryOrderByHeatNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.DeviceMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.DeviceViewNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.GroupByLevelNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.LastQueryMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.MultiChildNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.SlidingWindowAggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.TimeJoinNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedLastQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedSeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedSeriesScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.LastQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SourceNode;

public class ExchangeNodeAdder
extends PlanVisitor<PlanNode, NodeGroupContext> {
    @Override
    public PlanNode visitPlan(PlanNode node, NodeGroupContext context) {
        if (node instanceof WritePlanNode) {
            return node;
        }
        List children = (List)node.getChildren().stream().map(child -> child.accept(this, context)).collect(ImmutableList.toImmutableList());
        context.putNodeDistribution(node.getPlanNodeId(), new NodeDistribution(NodeDistributionType.SAME_WITH_ALL_CHILDREN, null));
        return node.cloneWithChildren(children);
    }

    @Override
    public PlanNode visitSchemaQueryMerge(SchemaQueryMergeNode node, NodeGroupContext context) {
        return this.internalVisitSchemaMerge(node, context);
    }

    private PlanNode internalVisitSchemaMerge(AbstractSchemaMergeNode node, NodeGroupContext context) {
        node.getChildren().forEach(child -> this.visit((PlanNode)child, context));
        NodeDistribution nodeDistribution = new NodeDistribution(NodeDistributionType.DIFFERENT_FROM_ALL_CHILDREN);
        PlanNode newNode = node.clone();
        nodeDistribution.region = this.calculateSchemaRegionByChildren(node.getChildren(), context);
        context.putNodeDistribution(newNode.getPlanNodeId(), nodeDistribution);
        node.getChildren().forEach(child -> {
            if (!nodeDistribution.region.equals(context.getNodeDistribution((PlanNodeId)child.getPlanNodeId()).region)) {
                ExchangeNode exchangeNode = new ExchangeNode(context.queryContext.getQueryId().genPlanNodeId());
                exchangeNode.setChild((PlanNode)child);
                exchangeNode.setOutputColumnNames(child.getOutputColumnNames());
                newNode.addChild(exchangeNode);
            } else {
                newNode.addChild((PlanNode)child);
            }
        });
        return newNode;
    }

    @Override
    public PlanNode visitCountMerge(CountSchemaMergeNode node, NodeGroupContext context) {
        return this.internalVisitSchemaMerge(node, context);
    }

    @Override
    public PlanNode visitSchemaFetchMerge(SchemaFetchMergeNode node, NodeGroupContext context) {
        return this.internalVisitSchemaMerge(node, context);
    }

    @Override
    public PlanNode visitSchemaQueryScan(SchemaQueryScanNode node, NodeGroupContext context) {
        return this.processNoChildSourceNode(node, context);
    }

    @Override
    public PlanNode visitSchemaFetchScan(SchemaFetchScanNode node, NodeGroupContext context) {
        return this.processNoChildSourceNode(node, context);
    }

    @Override
    public PlanNode visitSeriesScan(SeriesScanNode node, NodeGroupContext context) {
        return this.processNoChildSourceNode(node, context);
    }

    @Override
    public PlanNode visitAlignedSeriesScan(AlignedSeriesScanNode node, NodeGroupContext context) {
        return this.processNoChildSourceNode(node, context);
    }

    @Override
    public PlanNode visitLastQueryScan(LastQueryScanNode node, NodeGroupContext context) {
        return this.processNoChildSourceNode(node, context);
    }

    @Override
    public PlanNode visitAlignedLastQueryScan(AlignedLastQueryScanNode node, NodeGroupContext context) {
        return this.processNoChildSourceNode(node, context);
    }

    @Override
    public PlanNode visitSeriesAggregationScan(SeriesAggregationScanNode node, NodeGroupContext context) {
        return this.processNoChildSourceNode(node, context);
    }

    @Override
    public PlanNode visitAlignedSeriesAggregationScan(AlignedSeriesAggregationScanNode node, NodeGroupContext context) {
        return this.processNoChildSourceNode(node, context);
    }

    private PlanNode processNoChildSourceNode(SourceNode node, NodeGroupContext context) {
        context.putNodeDistribution(node.getPlanNodeId(), new NodeDistribution(NodeDistributionType.NO_CHILD, node.getRegionReplicaSet()));
        return node.clone();
    }

    @Override
    public PlanNode visitDeviceView(DeviceViewNode node, NodeGroupContext context) {
        return this.processMultiChildNode(node, context);
    }

    @Override
    public PlanNode visitDeviceMerge(DeviceMergeNode node, NodeGroupContext context) {
        return this.processMultiChildNode(node, context);
    }

    @Override
    public PlanNode visitLastQueryMerge(LastQueryMergeNode node, NodeGroupContext context) {
        return this.processMultiChildNode(node, context);
    }

    @Override
    public PlanNode visitTimeJoin(TimeJoinNode node, NodeGroupContext context) {
        return this.processMultiChildNode(node, context);
    }

    @Override
    public PlanNode visitAggregation(AggregationNode node, NodeGroupContext context) {
        return this.processMultiChildNode(node, context);
    }

    @Override
    public PlanNode visitSchemaQueryOrderByHeat(SchemaQueryOrderByHeatNode node, NodeGroupContext context) {
        return this.processMultiChildNode(node, context);
    }

    @Override
    public PlanNode visitGroupByLevel(GroupByLevelNode node, NodeGroupContext context) {
        return this.processMultiChildNode(node, context);
    }

    private PlanNode processMultiChildNode(MultiChildNode node, NodeGroupContext context) {
        MultiChildNode newNode = (MultiChildNode)node.clone();
        ArrayList<PlanNode> visitedChildren = new ArrayList<PlanNode>();
        node.getChildren().forEach(child -> visitedChildren.add(this.visit((PlanNode)child, context)));
        TRegionReplicaSet dataRegion = this.calculateDataRegionByChildren(visitedChildren, context);
        NodeDistributionType distributionType = this.nodeDistributionIsSame(visitedChildren, context) ? NodeDistributionType.SAME_WITH_ALL_CHILDREN : NodeDistributionType.SAME_WITH_SOME_CHILD;
        context.putNodeDistribution(newNode.getPlanNodeId(), new NodeDistribution(distributionType, dataRegion));
        if (distributionType == NodeDistributionType.SAME_WITH_ALL_CHILDREN) {
            newNode.setChildren(visitedChildren);
            return newNode;
        }
        visitedChildren.forEach(child -> {
            if (context.getNodeDistribution((PlanNodeId)child.getPlanNodeId()).region != DataPartition.NOT_ASSIGNED && !dataRegion.equals(context.getNodeDistribution((PlanNodeId)child.getPlanNodeId()).region)) {
                ExchangeNode exchangeNode = new ExchangeNode(context.queryContext.getQueryId().genPlanNodeId());
                exchangeNode.setChild((PlanNode)child);
                exchangeNode.setOutputColumnNames(child.getOutputColumnNames());
                newNode.addChild(exchangeNode);
            } else {
                newNode.addChild((PlanNode)child);
            }
        });
        return newNode;
    }

    @Override
    public PlanNode visitSlidingWindowAggregation(SlidingWindowAggregationNode node, NodeGroupContext context) {
        return this.processOneChildNode(node, context);
    }

    private PlanNode processOneChildNode(PlanNode node, NodeGroupContext context) {
        PlanNode newNode = node.clone();
        PlanNode child = this.visit(node.getChildren().get(0), context);
        newNode.addChild(child);
        TRegionReplicaSet dataRegion = context.getNodeDistribution((PlanNodeId)child.getPlanNodeId()).region;
        context.putNodeDistribution(newNode.getPlanNodeId(), new NodeDistribution(NodeDistributionType.SAME_WITH_ALL_CHILDREN, dataRegion));
        return newNode;
    }

    private TRegionReplicaSet calculateDataRegionByChildren(List<PlanNode> children, NodeGroupContext context) {
        Map<TRegionReplicaSet, Long> groupByRegion = children.stream().collect(Collectors.groupingBy(child -> {
            TRegionReplicaSet region = context.getNodeDistribution((PlanNodeId)child.getPlanNodeId()).region;
            if (region == null && context.getNodeDistribution((PlanNodeId)child.getPlanNodeId()).type == NodeDistributionType.SAME_WITH_ALL_CHILDREN) {
                return this.calculateSchemaRegionByChildren(child.getChildren(), context);
            }
            return region;
        }, Collectors.counting()));
        if (groupByRegion.entrySet().size() == 1) {
            return groupByRegion.entrySet().iterator().next().getKey();
        }
        return (TRegionReplicaSet)Collections.max(groupByRegion.entrySet().stream().filter(e -> e.getKey() != DataPartition.NOT_ASSIGNED).collect(Collectors.toList()), Map.Entry.comparingByValue()).getKey();
    }

    private TRegionReplicaSet calculateSchemaRegionByChildren(List<PlanNode> children, NodeGroupContext context) {
        return context.getNodeDistribution((PlanNodeId)children.get((int)0).getPlanNodeId()).region;
    }

    private boolean nodeDistributionIsSame(List<PlanNode> children, NodeGroupContext context) {
        NodeDistribution first = context.getNodeDistribution(children.get(0).getPlanNodeId());
        for (int i = 1; i < children.size(); ++i) {
            NodeDistribution next = context.getNodeDistribution(children.get(i).getPlanNodeId());
            if (first.region != null && first.region.equals(next.region)) continue;
            return false;
        }
        return true;
    }

    public PlanNode visit(PlanNode node, NodeGroupContext context) {
        return node.accept(this, context);
    }
}

