/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.sink.FragmentSinkNode;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentInstance
implements IConsensusRequest {
    private final Logger logger = LoggerFactory.getLogger(FragmentInstance.class);
    private final FragmentInstanceId id;
    private final QueryType type;
    private final PlanFragment fragment;
    private TRegionReplicaSet regionReplicaSet;
    private TDataNodeLocation hostDataNode;
    private Filter timeFilter;

    public FragmentInstance(PlanFragment fragment, FragmentInstanceId id, Filter timeFilter, QueryType type) {
        this.fragment = fragment;
        this.timeFilter = timeFilter;
        this.id = id;
        this.type = type;
    }

    public TRegionReplicaSet getDataRegionId() {
        return this.regionReplicaSet;
    }

    public void setDataRegionAndHost(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
        this.hostDataNode = IoTDBDescriptor.getInstance().getConfig().isClusterMode() ? (TDataNodeLocation)regionReplicaSet.getDataNodeLocations().get(0) : (TDataNodeLocation)regionReplicaSet.getDataNodeLocations().get(0);
    }

    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    public PlanFragment getFragment() {
        return this.fragment;
    }

    public FragmentInstanceId getId() {
        return this.id;
    }

    public String getDownstreamInfo() {
        PlanNode root = this.getFragment().getRoot();
        if (root instanceof FragmentSinkNode) {
            FragmentSinkNode sink = (FragmentSinkNode)root;
            return String.format("(%s, %s, %s)", sink.getDownStreamEndpoint(), sink.getDownStreamInstanceId(), sink.getDownStreamPlanNodeId());
        }
        return "<No downstream>";
    }

    public void setTimeFilter(Filter timeFilter) {
        this.timeFilter = timeFilter;
    }

    public Filter getTimeFilter() {
        return this.timeFilter;
    }

    public QueryType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(String.format("FragmentInstance-%s:", this.getId()));
        ret.append(String.format("Host: %s ", this.getHostDataNode() == null ? "Not set" : this.getHostDataNode().dataNodeId + " - " + this.getHostDataNode().internalEndPoint));
        ret.append(String.format("Region: %s ", this.getRegionReplicaSet() == null ? "Not set" : this.getRegionReplicaSet().getRegionId()));
        ret.append("\n---- Plan Node Tree ----\n");
        ret.append(PlanNodeUtil.nodeToString(this.getFragment().getRoot()));
        return ret.toString();
    }

    public static FragmentInstance deserializeFrom(ByteBuffer buffer) {
        FragmentInstanceId id = FragmentInstanceId.deserialize(buffer);
        PlanFragment planFragment = PlanFragment.deserialize(buffer);
        boolean hasTimeFilter = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        Filter timeFilter = hasTimeFilter ? FilterFactory.deserialize((ByteBuffer)buffer) : null;
        QueryType queryType = QueryType.values()[ReadWriteIOUtils.readInt((ByteBuffer)buffer)];
        FragmentInstance fragmentInstance = new FragmentInstance(planFragment, id, timeFilter, queryType);
        boolean hasHostDataNode = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        fragmentInstance.hostDataNode = hasHostDataNode ? ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)buffer) : null;
        return fragmentInstance;
    }

    /*
     * Exception decompiling
     */
    public ByteBuffer serializeToByteBuffer() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentInstance instance = (FragmentInstance)o;
        return Objects.equals(this.id, instance.id) && this.type == instance.type && Objects.equals(this.fragment, instance.fragment) && Objects.equals(this.regionReplicaSet, instance.regionReplicaSet) && Objects.equals(this.hostDataNode, instance.hostDataNode) && Objects.equals(this.timeFilter, instance.timeFilter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.fragment, this.regionReplicaSet, this.hostDataNode, this.timeFilter});
    }

    public TDataNodeLocation getHostDataNode() {
        return this.hostDataNode;
    }
}

