/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.path.PathDeserializeUtil;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class InvalidateSchemaCacheNode
extends PlanNode {
    private final QueryId queryId;
    private final List<PartialPath> pathList;
    private final List<String> storageGroups;

    public InvalidateSchemaCacheNode(PlanNodeId id, QueryId queryId, List<PartialPath> pathList, List<String> storageGroups) {
        super(id);
        this.queryId = queryId;
        this.pathList = pathList;
        this.storageGroups = storageGroups;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public List<PartialPath> getPathList() {
        return this.pathList;
    }

    public List<String> getStorageGroups() {
        return this.storageGroups;
    }

    @Override
    public List<PlanNode> getChildren() {
        return null;
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        return new InvalidateSchemaCacheNode(this.getPlanNodeId(), this.queryId, this.pathList, this.storageGroups);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.INVALIDATE_SCHEMA_CACHE.serialize(byteBuffer);
        this.queryId.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.pathList.size(), (ByteBuffer)byteBuffer);
        for (PartialPath path : this.pathList) {
            path.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.storageGroups.size(), (ByteBuffer)byteBuffer);
        for (String storageGroup : this.storageGroups) {
            ReadWriteIOUtils.write((String)storageGroup, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.INVALIDATE_SCHEMA_CACHE.serialize(stream);
        this.queryId.serialize(stream);
        ReadWriteIOUtils.write((int)this.pathList.size(), (OutputStream)stream);
        for (PartialPath path : this.pathList) {
            path.serialize(stream);
        }
        ReadWriteIOUtils.write((int)this.storageGroups.size(), (OutputStream)stream);
        for (String storageGroup : this.storageGroups) {
            ReadWriteIOUtils.write((String)storageGroup, (OutputStream)stream);
        }
    }

    public static InvalidateSchemaCacheNode deserialize(ByteBuffer byteBuffer) {
        QueryId queryId = QueryId.deserialize(byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>(size);
        for (int i = 0; i < size; ++i) {
            pathList.add((PartialPath)PathDeserializeUtil.deserialize(byteBuffer));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<String> storageGroups = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            storageGroups.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new InvalidateSchemaCacheNode(planNodeId, queryId, pathList, storageGroups);
    }
}

