/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.MultiChildNode;
import org.apache.iotdb.db.mpp.plan.statement.component.OrderBy;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DeviceViewNode
extends MultiChildNode {
    private final List<OrderBy> mergeOrders;
    private final List<String> devices = new ArrayList<String>();
    private final List<String> outputColumnNames;
    private Map<String, List<Integer>> deviceToMeasurementIndexesMap;

    public DeviceViewNode(PlanNodeId id, List<OrderBy> mergeOrders, List<String> outputColumnNames, Map<String, List<Integer>> deviceToMeasurementIndexesMap) {
        super(id);
        this.mergeOrders = mergeOrders;
        this.outputColumnNames = outputColumnNames;
        this.deviceToMeasurementIndexesMap = deviceToMeasurementIndexesMap;
    }

    public DeviceViewNode(PlanNodeId id, List<OrderBy> mergeOrders, List<String> outputColumnNames, List<String> devices, Map<String, List<Integer>> deviceToMeasurementIndexesMap) {
        super(id);
        this.mergeOrders = mergeOrders;
        this.outputColumnNames = outputColumnNames;
        this.devices.addAll(devices);
        this.deviceToMeasurementIndexesMap = deviceToMeasurementIndexesMap;
    }

    public void addChildDeviceNode(String deviceName, PlanNode childNode) {
        this.devices.add(deviceName);
        this.children.add(childNode);
    }

    public List<String> getDevices() {
        return this.devices;
    }

    public Map<String, List<Integer>> getDeviceToMeasurementIndexesMap() {
        return this.deviceToMeasurementIndexesMap;
    }

    @Override
    public List<PlanNode> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(PlanNode child) {
        this.children.add(child);
    }

    @Override
    public int allowedChildCount() {
        return -1;
    }

    @Override
    public PlanNode clone() {
        return new DeviceViewNode(this.getPlanNodeId(), this.mergeOrders, this.outputColumnNames, this.devices, this.deviceToMeasurementIndexesMap);
    }

    public List<OrderBy> getMergeOrders() {
        return this.mergeOrders;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitDeviceView(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.DEVICE_VIEW.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.mergeOrders.get(0).ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.mergeOrders.get(1).ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.outputColumnNames.size(), (ByteBuffer)byteBuffer);
        for (String string : this.outputColumnNames) {
            ReadWriteIOUtils.write((String)string, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.devices.size(), (ByteBuffer)byteBuffer);
        for (String string : this.devices) {
            ReadWriteIOUtils.write((String)string, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.deviceToMeasurementIndexesMap.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry entry : this.deviceToMeasurementIndexesMap.entrySet()) {
            ReadWriteIOUtils.write((String)((String)entry.getKey()), (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((int)((List)entry.getValue()).size(), (ByteBuffer)byteBuffer);
            for (Integer index : (List)entry.getValue()) {
                ReadWriteIOUtils.write((int)index, (ByteBuffer)byteBuffer);
            }
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.DEVICE_VIEW.serialize(stream);
        ReadWriteIOUtils.write((int)this.mergeOrders.get(0).ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.mergeOrders.get(1).ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.outputColumnNames.size(), (OutputStream)stream);
        for (String string : this.outputColumnNames) {
            ReadWriteIOUtils.write((String)string, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.devices.size(), (OutputStream)stream);
        for (String string : this.devices) {
            ReadWriteIOUtils.write((String)string, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.deviceToMeasurementIndexesMap.size(), (OutputStream)stream);
        for (Map.Entry entry : this.deviceToMeasurementIndexesMap.entrySet()) {
            ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)stream);
            ReadWriteIOUtils.write((int)((List)entry.getValue()).size(), (OutputStream)stream);
            for (Integer index : (List)entry.getValue()) {
                ReadWriteIOUtils.write((int)index, (OutputStream)stream);
            }
        }
    }

    public static DeviceViewNode deserialize(ByteBuffer byteBuffer) {
        int mapSize;
        ArrayList<OrderBy> mergeOrders = new ArrayList<OrderBy>();
        mergeOrders.add(OrderBy.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)]);
        mergeOrders.add(OrderBy.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)]);
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        for (int columnSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); columnSize > 0; --columnSize) {
            outputColumnNames.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        ArrayList<String> devices = new ArrayList<String>();
        for (int devicesSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); devicesSize > 0; --devicesSize) {
            devices.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        HashMap<String, List<Integer>> deviceToMeasurementIndexesMap = new HashMap<String, List<Integer>>(mapSize);
        for (mapSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); mapSize > 0; --mapSize) {
            int listSize;
            String deviceName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            ArrayList<Integer> indexes = new ArrayList<Integer>(listSize);
            for (listSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); listSize > 0; --listSize) {
                indexes.add(ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
            }
            deviceToMeasurementIndexesMap.put(deviceName, indexes);
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new DeviceViewNode(planNodeId, mergeOrders, outputColumnNames, devices, deviceToMeasurementIndexesMap);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceViewNode that = (DeviceViewNode)o;
        return this.mergeOrders.equals(that.mergeOrders) && this.devices.equals(that.devices) && this.children.equals(that.children) && this.outputColumnNames.equals(that.outputColumnNames) && this.deviceToMeasurementIndexesMap.equals(that.deviceToMeasurementIndexesMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mergeOrders, this.devices, this.children, this.outputColumnNames, this.deviceToMeasurementIndexesMap);
    }

    public String toString() {
        return "DeviceView-" + this.getPlanNodeId();
    }
}

