/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.MultiChildNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByLevelDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.statement.component.OrderBy;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class GroupByLevelNode
extends MultiChildNode {
    protected List<GroupByLevelDescriptor> groupByLevelDescriptors;
    @Nullable
    protected GroupByTimeParameter groupByTimeParameter;
    protected OrderBy scanOrder;

    public GroupByLevelNode(PlanNodeId id, List<PlanNode> children, List<GroupByLevelDescriptor> groupByLevelDescriptors, GroupByTimeParameter groupByTimeParameter, OrderBy scanOrder) {
        super(id, children);
        this.groupByLevelDescriptors = groupByLevelDescriptors;
        this.groupByTimeParameter = groupByTimeParameter;
        this.scanOrder = scanOrder;
    }

    public GroupByLevelNode(PlanNodeId id, List<GroupByLevelDescriptor> groupByLevelDescriptors, GroupByTimeParameter groupByTimeParameter, OrderBy scanOrder) {
        super(id);
        this.groupByLevelDescriptors = groupByLevelDescriptors;
        this.groupByTimeParameter = groupByTimeParameter;
        this.scanOrder = scanOrder;
    }

    @Override
    public List<PlanNode> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(PlanNode child) {
        this.children.add(child);
    }

    @Override
    public int allowedChildCount() {
        return -1;
    }

    @Override
    public PlanNode clone() {
        return new GroupByLevelNode(this.getPlanNodeId(), this.getGroupByLevelDescriptors(), this.groupByTimeParameter, this.scanOrder);
    }

    public List<GroupByLevelDescriptor> getGroupByLevelDescriptors() {
        return this.groupByLevelDescriptors;
    }

    public void setGroupByLevelDescriptors(List<GroupByLevelDescriptor> groupByLevelDescriptors) {
        this.groupByLevelDescriptors = groupByLevelDescriptors;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.groupByLevelDescriptors.stream().map(AggregationDescriptor::getOutputColumnNames).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitGroupByLevel(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.GROUP_BY_LEVEL.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.groupByLevelDescriptors.size(), (ByteBuffer)byteBuffer);
        for (GroupByLevelDescriptor groupByLevelDescriptor : this.groupByLevelDescriptors) {
            groupByLevelDescriptor.serialize(byteBuffer);
        }
        if (this.groupByTimeParameter == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.groupByTimeParameter.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.GROUP_BY_LEVEL.serialize(stream);
        ReadWriteIOUtils.write((int)this.groupByLevelDescriptors.size(), (OutputStream)stream);
        for (GroupByLevelDescriptor groupByLevelDescriptor : this.groupByLevelDescriptors) {
            groupByLevelDescriptor.serialize(stream);
        }
        if (this.groupByTimeParameter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.groupByTimeParameter.serialize(stream);
        }
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (OutputStream)stream);
    }

    public static GroupByLevelNode deserialize(ByteBuffer byteBuffer) {
        ArrayList<GroupByLevelDescriptor> groupByLevelDescriptors = new ArrayList<GroupByLevelDescriptor>();
        for (int descriptorSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); descriptorSize > 0; --descriptorSize) {
            groupByLevelDescriptors.add(GroupByLevelDescriptor.deserialize(byteBuffer));
        }
        byte isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        GroupByTimeParameter groupByTimeParameter = null;
        if (isNull == 1) {
            groupByTimeParameter = GroupByTimeParameter.deserialize(byteBuffer);
        }
        OrderBy scanOrder = OrderBy.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new GroupByLevelNode(planNodeId, groupByLevelDescriptors, groupByTimeParameter, scanOrder);
    }

    @Nullable
    public GroupByTimeParameter getGroupByTimeParameter() {
        return this.groupByTimeParameter;
    }

    public OrderBy getScanOrder() {
        return this.scanOrder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupByLevelNode that = (GroupByLevelNode)o;
        return Objects.equals(this.groupByLevelDescriptors, that.groupByLevelDescriptors) && Objects.equals(this.groupByTimeParameter, that.groupByTimeParameter) && this.scanOrder == that.scanOrder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.groupByLevelDescriptors, this.groupByTimeParameter, this.scanOrder});
    }

    public String toString() {
        return String.format("GroupByLevelNode-%s: Output: %s, Input: %s", this.getPlanNodeId(), this.getOutputColumnNames(), this.groupByLevelDescriptors.size());
    }
}

