/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ProcessNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class OffsetNode
extends ProcessNode {
    private final int offset;
    private PlanNode child;

    public OffsetNode(PlanNodeId id, int offset) {
        super(id);
        this.offset = offset;
    }

    public OffsetNode(PlanNodeId id, PlanNode child, int offset) {
        this(id, offset);
        this.child = child;
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of((Object)this.child);
    }

    @Override
    public void addChild(PlanNode child) {
        this.child = child;
    }

    @Override
    public int allowedChildCount() {
        return 1;
    }

    @Override
    public PlanNode clone() {
        return new OffsetNode(this.getPlanNodeId(), this.offset);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.child.getOutputColumnNames();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitOffset(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.OFFSET.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.offset, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.OFFSET.serialize(stream);
        ReadWriteIOUtils.write((int)this.offset, (OutputStream)stream);
    }

    public static OffsetNode deserialize(ByteBuffer byteBuffer) {
        int offset = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new OffsetNode(planNodeId, offset);
    }

    public PlanNode getChild() {
        return this.child;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetNode that = (OffsetNode)o;
        return this.offset == that.offset && this.child.equals(that.child);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.child, this.offset);
    }
}

