/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.sink;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.Validate;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.sink.SinkNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class FragmentSinkNode
extends SinkNode {
    private PlanNode child;
    private TEndPoint downStreamEndpoint;
    private FragmentInstanceId downStreamInstanceId;
    private PlanNodeId downStreamPlanNodeId;

    public FragmentSinkNode(PlanNodeId id) {
        super(id);
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of((Object)this.child);
    }

    @Override
    public PlanNode clone() {
        FragmentSinkNode sinkNode = new FragmentSinkNode(this.getPlanNodeId());
        sinkNode.setDownStream(this.downStreamEndpoint, this.downStreamInstanceId, this.downStreamPlanNodeId);
        return sinkNode;
    }

    @Override
    public PlanNode cloneWithChildren(List<PlanNode> children) {
        Validate.isTrue((children == null || children.size() == 1 ? 1 : 0) != 0, (String)"Children size of FragmentSinkNode should be 0 or 1");
        FragmentSinkNode sinkNode = (FragmentSinkNode)this.clone();
        if (children != null) {
            sinkNode.setChild(children.get(0));
        }
        return sinkNode;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitFragmentSink(this, context);
    }

    @Override
    public void addChild(PlanNode child) {
        this.child = child;
    }

    @Override
    public int allowedChildCount() {
        return 1;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.child.getOutputColumnNames();
    }

    public static FragmentSinkNode deserialize(ByteBuffer byteBuffer) {
        TEndPoint downStreamEndpoint = new TEndPoint(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
        FragmentInstanceId downStreamInstanceId = FragmentInstanceId.deserialize(byteBuffer);
        PlanNodeId downStreamPlanNodeId = PlanNodeId.deserialize(byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        FragmentSinkNode fragmentSinkNode = new FragmentSinkNode(planNodeId);
        fragmentSinkNode.downStreamEndpoint = downStreamEndpoint;
        fragmentSinkNode.downStreamInstanceId = downStreamInstanceId;
        fragmentSinkNode.downStreamPlanNodeId = downStreamPlanNodeId;
        return fragmentSinkNode;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.FRAGMENT_SINK.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.downStreamEndpoint.getIp(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.downStreamEndpoint.getPort(), (ByteBuffer)byteBuffer);
        this.downStreamInstanceId.serialize(byteBuffer);
        this.downStreamPlanNodeId.serialize(byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.FRAGMENT_SINK.serialize(stream);
        ReadWriteIOUtils.write((String)this.downStreamEndpoint.getIp(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.downStreamEndpoint.getPort(), (OutputStream)stream);
        this.downStreamInstanceId.serialize(stream);
        this.downStreamPlanNodeId.serialize(stream);
    }

    @Override
    public void send() {
    }

    @Override
    public void close() throws Exception {
    }

    public PlanNode getChild() {
        return this.child;
    }

    public void setChild(PlanNode child) {
        this.child = child;
    }

    public String toString() {
        return String.format("FragmentSinkNode-%s:[SendTo: (%s)]", this.getPlanNodeId(), this.getDownStreamAddress());
    }

    public String getDownStreamAddress() {
        if (this.getDownStreamEndpoint() == null) {
            return "Not assigned";
        }
        return String.format("%s:%d/%s/%s", this.getDownStreamEndpoint().getIp(), this.getDownStreamEndpoint().getPort(), this.getDownStreamInstanceId(), this.getDownStreamPlanNodeId());
    }

    public void setDownStream(TEndPoint endPoint, FragmentInstanceId instanceId, PlanNodeId nodeId) {
        this.downStreamEndpoint = endPoint;
        this.downStreamInstanceId = instanceId;
        this.downStreamPlanNodeId = nodeId;
    }

    public void setDownStreamPlanNodeId(PlanNodeId downStreamPlanNodeId) {
        this.downStreamPlanNodeId = downStreamPlanNodeId;
    }

    public TEndPoint getDownStreamEndpoint() {
        return this.downStreamEndpoint;
    }

    public FragmentInstanceId getDownStreamInstanceId() {
        return this.downStreamInstanceId;
    }

    public PlanNodeId getDownStreamPlanNodeId() {
        return this.downStreamPlanNodeId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FragmentSinkNode that = (FragmentSinkNode)o;
        return Objects.equals(this.child, that.child) && Objects.equals(this.downStreamEndpoint, that.downStreamEndpoint) && Objects.equals(this.downStreamInstanceId, that.downStreamInstanceId) && Objects.equals(this.downStreamPlanNodeId, that.downStreamPlanNodeId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.child, this.downStreamEndpoint, this.downStreamInstanceId, this.downStreamPlanNodeId);
    }
}

