/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.source;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.PathDeserializeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.LastQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesSourceNode;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class AlignedLastQueryScanNode
extends SeriesSourceNode {
    private final AlignedPath seriesPath;
    private TRegionReplicaSet regionReplicaSet;

    public AlignedLastQueryScanNode(PlanNodeId id, AlignedPath seriesPath) {
        super(id);
        this.seriesPath = seriesPath;
    }

    public AlignedLastQueryScanNode(PlanNodeId id, AlignedPath seriesPath, TRegionReplicaSet regionReplicaSet) {
        super(id);
        this.seriesPath = seriesPath;
        this.regionReplicaSet = regionReplicaSet;
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    @Override
    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public void addChild(PlanNode child) {
        throw new UnsupportedOperationException("no child is allowed for SeriesScanNode");
    }

    @Override
    public PlanNode clone() {
        return new AlignedLastQueryScanNode(this.getPlanNodeId(), this.seriesPath, this.regionReplicaSet);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return LastQueryScanNode.LAST_QUERY_HEADER_COLUMNS;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAlignedLastQueryScan(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlignedLastQueryScanNode that = (AlignedLastQueryScanNode)o;
        return Objects.equals((Object)this.seriesPath, (Object)that.seriesPath) && Objects.equals(this.regionReplicaSet, that.regionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.seriesPath, this.regionReplicaSet});
    }

    public String toString() {
        return String.format("AlignedLastQueryScanNode-%s:[SeriesPath: %s, DataRegion: %s]", this.getPlanNodeId(), this.getSeriesPath().getFormattedString(), PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()));
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.ALIGNED_LAST_QUERY_SCAN.serialize(byteBuffer);
        this.seriesPath.serialize(byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.ALIGNED_LAST_QUERY_SCAN.serialize(stream);
        this.seriesPath.serialize(stream);
    }

    public static AlignedLastQueryScanNode deserialize(ByteBuffer byteBuffer) {
        AlignedPath partialPath = (AlignedPath)PathDeserializeUtil.deserialize(byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new AlignedLastQueryScanNode(planNodeId, partialPath);
    }

    public AlignedPath getSeriesPath() {
        return this.seriesPath;
    }

    @Override
    public PartialPath getPartitionPath() {
        return this.seriesPath;
    }

    @Override
    public Filter getPartitionTimeFilter() {
        return null;
    }
}

