/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.write;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.DataTypeMismatchException;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.mpp.common.schematree.SchemaTree;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.wal.utils.WALWriteUtils;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InsertNode
extends WritePlanNode {
    private final Logger logger = LoggerFactory.getLogger(InsertNode.class);
    public static final long NO_CONSENSUS_INDEX = -1L;
    public static final long DEFAULT_SAFELY_DELETED_SEARCH_INDEX = Long.MAX_VALUE;
    protected PartialPath devicePath;
    protected boolean isAligned;
    protected MeasurementSchema[] measurementSchemas;
    protected String[] measurements;
    protected TSDataType[] dataTypes;
    protected Map<Integer, FailedMeasurementInfo> failedMeasurementIndex2Info;
    protected IDeviceID deviceID;
    protected long searchIndex = -1L;
    protected long safelyDeletedSearchIndex = Long.MAX_VALUE;
    protected TRegionReplicaSet dataRegionReplicaSet;

    protected InsertNode(PlanNodeId id) {
        super(id);
    }

    protected InsertNode(PlanNodeId id, PartialPath devicePath, boolean isAligned, String[] measurements, TSDataType[] dataTypes) {
        super(id);
        this.devicePath = devicePath;
        this.isAligned = isAligned;
        this.measurements = measurements;
        this.dataTypes = dataTypes;
    }

    public TRegionReplicaSet getDataRegionReplicaSet() {
        return this.dataRegionReplicaSet;
    }

    public void setDataRegionReplicaSet(TRegionReplicaSet dataRegionReplicaSet) {
        this.dataRegionReplicaSet = dataRegionReplicaSet;
    }

    public PartialPath getDevicePath() {
        return this.devicePath;
    }

    public void setDevicePath(PartialPath devicePath) {
        this.devicePath = devicePath;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public void setAligned(boolean aligned) {
        this.isAligned = aligned;
    }

    public MeasurementSchema[] getMeasurementSchemas() {
        return this.measurementSchemas;
    }

    public void setMeasurementSchemas(MeasurementSchema[] measurementSchemas) {
        this.measurementSchemas = measurementSchemas;
    }

    public String[] getMeasurements() {
        return this.measurements;
    }

    public TSDataType[] getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(TSDataType[] dataTypes) {
        this.dataTypes = dataTypes;
    }

    public IDeviceID getDeviceID() {
        return this.deviceID;
    }

    public void setDeviceID(IDeviceID deviceID) {
        this.deviceID = deviceID;
    }

    public long getSearchIndex() {
        return this.searchIndex;
    }

    public void setSearchIndex(long searchIndex) {
        this.searchIndex = searchIndex;
    }

    public long getSafelyDeletedSearchIndex() {
        return this.safelyDeletedSearchIndex;
    }

    public void setSafelyDeletedSearchIndex(long safelyDeletedSearchIndex) {
        this.safelyDeletedSearchIndex = safelyDeletedSearchIndex;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        throw new NotImplementedException("serializeAttributes of InsertNode is not implemented");
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        throw new NotImplementedException("serializeAttributes of InsertNode is not implemented");
    }

    protected int serializeMeasurementSchemasSize() {
        int byteLen = 0;
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            byteLen += WALWriteUtils.sizeToWrite(this.measurementSchemas[i]);
        }
        return byteLen;
    }

    protected void serializeMeasurementSchemasToWAL(IWALByteBufferView buffer) {
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            WALWriteUtils.write(this.measurementSchemas[i], buffer);
        }
    }

    protected void deserializeMeasurementSchemas(DataInputStream stream) throws IOException {
        for (int i = 0; i < this.measurementSchemas.length; ++i) {
            this.measurementSchemas[i] = MeasurementSchema.deserializeFrom((InputStream)stream);
            this.measurements[i] = this.measurementSchemas[i].getMeasurementId();
        }
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.dataRegionReplicaSet;
    }

    public abstract boolean validateAndSetSchema(SchemaTree var1);

    protected boolean selfCheckDataTypes() {
        for (int i = 0; i < this.measurementSchemas.length; ++i) {
            if (this.dataTypes[i] == this.measurementSchemas[i].getType()) continue;
            if (!IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
                return false;
            }
            this.markFailedMeasurement(i, (Exception)((Object)new DataTypeMismatchException(this.devicePath.getFullPath(), this.measurements[i], this.measurementSchemas[i].getType(), this.dataTypes[i], this.getMinTime(), this.getFirstValueOfIndex(i))));
        }
        return true;
    }

    public abstract long getMinTime();

    public abstract Object getFirstValueOfIndex(int var1);

    public void markFailedMeasurement(int index, Exception cause) {
        throw new UnsupportedOperationException();
    }

    public boolean hasFailedMeasurements() {
        return this.failedMeasurementIndex2Info != null && !this.failedMeasurementIndex2Info.isEmpty();
    }

    public int getFailedMeasurementNumber() {
        return this.failedMeasurementIndex2Info == null ? 0 : this.failedMeasurementIndex2Info.size();
    }

    public List<String> getFailedMeasurements() {
        return this.failedMeasurementIndex2Info == null ? Collections.emptyList() : this.failedMeasurementIndex2Info.values().stream().map(info -> info.measurement).collect(Collectors.toList());
    }

    public List<Exception> getFailedExceptions() {
        return this.failedMeasurementIndex2Info == null ? Collections.emptyList() : this.failedMeasurementIndex2Info.values().stream().map(info -> info.cause).collect(Collectors.toList());
    }

    public List<String> getFailedMessages() {
        return this.failedMeasurementIndex2Info == null ? Collections.emptyList() : this.failedMeasurementIndex2Info.values().stream().map(info -> {
            Throwable cause = info.cause;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            return cause.getMessage();
        }).collect(Collectors.toList());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsertNode that = (InsertNode)o;
        return this.isAligned == that.isAligned && Objects.equals(this.devicePath, that.devicePath) && Arrays.equals(this.measurementSchemas, that.measurementSchemas) && Arrays.equals(this.measurements, that.measurements) && Arrays.equals(this.dataTypes, that.dataTypes) && Objects.equals(this.deviceID, that.deviceID) && Objects.equals(this.dataRegionReplicaSet, that.dataRegionReplicaSet);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.devicePath, this.isAligned, this.deviceID, this.dataRegionReplicaSet);
        result = 31 * result + Arrays.hashCode(this.measurementSchemas);
        result = 31 * result + Arrays.hashCode(this.measurements);
        result = 31 * result + Arrays.hashCode(this.dataTypes);
        return result;
    }

    protected static class FailedMeasurementInfo {
        protected String measurement;
        protected TSDataType dataType;
        protected Object value;
        protected Exception cause;

        public FailedMeasurementInfo(String measurement, TSDataType dataType, Object value, Exception cause) {
            this.measurement = measurement;
            this.dataType = dataType;
            this.value = value;
            this.cause = cause;
        }
    }
}

