/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class AggregationDescriptor {
    protected final AggregationType aggregationType;
    protected final String aggregationFuncName;
    protected AggregationStep step;
    protected List<Expression> inputExpressions;
    private String parametersString;

    public AggregationDescriptor(String aggregationFuncName, AggregationStep step, List<Expression> inputExpressions) {
        this.aggregationFuncName = aggregationFuncName;
        this.aggregationType = AggregationType.valueOf(aggregationFuncName.toUpperCase());
        this.step = step;
        this.inputExpressions = inputExpressions;
    }

    public AggregationDescriptor(AggregationDescriptor other) {
        this.aggregationFuncName = other.aggregationFuncName;
        this.aggregationType = other.getAggregationType();
        this.step = other.getStep();
        this.inputExpressions = other.getInputExpressions();
    }

    public String getAggregationFuncName() {
        return this.aggregationFuncName;
    }

    public List<String> getOutputColumnNames() {
        List<String> outputAggregationNames = this.getActualAggregationNames(this.step.isOutputPartial());
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        for (String funcName : outputAggregationNames) {
            outputColumnNames.add(funcName + "(" + this.getParametersString() + ")");
        }
        return outputColumnNames;
    }

    public List<List<String>> getInputColumnNamesList() {
        if (this.step.isInputRaw()) {
            return this.inputExpressions.stream().map(expression -> Collections.singletonList(expression.getExpressionString())).collect(Collectors.toList());
        }
        ArrayList<List<String>> inputColumnNames = new ArrayList<List<String>>();
        for (Expression expression2 : this.inputExpressions) {
            inputColumnNames.add(this.getInputColumnNames(expression2));
        }
        return inputColumnNames;
    }

    public List<String> getInputColumnNames(Expression inputExpression) {
        List<String> inputAggregationNames = this.getActualAggregationNames(this.step.isInputPartial());
        ArrayList<String> inputColumnNames = new ArrayList<String>();
        for (String funcName : inputAggregationNames) {
            inputColumnNames.add(funcName + "(" + inputExpression.getExpressionString() + ")");
        }
        return inputColumnNames;
    }

    public Map<String, Expression> getInputColumnCandidateMap() {
        HashMap<String, Expression> inputColumnNameToExpressionMap = new HashMap<String, Expression>();
        for (Expression inputExpression : this.inputExpressions) {
            List<String> inputColumnNames = this.getInputColumnNames(inputExpression);
            for (String inputColumnName : inputColumnNames) {
                inputColumnNameToExpressionMap.put(inputColumnName, inputExpression);
            }
        }
        return inputColumnNameToExpressionMap;
    }

    protected List<String> getActualAggregationNames(boolean isPartial) {
        ArrayList<String> outputAggregationNames = new ArrayList<String>();
        if (isPartial) {
            switch (this.aggregationType) {
                case AVG: {
                    outputAggregationNames.add(AggregationType.COUNT.name().toLowerCase());
                    outputAggregationNames.add(AggregationType.SUM.name().toLowerCase());
                    break;
                }
                case FIRST_VALUE: {
                    outputAggregationNames.add(AggregationType.FIRST_VALUE.name().toLowerCase());
                    outputAggregationNames.add(AggregationType.MIN_TIME.name().toLowerCase());
                    break;
                }
                case LAST_VALUE: {
                    outputAggregationNames.add(AggregationType.LAST_VALUE.name().toLowerCase());
                    outputAggregationNames.add(AggregationType.MAX_TIME.name().toLowerCase());
                    break;
                }
                default: {
                    outputAggregationNames.add(this.aggregationFuncName);
                    break;
                }
            }
        } else {
            outputAggregationNames.add(this.aggregationFuncName);
        }
        return outputAggregationNames;
    }

    public String getParametersString() {
        if (this.parametersString == null) {
            StringBuilder builder = new StringBuilder();
            if (!this.inputExpressions.isEmpty()) {
                builder.append(this.inputExpressions.get(0).toString());
                for (int i = 1; i < this.inputExpressions.size(); ++i) {
                    builder.append(", ").append(this.inputExpressions.get(i).toString());
                }
            }
            this.parametersString = builder.toString();
        }
        return this.parametersString;
    }

    public List<Expression> getInputExpressions() {
        return this.inputExpressions;
    }

    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    public AggregationStep getStep() {
        return this.step;
    }

    public void setStep(AggregationStep step) {
        this.step = step;
    }

    public void setInputExpressions(List<Expression> inputExpressions) {
        this.inputExpressions = inputExpressions;
    }

    public AggregationDescriptor deepClone() {
        return new AggregationDescriptor(this);
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.aggregationFuncName, (ByteBuffer)byteBuffer);
        this.step.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.inputExpressions.size(), (ByteBuffer)byteBuffer);
        for (Expression expression : this.inputExpressions) {
            Expression.serialize(expression, byteBuffer);
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.aggregationFuncName, (OutputStream)stream);
        this.step.serialize(stream);
        ReadWriteIOUtils.write((int)this.inputExpressions.size(), (OutputStream)stream);
        for (Expression expression : this.inputExpressions) {
            Expression.serialize(expression, stream);
        }
    }

    public static AggregationDescriptor deserialize(ByteBuffer byteBuffer) {
        int inputExpressionsSize;
        String aggregationFuncName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        AggregationStep step = AggregationStep.deserialize(byteBuffer);
        ArrayList<Expression> inputExpressions = new ArrayList<Expression>(inputExpressionsSize);
        for (inputExpressionsSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); inputExpressionsSize > 0; --inputExpressionsSize) {
            inputExpressions.add(Expression.deserialize(byteBuffer));
        }
        return new AggregationDescriptor(aggregationFuncName, step, inputExpressions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationDescriptor that = (AggregationDescriptor)o;
        return this.aggregationType == that.aggregationType && this.step == that.step && Objects.equals(this.inputExpressions, that.inputExpressions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aggregationType, this.step, this.inputExpressions});
    }

    public String toString() {
        return String.format("AggregationDescriptor(%s, %s)", new Object[]{this.aggregationFuncName, this.step});
    }
}

