/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.scheduler.IQueryTerminator;
import org.apache.iotdb.mpp.rpc.thrift.TCancelQueryReq;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleQueryTerminator
implements IQueryTerminator {
    private static final Logger logger = LoggerFactory.getLogger(SimpleQueryTerminator.class);
    private static final long TERMINATION_GRACE_PERIOD_IN_MS = 1000L;
    private final ExecutorService executor;
    protected ScheduledExecutorService scheduledExecutor;
    private final QueryId queryId;
    private List<TEndPoint> relatedHost;
    private Map<TEndPoint, List<TFragmentInstanceId>> ownedFragmentInstance;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager;

    public SimpleQueryTerminator(ExecutorService executor, ScheduledExecutorService scheduledExecutor, QueryId queryId, List<FragmentInstance> fragmentInstances, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager) {
        this.executor = executor;
        this.scheduledExecutor = scheduledExecutor;
        this.queryId = queryId;
        this.internalServiceClientManager = internalServiceClientManager;
        this.calculateParameter(fragmentInstances);
    }

    private void calculateParameter(List<FragmentInstance> instances) {
        this.relatedHost = this.getRelatedHost(instances);
        this.ownedFragmentInstance = new HashMap<TEndPoint, List<TFragmentInstanceId>>();
        for (TEndPoint endPoint : this.relatedHost) {
            this.ownedFragmentInstance.put(endPoint, this.getRelatedFragmentInstances(endPoint, instances));
        }
    }

    @Override
    public Future<Boolean> terminate() {
        return this.scheduledExecutor.schedule(this::syncTerminate, 1000L, TimeUnit.MILLISECONDS);
    }

    public Boolean syncTerminate() {
        for (TEndPoint endPoint : this.relatedHost) {
            try {
                SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.internalServiceClientManager.borrowClient((Object)endPoint);
                Throwable throwable = null;
                try {
                    client.cancelQuery(new TCancelQueryReq(this.queryId.getId(), this.ownedFragmentInstance.get(endPoint)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (client == null) continue;
                    if (throwable != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    client.close();
                }
            }
            catch (IOException e) {
                logger.error("can't connect to node {}", (Object)endPoint, (Object)e);
                return false;
            }
            catch (TException e) {
                return false;
            }
        }
        return true;
    }

    private List<TEndPoint> getRelatedHost(List<FragmentInstance> fragmentInstances) {
        return fragmentInstances.stream().map(instance -> instance.getHostDataNode().internalEndPoint).distinct().collect(Collectors.toList());
    }

    private List<TFragmentInstanceId> getRelatedFragmentInstances(TEndPoint endPoint, List<FragmentInstance> fragmentInstances) {
        return fragmentInstances.stream().filter(instance -> instance.getHostDataNode().internalEndPoint.equals(endPoint)).map(instance -> instance.getId().toThrift()).collect(Collectors.toList());
    }
}

