/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.metadata;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.constant.StatementType;
import org.apache.iotdb.db.mpp.plan.statement.IConfigStatement;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;

public class SetStorageGroupStatement
extends Statement
implements IConfigStatement {
    private PartialPath storageGroupPath;
    private Long ttl = null;
    private Integer schemaReplicationFactor = null;
    private Integer dataReplicationFactor = null;
    private Long timePartitionInterval = null;

    public SetStorageGroupStatement() {
        this.statementType = StatementType.SET_STORAGE_GROUP;
    }

    public PartialPath getStorageGroupPath() {
        return this.storageGroupPath;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitSetStorageGroup(this, context);
    }

    public void setStorageGroupPath(PartialPath storageGroupPath) {
        this.storageGroupPath = storageGroupPath;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    public void setSchemaReplicationFactor(Integer schemaReplicationFactor) {
        this.schemaReplicationFactor = schemaReplicationFactor;
    }

    public void setDataReplicationFactor(Integer dataReplicationFactor) {
        this.dataReplicationFactor = dataReplicationFactor;
    }

    public void setTimePartitionInterval(Long timePartitionInterval) {
        this.timePartitionInterval = timePartitionInterval;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    public List<PartialPath> getPaths() {
        return this.storageGroupPath != null ? Collections.singletonList(this.storageGroupPath) : Collections.emptyList();
    }

    public Long getTTL() {
        return this.ttl;
    }

    public Integer getSchemaReplicationFactor() {
        return this.schemaReplicationFactor;
    }

    public Integer getDataReplicationFactor() {
        return this.dataReplicationFactor;
    }

    public Long getTimePartitionInterval() {
        return this.timePartitionInterval;
    }
}

