/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.transformer.multi;

import java.io.IOException;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.api.YieldableState;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.Transformer;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.udf.api.type.Type;

public abstract class UDFQueryTransformer
extends Transformer {
    protected final UDTFExecutor executor;
    protected final LayerPointReader layerPointReader;
    protected final TSDataType layerPointReaderDataType;
    protected final boolean isLayerPointReaderConstant;
    protected boolean terminated;

    protected UDFQueryTransformer(UDTFExecutor executor) {
        this.executor = executor;
        this.layerPointReader = executor.getCollector().constructPointReaderUsingTrivialEvictionStrategy();
        this.layerPointReaderDataType = UDFDataTypeTransformer.transformToTsDataType((Type)executor.getConfigurations().getOutputDataType());
        this.isLayerPointReaderConstant = this.layerPointReader.isConstantPointReader();
        this.terminated = false;
    }

    @Override
    public final boolean isConstantPointReader() {
        return this.isLayerPointReaderConstant;
    }

    @Override
    protected final YieldableState yieldValue() throws QueryProcessException, IOException {
        while (!this.cacheValueFromUDFOutput()) {
            YieldableState udfYieldableState = this.tryExecuteUDFOnce();
            if (udfYieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
            }
            if (udfYieldableState != YieldableState.NOT_YIELDABLE_NO_MORE_DATA || this.terminate()) continue;
            return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
        }
        return YieldableState.YIELDABLE;
    }

    protected abstract YieldableState tryExecuteUDFOnce() throws QueryProcessException, IOException;

    @Override
    protected final boolean cacheValue() throws QueryProcessException, IOException {
        while (!this.cacheValueFromUDFOutput()) {
            if (this.executeUDFOnce() || this.terminate()) continue;
            return false;
        }
        return true;
    }

    protected final boolean cacheValueFromUDFOutput() throws QueryProcessException, IOException {
        if (!this.layerPointReader.next()) {
            return false;
        }
        this.cachedTime = this.layerPointReader.currentTime();
        if (this.layerPointReader.isCurrentNull()) {
            this.currentNull = true;
        } else {
            switch (this.layerPointReaderDataType) {
                case INT32: {
                    this.cachedInt = this.layerPointReader.currentInt();
                    break;
                }
                case INT64: {
                    this.cachedLong = this.layerPointReader.currentLong();
                    break;
                }
                case FLOAT: {
                    this.cachedFloat = this.layerPointReader.currentFloat();
                    break;
                }
                case DOUBLE: {
                    this.cachedDouble = this.layerPointReader.currentDouble();
                    break;
                }
                case BOOLEAN: {
                    this.cachedBoolean = this.layerPointReader.currentBoolean();
                    break;
                }
                case TEXT: {
                    this.cachedBinary = this.layerPointReader.currentBinary();
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(this.layerPointReaderDataType.toString());
                }
            }
        }
        this.layerPointReader.readyForNext();
        return true;
    }

    protected abstract boolean executeUDFOnce() throws QueryProcessException, IOException;

    protected final boolean terminate() throws QueryProcessException {
        if (this.terminated) {
            return false;
        }
        this.executor.terminate();
        this.terminated = true;
        return true;
    }

    @Override
    public final TSDataType getDataType() {
        return this.layerPointReaderDataType;
    }
}

