/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.datastructure;

public abstract class Cache {
    protected final Node head = new Node();
    protected final Node tail = new Node();
    protected final Node[] cachedNodes;
    protected final int cacheCapacity;
    protected int cacheSize;

    protected Cache(int capacity) {
        this.head.succeeding = this.tail;
        this.tail.previous = this.head;
        this.cachedNodes = new Node[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.cachedNodes[i] = new Node();
        }
        this.cacheCapacity = capacity;
        this.cacheSize = 0;
    }

    protected boolean removeFirstOccurrence(int value) {
        Node node = this.head.succeeding;
        while (node != this.tail) {
            if (node.value == value) {
                this.cachedNodes[--this.cacheSize] = node.remove();
                return true;
            }
            node = node.succeeding;
        }
        return false;
    }

    protected int removeLast() {
        Node last = this.tail.previous.remove();
        this.cachedNodes[--this.cacheSize] = last;
        return last.value;
    }

    protected void addFirst(int value) {
        this.cachedNodes[this.cacheSize++].set(this.head, value, this.head.succeeding);
    }

    public void clear() {
        while (this.cacheSize != 0) {
            this.removeLast();
        }
    }

    private static class Node {
        private Node previous;
        private int value;
        private Node succeeding;

        private Node() {
        }

        private Node remove() {
            this.previous.succeeding = this.succeeding;
            this.succeeding.previous = this.previous;
            return this;
        }

        private void set(Node previous, int value, Node succeeding) {
            this.previous = previous;
            previous.succeeding = this;
            this.value = value;
            this.succeeding = succeeding;
            succeeding.previous = this;
        }
    }
}

