/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StringUtils {
    public static String removeQuotation(String str) {
        if (str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"' || str.charAt(0) == '\'' && str.charAt(str.length() - 1) == '\'') {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static List<String> removeDuplicate(List<String> strings) {
        HashMap<String, Integer> nameNums = new HashMap<String, Integer>();
        ArrayList<String> result = new ArrayList<String>();
        for (String tmpString : strings) {
            if (!nameNums.containsKey(tmpString)) {
                nameNums.put(tmpString, 1);
                result.add(tmpString);
                continue;
            }
            int nums = (Integer)nameNums.get(tmpString);
            result.add(tmpString + "_" + nums);
            nameNums.put(tmpString, nums + 1);
        }
        return result;
    }

    public static String getFieldByPath(String path) {
        String[] tmpList = path.split("\\.");
        return tmpList[tmpList.length - 1];
    }

    public static boolean checkSameStringList(List<String> list1, List<String> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).equals(list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static String generateFunctionSql(String functionName, String parameter, String path) {
        return String.format("select %s(%s) from %s.**", functionName, parameter, path);
    }
}

