/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryFileManager;
import org.apache.iotdb.db.query.control.QueryTimeManager;
import org.apache.iotdb.db.query.externalsort.serialize.IExternalSortFileDeserializer;
import org.apache.iotdb.db.service.TemporaryQueryDataFileService;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class QueryResourceManager {
    private final AtomicLong queryIdAtom = new AtomicLong();
    private final QueryFileManager filePathsManager = new QueryFileManager();
    private final Map<Long, List<IExternalSortFileDeserializer>> externalSortFileMap = new ConcurrentHashMap<Long, List<IExternalSortFileDeserializer>>();
    private final Map<Long, Map<String, QueryDataSource>> cachedQueryDataSourcesMap = new ConcurrentHashMap<Long, Map<String, QueryDataSource>>();

    private QueryResourceManager() {
    }

    public static QueryResourceManager getInstance() {
        return QueryTokenManagerHelper.INSTANCE;
    }

    public long assignQueryId(boolean isDataQuery) {
        long queryId = this.queryIdAtom.incrementAndGet();
        if (isDataQuery) {
            this.filePathsManager.addQueryId(queryId);
        }
        return queryId;
    }

    public long assignCompactionQueryId() {
        long threadNum = Long.parseLong(Thread.currentThread().getName().split("-")[4]);
        long queryId = Long.MIN_VALUE + threadNum;
        this.filePathsManager.addQueryId(queryId);
        return queryId;
    }

    public void registerTempExternalSortFile(long queryId, IExternalSortFileDeserializer deserializer) {
        this.externalSortFileMap.computeIfAbsent(queryId, x -> new ArrayList()).add(deserializer);
    }

    public void initQueryDataSourceCache(Map<DataRegion, List<PartialPath>> processorToSeriesMap, QueryContext context, Filter timeFilter) throws QueryProcessException {
        for (Map.Entry<DataRegion, List<PartialPath>> entry : processorToSeriesMap.entrySet()) {
            DataRegion processor = entry.getKey();
            List<PartialPath> pathList = entry.getValue().stream().map(IDTable::translateQueryPath).collect(Collectors.toList());
            Set selectedDeviceIdSet = pathList.stream().map(PartialPath::getDevice).collect(Collectors.toSet());
            long queryId = context.getQueryId();
            String storageGroupPath = processor.getStorageGroupPath();
            QueryDataSource cachedQueryDataSource = processor.query(pathList, selectedDeviceIdSet.size() == 1 ? (String)selectedDeviceIdSet.iterator().next() : null, context, this.filePathsManager, timeFilter);
            this.cachedQueryDataSourcesMap.computeIfAbsent(queryId, k -> new HashMap()).put(storageGroupPath, cachedQueryDataSource);
        }
    }

    public QueryDataSource getQueryDataSource(PartialPath selectedPath, QueryContext context, Filter timeFilter, boolean ascending) throws StorageEngineException, QueryProcessException {
        QueryDataSource cachedQueryDataSource;
        long queryId = context.getQueryId();
        String storageGroupPath = StorageEngine.getInstance().getStorageGroupPath(selectedPath);
        String deviceId = selectedPath.getDevice();
        if (this.cachedQueryDataSourcesMap.containsKey(queryId) && this.cachedQueryDataSourcesMap.get(queryId).containsKey(storageGroupPath)) {
            cachedQueryDataSource = this.cachedQueryDataSourcesMap.get(queryId).get(storageGroupPath);
        } else {
            DataRegion processor = StorageEngine.getInstance().getProcessor(selectedPath.getDevicePath());
            PartialPath translatedPath = IDTable.translateQueryPath(selectedPath);
            cachedQueryDataSource = processor.query(Collections.singletonList(translatedPath), translatedPath.getDevice(), context, this.filePathsManager, timeFilter);
        }
        QueryDataSource queryDataSource = new QueryDataSource(cachedQueryDataSource.getSeqResources(), cachedQueryDataSource.getUnseqResources());
        queryDataSource.setDataTTL(cachedQueryDataSource.getDataTTL());
        QueryUtils.fillOrderIndexes(queryDataSource, deviceId, ascending);
        return queryDataSource;
    }

    public void endQuery(long queryId) throws StorageEngineException {
        if (this.externalSortFileMap.get(queryId) != null) {
            for (IExternalSortFileDeserializer deserializer : this.externalSortFileMap.get(queryId)) {
                try {
                    deserializer.close();
                }
                catch (IOException e) {
                    throw new StorageEngineException(e);
                }
            }
            this.externalSortFileMap.remove(queryId);
        }
        this.filePathsManager.removeUsedFilesForQuery(queryId);
        TemporaryQueryDataFileService.getInstance().deregister(queryId);
        QueryTimeManager.getInstance().unRegisterQuery(queryId, true);
        this.cachedQueryDataSourcesMap.remove(queryId);
    }

    public void writeQueryFileInfo() {
        this.filePathsManager.writeQueryFileInfo();
    }

    public QueryFileManager getQueryFileManager() {
        return this.filePathsManager;
    }

    private static class QueryTokenManagerHelper {
        private static final QueryResourceManager INSTANCE = new QueryResourceManager();

        private QueryTokenManagerHelper() {
        }
    }
}

