/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.exception.runtime.RPCServiceException;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.service.ThriftService;
import org.apache.iotdb.commons.service.ThriftServiceThread;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.ClientRPCServiceMBean;
import org.apache.iotdb.db.service.thrift.handler.InternalServiceThriftHandler;
import org.apache.iotdb.db.service.thrift.impl.DataNodeRPCServiceImpl;
import org.apache.iotdb.mpp.rpc.thrift.IDataNodeRPCService;
import org.apache.thrift.server.TServerEventHandler;

public class ClientRPCService
extends ThriftService
implements ClientRPCServiceMBean {
    private DataNodeRPCServiceImpl impl;

    private ClientRPCService() {
    }

    public ServiceType getID() {
        return ServiceType.INTERNAL_SERVICE;
    }

    public void initTProcessor() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.impl = new DataNodeRPCServiceImpl();
        this.initSyncedServiceImpl(null);
        this.processor = new IDataNodeRPCService.Processor((IDataNodeRPCService.Iface)this.impl);
    }

    public void initThriftServiceThread() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        try {
            IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
            this.thriftServiceThread = new ThriftServiceThread(this.processor, this.getID().getName(), ThreadName.INTERNAL_SERVICE_RPC_CLIENT.getName(), this.getBindIP(), this.getBindPort(), config.getRpcMaxConcurrentClientNum(), config.getThriftServerAwaitTimeForStopService(), (TServerEventHandler)new InternalServiceThriftHandler(), false);
        }
        catch (RPCServiceException e) {
            throw new IllegalAccessException(e.getMessage());
        }
        this.thriftServiceThread.setName(ThreadName.INTERNAL_SERVICE_RPC_SERVER.getName());
    }

    public String getBindIP() {
        return IoTDBDescriptor.getInstance().getConfig().getRpcAddress();
    }

    public int getBindPort() {
        return IoTDBDescriptor.getInstance().getConfig().getInternalPort();
    }

    public static ClientRPCService getInstance() {
        return ClientRPCServiceHolder.INSTANCE;
    }

    private static class ClientRPCServiceHolder {
        private static final ClientRPCService INSTANCE = new ClientRPCService();

        private ClientRPCServiceHolder() {
        }
    }
}

