/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.File;
import java.io.IOException;
import org.apache.iotdb.commons.concurrent.IoTDBDefaultThreadExceptionHandler;
import org.apache.iotdb.commons.exception.ConfigurationException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.JMXService;
import org.apache.iotdb.commons.service.RegisterManager;
import org.apache.iotdb.commons.service.StartupChecks;
import org.apache.iotdb.commons.udf.service.UDFClassLoaderManager;
import org.apache.iotdb.commons.udf.service.UDFRegistrationService;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.IoTDBStartCheck;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceCheck;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceDescriptor;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.engine.cache.CacheHitRatioMonitor;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.cq.ContinuousQueryService;
import org.apache.iotdb.db.engine.flush.FlushManager;
import org.apache.iotdb.db.engine.trigger.service.TriggerRegistrationService;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.localconfignode.LocalConfigNode;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.mpp.execution.exchange.MPPDataExchangeService;
import org.apache.iotdb.db.mpp.execution.schedule.DriverScheduler;
import org.apache.iotdb.db.protocol.rest.RestService;
import org.apache.iotdb.db.rescon.PrimitiveArrayManager;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.db.service.ClientRPCService;
import org.apache.iotdb.db.service.InfluxDBRPCService;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.IoTDBShutdownHook;
import org.apache.iotdb.db.service.MQTTService;
import org.apache.iotdb.db.service.NewIoTDBMBean;
import org.apache.iotdb.db.service.RPCService;
import org.apache.iotdb.db.service.SettleService;
import org.apache.iotdb.db.service.TemporaryQueryDataFileService;
import org.apache.iotdb.db.service.UpgradeSevice;
import org.apache.iotdb.db.service.metrics.MetricsService;
import org.apache.iotdb.db.service.thrift.impl.DataNodeTSServiceImpl;
import org.apache.iotdb.db.sync.receiver.ReceiverService;
import org.apache.iotdb.db.sync.sender.service.SenderService;
import org.apache.iotdb.db.wal.WALManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewIoTDB
implements NewIoTDBMBean {
    private static final Logger logger = LoggerFactory.getLogger(NewIoTDB.class);
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", "IoTDB");
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final RegisterManager registerManager = new RegisterManager();
    public static LocalSchemaProcessor schemaProcessor = LocalSchemaProcessor.getInstance();
    public static LocalConfigNode configManager = LocalConfigNode.getInstance();

    public static NewIoTDB getInstance() {
        return IoTDBHolder.INSTANCE;
    }

    public static void main(String[] args) {
        try {
            IoTDBStartCheck.getInstance().checkConfig();
            IoTDBRestServiceCheck.getInstance().checkConfig();
        }
        catch (IOException | ConfigurationException e) {
            logger.error("meet error when doing start checking", e);
            System.exit(1);
        }
        NewIoTDB daemon = NewIoTDB.getInstance();
        config.setMppMode(true);
        daemon.active();
    }

    public void active() {
        StartupChecks checks = new StartupChecks().withDefaultTest();
        try {
            checks.verify();
        }
        catch (StartupException e) {
            logger.error("{}: failed to start because some checks failed. ", (Object)"IoTDB", (Object)e);
            return;
        }
        boolean prevIsAutoCreateSchemaEnabled = config.isAutoCreateSchemaEnabled();
        config.setAutoCreateSchemaEnabled(false);
        boolean prevIsEnablePartialInsert = config.isEnablePartialInsert();
        config.setEnablePartialInsert(true);
        config.setDataNodeId(0);
        try {
            this.setUp();
        }
        catch (StartupException | QueryProcessException e) {
            logger.error("meet error while starting up.", (Throwable)e);
            this.deactivate();
            logger.error("{} exit", (Object)"IoTDB");
            return;
        }
        config.setAutoCreateSchemaEnabled(prevIsAutoCreateSchemaEnabled);
        config.setEnablePartialInsert(prevIsEnablePartialInsert);
        logger.info("{} has started.", (Object)"IoTDB");
    }

    private void setUp() throws StartupException, QueryProcessException {
        logger.info("Setting up IoTDB...");
        Runtime.getRuntime().addShutdownHook(new IoTDBShutdownHook());
        this.setUncaughtExceptionHandler();
        IoTDBDescriptor.getInstance().getConfig().setRpcImplClassName(DataNodeTSServiceImpl.class.getName());
        registerManager.register((IService)MetricsService.getInstance());
        logger.info("recover the schema...");
        this.initConfigManager();
        registerManager.register((IService)new JMXService());
        registerManager.register((IService)FlushManager.getInstance());
        registerManager.register((IService)CacheHitRatioMonitor.getInstance());
        registerManager.register((IService)CompactionTaskManager.getInstance());
        JMXService.registerMBean((Object)NewIoTDB.getInstance(), (String)this.mbeanName);
        registerManager.register((IService)SenderService.getInstance());
        registerManager.register((IService)WALManager.getInstance());
        registerManager.register((IService)StorageEngineV2.getInstance());
        registerManager.register((IService)MPPDataExchangeService.getInstance());
        registerManager.register((IService)ClientRPCService.getInstance());
        registerManager.register((IService)DriverScheduler.getInstance());
        registerManager.register((IService)TemporaryQueryDataFileService.getInstance());
        registerManager.register((IService)UDFClassLoaderManager.setupAndGetInstance((String)IoTDBDescriptor.getInstance().getConfig().getUdfDir()));
        registerManager.register((IService)UDFRegistrationService.setupAndGetInstance((String)(IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "udf" + File.separator)));
        registerManager.register((IService)ReceiverService.getInstance());
        if (IoTDBDescriptor.getInstance().getConfig().isEnableRpcService()) {
            registerManager.register((IService)RPCService.getInstance());
        }
        NewIoTDB.initProtocols();
        logger.info("IoTDB is setting up, some storage groups may not be ready now, please wait several seconds...");
        while (!StorageEngineV2.getInstance().isAllSgReady()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warn("IoTDB failed to set up.", (Throwable)e);
                Thread.currentThread().interrupt();
                return;
            }
        }
        registerManager.register((IService)UpgradeSevice.getINSTANCE());
        if (!IoTDBDescriptor.getInstance().getConfig().isMppMode()) {
            registerManager.register((IService)SettleService.getINSTANCE());
        }
        registerManager.register((IService)TriggerRegistrationService.getInstance());
        registerManager.register((IService)ContinuousQueryService.getInstance());
        MetricsService.getInstance().startAllReporter();
        logger.info("Congratulation, IoTDB is set up successfully. Now, enjoy yourself!");
    }

    public static void initProtocols() throws StartupException {
        if (IoTDBDescriptor.getInstance().getConfig().isEnableInfluxDBRpcService()) {
            registerManager.register((IService)InfluxDBRPCService.getInstance());
        }
        if (IoTDBDescriptor.getInstance().getConfig().isEnableMQTTService()) {
            registerManager.register((IService)MQTTService.getInstance());
        }
        if (IoTDBRestServiceDescriptor.getInstance().getConfig().isEnableRestService()) {
            registerManager.register((IService)RestService.getInstance());
        }
    }

    private void deactivate() {
        logger.info("Deactivating IoTDB...");
        registerManager.deregisterAll();
        JMXService.deregisterMBean((String)this.mbeanName);
        logger.info("IoTDB is deactivated.");
    }

    private void initConfigManager() {
        long time = System.currentTimeMillis();
        IoTDB.configManager.init();
        long end = System.currentTimeMillis() - time;
        logger.info("spend {}ms to recover schema.", (Object)end);
        logger.info("After initializing, sequence tsFile threshold is {}, unsequence tsFile threshold is {}", (Object)IoTDBDescriptor.getInstance().getConfig().getSeqTsFileSize(), (Object)IoTDBDescriptor.getInstance().getConfig().getUnSeqTsFileSize());
    }

    @Override
    public void stop() {
        this.deactivate();
    }

    public void shutdown() throws Exception {
        logger.info("Deactivating IoTDB...");
        registerManager.shutdownAll();
        PrimitiveArrayManager.close();
        SystemInfo.getInstance().close();
        JMXService.deregisterMBean((String)this.mbeanName);
        logger.info("IoTDB is deactivated.");
    }

    private void setUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new IoTDBDefaultThreadExceptionHandler());
    }

    private static class IoTDBHolder {
        private static final NewIoTDB INSTANCE = new NewIoTDB();

        private IoTDBHolder() {
        }
    }
}

