/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.lang.reflect.InvocationTargetException;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.exception.runtime.RPCServiceException;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.service.ThriftService;
import org.apache.iotdb.commons.service.ThriftServiceThread;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.RPCServiceMBean;
import org.apache.iotdb.db.service.thrift.ProcessorWithMetrics;
import org.apache.iotdb.db.service.thrift.handler.RPCServiceThriftHandler;
import org.apache.iotdb.db.service.thrift.impl.TSIEventHandler;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.thrift.server.TServerEventHandler;

public class RPCService
extends ThriftService
implements RPCServiceMBean {
    private TSIEventHandler impl;

    public static RPCService getInstance() {
        return RPCServiceHolder.INSTANCE;
    }

    public void initTProcessor() throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        this.impl = (TSIEventHandler)Class.forName(IoTDBDescriptor.getInstance().getConfig().getRpcImplClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.initSyncedServiceImpl(null);
        this.processor = MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric() != false ? new ProcessorWithMetrics(this.impl) : new IClientRPCService.Processor((IClientRPCService.Iface)this.impl);
    }

    public void initThriftServiceThread() throws IllegalAccessException {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        try {
            this.thriftServiceThread = new ThriftServiceThread(this.processor, this.getID().getName(), ThreadName.RPC_CLIENT.getName(), config.getRpcAddress(), config.getRpcPort(), config.getRpcMaxConcurrentClientNum(), config.getThriftServerAwaitTimeForStopService(), (TServerEventHandler)new RPCServiceThriftHandler(this.impl), IoTDBDescriptor.getInstance().getConfig().isRpcThriftCompressionEnable());
        }
        catch (RPCServiceException e) {
            throw new IllegalAccessException(e.getMessage());
        }
        this.thriftServiceThread.setName(ThreadName.RPC_SERVICE.getName());
    }

    public String getBindIP() {
        return IoTDBDescriptor.getInstance().getConfig().getRpcAddress();
    }

    public int getBindPort() {
        return IoTDBDescriptor.getInstance().getConfig().getRpcPort();
    }

    public ServiceType getID() {
        return ServiceType.RPC_SERVICE;
    }

    @Override
    public int getRPCPort() {
        return this.getBindPort();
    }

    private static class RPCServiceHolder {
        private static final RPCService INSTANCE = new RPCService();

        private RPCServiceHolder() {
        }
    }
}

