/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.datasource;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.iotdb.db.sync.datasource.AbstractOpBlock;
import org.apache.iotdb.db.sync.externalpipe.operation.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeOpSgManager {
    private static final Logger logger = LoggerFactory.getLogger(PipeOpSgManager.class);
    private String storageGroupName;
    private ConcurrentSkipListMap<Long, AbstractOpBlock> opBlockMap = new ConcurrentSkipListMap();
    private long beginIndex = 0L;
    private long dataCount = 0L;
    private long committedIndex = -1L;

    public PipeOpSgManager(String storageGroupName) {
        this.storageGroupName = storageGroupName;
    }

    public synchronized void addPipeOpBlock(AbstractOpBlock opBlock) {
        long nextIndex = this.beginIndex + this.dataCount;
        opBlock.setBeginIndex(nextIndex);
        this.opBlockMap.put(nextIndex, opBlock);
        this.dataCount += opBlock.getDataCount();
    }

    public synchronized Operation getOperation(long beginIndex, long length) throws IOException {
        if (beginIndex >= this.beginIndex + this.dataCount) {
            return null;
        }
        Map.Entry<Long, AbstractOpBlock> opBlockEntry = this.opBlockMap.floorEntry(beginIndex);
        if (opBlockEntry == null) {
            logger.error("getOperation(), Error. invalid beginIndex {} for StorageGroup {}", (Object)beginIndex, (Object)this.storageGroupName);
            throw new IOException("getOperation(), Invalid beginIndex " + beginIndex + " for StorageGroup " + this.storageGroupName);
        }
        return opBlockEntry.getValue().getOperation(beginIndex, length);
    }

    public synchronized long getFirstAvailableIndex() {
        return this.beginIndex;
    }

    public synchronized long getNextIndex() {
        return this.beginIndex + this.dataCount;
    }

    public synchronized boolean isEmpty() {
        return this.dataCount == 0L;
    }

    public synchronized List<Long> commitData(long committedIndex) {
        Map.Entry<Long, AbstractOpBlock> entry;
        long nextIndex;
        LinkedList<Long> filePipeSerialNumberList = new LinkedList<Long>();
        if (this.committedIndex < committedIndex) {
            this.committedIndex = committedIndex;
        }
        if (this.dataCount == 0L) {
            return filePipeSerialNumberList;
        }
        if (committedIndex < this.opBlockMap.firstKey() + this.opBlockMap.firstEntry().getValue().getDataCount() - 1L) {
            logger.debug("commitData(), the first DataSrcEntry is still used, so need not remove it. storageGroupName={}, committedIndex={}", (Object)this.storageGroupName, (Object)committedIndex);
            return filePipeSerialNumberList;
        }
        Iterator<Map.Entry<Long, AbstractOpBlock>> iter = this.opBlockMap.entrySet().iterator();
        while (iter.hasNext() && (nextIndex = (entry = iter.next()).getKey() + entry.getValue().getDataCount()) <= committedIndex + 1L) {
            AbstractOpBlock dataSrcEntry = entry.getValue();
            dataSrcEntry.close();
            filePipeSerialNumberList.add(dataSrcEntry.getFilePipeSerialNumber());
            this.beginIndex = nextIndex;
            this.dataCount -= entry.getValue().getDataCount();
            iter.remove();
        }
        return filePipeSerialNumberList;
    }
}

