/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.datasource;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.sync.datasource.AbstractOpBlock;
import org.apache.iotdb.db.sync.externalpipe.operation.InsertOperation;
import org.apache.iotdb.db.sync.externalpipe.operation.Operation;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexEntry;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.read.reader.page.TimePageReader;
import org.apache.iotdb.tsfile.read.reader.page.ValuePageReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileOpBlock
extends AbstractOpBlock {
    private static final Logger logger = LoggerFactory.getLogger(TsFileOpBlock.class);
    private String tsFileName;
    private TsFileFullReader tsFileFullSeqReader;
    private Map<Long, Pair<Path, TimeseriesMetadata>> fullTsMetadataMap;
    private TreeMap<Long, Triple<String, Long, Long>> indexToChunkInfoMap;
    Decoder timeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);

    public TsFileOpBlock(String sg, String tsFileName, long pipeDataSerialNumber) throws IOException {
        this(sg, tsFileName, pipeDataSerialNumber, 0L);
    }

    public TsFileOpBlock(String sg, String tsFileName, long pipeDataSerialNumber, long beginIndex) throws IOException {
        super(sg, beginIndex);
        this.filePipeSerialNumber = pipeDataSerialNumber;
        this.tsFileName = tsFileName;
        this.init();
    }

    private void init() throws IOException {
        this.tsFileFullSeqReader = new TsFileFullReader(this.tsFileName);
        this.fullTsMetadataMap = this.tsFileFullSeqReader.getAllTimeseriesMeta(false);
        this.tsFileFullSeqReader.close();
        this.tsFileFullSeqReader = null;
        this.dataCount = 0L;
        for (Pair<Path, TimeseriesMetadata> entry : this.fullTsMetadataMap.values()) {
            this.dataCount += ((TimeseriesMetadata)entry.right).getStatistics().getCount();
        }
        this.fullTsMetadataMap = null;
    }

    @Override
    public long getDataCount() {
        return this.dataCount;
    }

    private void buildIndexToChunkMap() throws IOException {
        if (this.tsFileFullSeqReader == null) {
            this.tsFileFullSeqReader = new TsFileFullReader(this.tsFileName);
        }
        if (this.fullTsMetadataMap == null) {
            this.fullTsMetadataMap = this.tsFileFullSeqReader.getAllTimeseriesMeta(true);
        }
        TreeMap<Long, Pair> offsetToCountMap = new TreeMap<Long, Pair>();
        for (Pair<Path, TimeseriesMetadata> value : this.fullTsMetadataMap.values()) {
            List chunkMetaList = ((TimeseriesMetadata)value.right).getChunkMetadataList();
            if (chunkMetaList == null) continue;
            for (IChunkMetadata chunkMetadata : chunkMetaList) {
                long chunkOffset = chunkMetadata.getOffsetOfChunkHeader();
                long chunkPointCount = chunkMetadata.getStatistics().getCount();
                String sensorFullPath = ((Path)value.left).getFullPath();
                offsetToCountMap.put(chunkOffset, new Pair((Object)sensorFullPath, (Object)chunkPointCount));
            }
        }
        this.indexToChunkInfoMap = new TreeMap();
        long localIndex = 0L;
        for (Map.Entry entry : offsetToCountMap.entrySet()) {
            Long chunkHeaderOffset = (Long)entry.getKey();
            Long pointCount = (Long)((Pair)entry.getValue()).right;
            String sensorFullPath = (String)((Pair)entry.getValue()).left;
            this.indexToChunkInfoMap.put(localIndex, (Triple<String, Long, Long>)new ImmutableTriple((Object)sensorFullPath, (Object)chunkHeaderOffset, (Object)pointCount));
            localIndex += pointCount.longValue();
        }
    }

    private long getNonAlignedChunkPoints(ChunkHeader chunkHeader, long indexInChunk, long length, List<TimeValuePair> tvPairList) throws IOException {
        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)chunkHeader.getEncodingType(), (TSDataType)chunkHeader.getDataType());
        int chunkDataSize = chunkHeader.getDataSize();
        int index = 0;
        while (chunkDataSize > 0) {
            long pageDataCount;
            long filePos = this.tsFileFullSeqReader.position();
            boolean hasStatistic = (chunkHeader.getChunkType() & 0x3F) == 1;
            PageHeader pageHeader = this.tsFileFullSeqReader.readPageHeader(chunkHeader.getDataType(), hasStatistic);
            int pageSize = pageHeader.getSerializedPageSize();
            chunkDataSize -= pageSize;
            if (hasStatistic && (long)index + (pageDataCount = pageHeader.getNumOfValues()) < indexInChunk) {
                this.tsFileFullSeqReader.position(filePos + (long)pageSize);
                index = (int)((long)index + pageDataCount);
                continue;
            }
            ByteBuffer pageData = this.tsFileFullSeqReader.readPage(pageHeader, chunkHeader.getCompressionType());
            valueDecoder.reset();
            PageReader pageReader = new PageReader(pageData, chunkHeader.getDataType(), valueDecoder, this.timeDecoder, null);
            BatchData batchData = pageReader.getAllSatisfiedPageData();
            if (chunkHeader.getChunkType() == 1) {
                logger.debug("points in the page(by pageHeader): " + pageHeader.getNumOfValues());
            } else {
                logger.debug("points in the page(by batchData): " + batchData.length());
            }
            if (batchData.isEmpty()) {
                logger.warn("getNonAlignedChunkPoints(), chunk is empty, chunkHeader = {}.", (Object)chunkHeader);
            }
            batchData.resetBatchData();
            while (batchData.hasCurrent()) {
                if ((long)index++ >= indexInChunk) {
                    TimeValuePair timeValuePair = new TimeValuePair(batchData.currentTime(), batchData.currentTsPrimitiveType());
                    logger.debug("getNonAlignedChunkPoints(), timeValuePair = {} ", (Object)timeValuePair);
                    tvPairList.add(timeValuePair);
                }
                if ((long)index - indexInChunk >= length) {
                    return (long)index - indexInChunk;
                }
                batchData.next();
            }
        }
        return (long)index - indexInChunk;
    }

    private long getAlignedChunkPoints(ChunkHeader chunkHeader, long indexInChunk, long lengthInChunk, List<TimeValuePair> tvPairList) throws IOException {
        ArrayList<long[]> timeBatch = new ArrayList<long[]>();
        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)chunkHeader.getEncodingType(), (TSDataType)chunkHeader.getDataType());
        int timePageIndex = 0;
        int valuePageIndex = 0;
        boolean timeChunkEnd = false;
        byte chunkTypeByte = chunkHeader.getChunkType();
        do {
            PageHeader pageHeader;
            for (int chunkDataSize = chunkHeader.getDataSize(); chunkDataSize > 0; chunkDataSize -= pageHeader.getSerializedPageSize()) {
                valueDecoder.reset();
                pageHeader = this.tsFileFullSeqReader.readPageHeader(chunkHeader.getDataType(), (chunkTypeByte & 0x3F) == 1);
                ByteBuffer pageData = this.tsFileFullSeqReader.readPage(pageHeader, chunkHeader.getCompressionType());
                if ((chunkTypeByte & 0xFFFFFF80) == -128) {
                    TimePageReader timePageReader = new TimePageReader(pageHeader, pageData, this.timeDecoder);
                    timeBatch.add(timePageReader.getNextTimeBatch());
                    for (int i = 0; i < ((long[])timeBatch.get(timePageIndex)).length; ++i) {
                        logger.debug("time: " + ((long[])timeBatch.get(timePageIndex))[i]);
                    }
                    ++timePageIndex;
                    continue;
                }
                if ((chunkTypeByte & 0x40) != 64) continue;
                timeChunkEnd = true;
                ValuePageReader valuePageReader = new ValuePageReader(pageHeader, pageData, chunkHeader.getDataType(), valueDecoder);
                TsPrimitiveType[] valueBatch = valuePageReader.nextValueBatch((long[])timeBatch.get(valuePageIndex));
                if (valueBatch.length == 0) {
                    logger.debug("getAlignedChunkPoints(), Empty Page. ValuePageReader = {}", (Object)valuePageReader);
                }
                for (int i = 0; i < valueBatch.length; ++i) {
                    TimeValuePair timeValuePair = new TimeValuePair(((long[])timeBatch.get(valuePageIndex))[i], valueBatch[i]);
                    logger.debug("getNonAlignedChunkPoints(), timeValuePair = {} ", (Object)timeValuePair);
                    tvPairList.add(timeValuePair);
                }
                ++valuePageIndex;
            }
            chunkTypeByte = this.tsFileFullSeqReader.readMarker();
            chunkHeader = this.tsFileFullSeqReader.readChunkHeader(chunkTypeByte);
        } while (!timeChunkEnd || (chunkTypeByte & 0x40) == 64);
        return 0L;
    }

    private long getChunkPoints(long chunkHeaderOffset, long indexInChunk, long length, List<TimeValuePair> tvPairList) throws IOException {
        this.tsFileFullSeqReader.position(chunkHeaderOffset);
        byte chunkTypeByte = this.tsFileFullSeqReader.readMarker();
        ChunkHeader chunkHeader = this.tsFileFullSeqReader.readChunkHeader(chunkTypeByte);
        if (chunkHeader.getDataType() == TSDataType.VECTOR) {
            return this.getAlignedChunkPoints(chunkHeader, indexInChunk, length, tvPairList);
        }
        return this.getNonAlignedChunkPoints(chunkHeader, indexInChunk, length, tvPairList);
    }

    private void insertToDataList(List<Pair<MeasurementPath, List<TimeValuePair>>> dataList, String sensorFullPath, List<TimeValuePair> tvPairList) throws IOException {
        MeasurementPath measurementPath;
        try {
            measurementPath = new MeasurementPath(sensorFullPath);
        }
        catch (IllegalPathException e) {
            logger.error("TsfileDataSrcEntry.insertToDataList(), Illegal MeasurementPath: {}", (Object)"");
            throw new IOException("Illegal MeasurementPath: " + sensorFullPath, e);
        }
        dataList.add((Pair<MeasurementPath, List<TimeValuePair>>)new Pair((Object)measurementPath, tvPairList));
    }

    @Override
    public Operation getOperation(long index, long length) throws IOException {
        long remain;
        long daltaCount;
        long indexInTsfile = index - this.beginIndex;
        if (indexInTsfile < 0L || indexInTsfile >= this.dataCount) {
            logger.error("TsfileDataSrcEntry.getOperation(), index {} is out of range.", (Object)index);
            throw new IOException("index is out of range.");
        }
        if (this.tsFileFullSeqReader == null) {
            this.tsFileFullSeqReader = new TsFileFullReader(this.tsFileName);
        }
        if (this.indexToChunkInfoMap == null) {
            this.buildIndexToChunkMap();
        }
        LinkedList<Pair<MeasurementPath, List<TimeValuePair>>> dataList = new LinkedList<Pair<MeasurementPath, List<TimeValuePair>>>();
        String lastSensorFullPath = "";
        LinkedList<TimeValuePair> tvPairList = null;
        for (remain = length; remain > 0L; remain -= daltaCount) {
            Map.Entry<Long, Triple<String, Long, Long>> entry = this.indexToChunkInfoMap.floorEntry(indexInTsfile);
            if (entry == null) {
                logger.error("TsfileDataSrcEntry.getOperation(), indexInTsfile {} if out of indexToChunkOffsetMap.", (Object)indexInTsfile);
                throw new IOException("indexInTsfile is out of range.");
            }
            Long indexInChunk = indexInTsfile - entry.getKey();
            String sensorFullPath = (String)entry.getValue().getLeft();
            Long chunkHeaderOffset = (Long)entry.getValue().getMiddle();
            Long chunkPointCount = (Long)entry.getValue().getRight();
            long lengthInChunk = Math.min(chunkPointCount - indexInChunk, remain);
            if (!sensorFullPath.equals(lastSensorFullPath)) {
                if (tvPairList != null && tvPairList.size() > 0) {
                    this.insertToDataList(dataList, lastSensorFullPath, tvPairList);
                    tvPairList = null;
                }
                lastSensorFullPath = sensorFullPath;
            }
            if (tvPairList == null) {
                tvPairList = new LinkedList<TimeValuePair>();
            }
            if ((daltaCount = this.getChunkPoints(chunkHeaderOffset, indexInChunk, lengthInChunk, tvPairList)) == lengthInChunk) continue;
            logger.error("TsfileDataSrcEntry.getOperation(), error when read chunk from file {}. lengthInChunk={}, daltaCount={}, ", new Object[]{indexInTsfile, lengthInChunk, daltaCount});
            throw new IOException("Error read chunk from file:" + indexInTsfile);
        }
        if (tvPairList != null && tvPairList.size() > 0) {
            this.insertToDataList(dataList, lastSensorFullPath, (List<TimeValuePair>)tvPairList);
        }
        return new InsertOperation(this.storageGroup, index, index + length - remain, dataList);
    }

    @Override
    public void close() {
        super.close();
        if (this.tsFileFullSeqReader != null) {
            try {
                this.tsFileFullSeqReader.close();
            }
            catch (IOException e) {
                logger.error("tsFileFullSeqReader.close() exception, file = {}", (Object)this.tsFileName, (Object)e);
            }
            this.tsFileFullSeqReader = null;
        }
    }

    private class TsFileFullReader
    extends TsFileSequenceReader {
        protected TsFileMetadata tsFileMetaData;

        public TsFileFullReader(String file) throws IOException {
            super(file);
        }

        private void genTSMetadataFromMetaIndexEntry(long startOffset, MetadataIndexEntry metadataIndex, ByteBuffer buffer, String deviceId, MetadataIndexNodeType type, Map<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap, boolean needChunkMetadata) throws IOException {
            if (type.equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                while (buffer.hasRemaining()) {
                    long pos = startOffset + (long)buffer.position();
                    TimeseriesMetadata timeseriesMetadata = TimeseriesMetadata.deserializeFrom((ByteBuffer)buffer, (boolean)needChunkMetadata);
                    timeseriesMetadataMap.put(pos, (Pair<Path, TimeseriesMetadata>)new Pair((Object)new Path(deviceId, timeseriesMetadata.getMeasurementId()), (Object)timeseriesMetadata));
                }
            } else {
                if (type.equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
                    deviceId = metadataIndex.getName();
                }
                MetadataIndexNode metadataIndexNode = MetadataIndexNode.deserializeFrom((ByteBuffer)buffer);
                int metadataIndexListSize = metadataIndexNode.getChildren().size();
                for (int i = 0; i < metadataIndexListSize; ++i) {
                    long endOffset = metadataIndexNode.getEndOffset();
                    if (i != metadataIndexListSize - 1) {
                        endOffset = ((MetadataIndexEntry)metadataIndexNode.getChildren().get(i + 1)).getOffset();
                    }
                    ByteBuffer nextBuffer = this.readData(((MetadataIndexEntry)metadataIndexNode.getChildren().get(i)).getOffset(), endOffset);
                    this.genTSMetadataFromMetaIndexEntry(((MetadataIndexEntry)metadataIndexNode.getChildren().get(i)).getOffset(), (MetadataIndexEntry)metadataIndexNode.getChildren().get(i), nextBuffer, deviceId, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadata);
                }
            }
        }

        public Map<Long, Pair<Path, TimeseriesMetadata>> getAllTimeseriesMeta(boolean needChunkMetadata) throws IOException {
            if (this.tsFileMetaData == null) {
                this.readFileMetadata();
            }
            MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
            TreeMap<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap = new TreeMap<Long, Pair<Path, TimeseriesMetadata>>();
            List metadataIndexEntryList = metadataIndexNode.getChildren();
            for (int i = 0; i < metadataIndexEntryList.size(); ++i) {
                MetadataIndexEntry metadataIndexEntry = (MetadataIndexEntry)metadataIndexEntryList.get(i);
                long endOffset = this.tsFileMetaData.getMetadataIndex().getEndOffset();
                if (i != metadataIndexEntryList.size() - 1) {
                    endOffset = ((MetadataIndexEntry)metadataIndexEntryList.get(i + 1)).getOffset();
                }
                ByteBuffer buffer = this.readData(metadataIndexEntry.getOffset(), endOffset);
                this.genTSMetadataFromMetaIndexEntry(metadataIndexEntry.getOffset(), metadataIndexEntry, buffer, null, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadata);
            }
            return timeseriesMetadataMap;
        }

        public TsFileMetadata readFileMetadata() throws IOException {
            if (this.tsFileMetaData != null) {
                return this.tsFileMetaData;
            }
            try {
                this.tsFileMetaData = TsFileMetadata.deserializeFrom((ByteBuffer)this.readData(this.getFileMetadataPos(), (int)this.getFileMetadataSize()));
            }
            catch (BufferOverflowException e) {
                logger.error("readFileMetadata(), reading file metadata of file {}", (Object)this.file);
                throw e;
            }
            return this.tsFileMetaData;
        }
    }
}

