/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver.manager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.db.sync.conf.SyncPathUtil;
import org.apache.iotdb.db.sync.receiver.manager.PipeInfo;
import org.apache.iotdb.db.sync.receiver.manager.PipeMessage;
import org.apache.iotdb.db.sync.receiver.recovery.ReceiverLog;
import org.apache.iotdb.db.sync.receiver.recovery.ReceiverLogAnalyzer;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiverManager {
    private static final Logger logger = LoggerFactory.getLogger(ReceiverManager.class);
    private boolean pipeServerEnable;
    private Map<String, Map<String, Map<Long, Pipe.PipeStatus>>> pipeInfos;
    private Map<String, List<PipeMessage>> pipeMessageMap;
    private ReceiverLog log;

    public void init() throws StartupException {
        this.log = new ReceiverLog();
        ReceiverLogAnalyzer analyzer = new ReceiverLogAnalyzer();
        analyzer.scan();
        this.pipeInfos = analyzer.getPipeInfos();
        this.pipeServerEnable = analyzer.isPipeServerEnable();
        this.pipeMessageMap = analyzer.getPipeMessageMap();
    }

    public void close() throws IOException {
        this.log.close();
    }

    public void startServer() throws IOException {
        this.log.startPipeServer();
        this.pipeServerEnable = true;
    }

    public void stopServer() throws IOException {
        this.log.stopPipeServer();
        this.pipeServerEnable = false;
    }

    public void createPipe(String pipeName, String remoteIp, long createTime) throws IOException {
        this.log.createPipe(pipeName, remoteIp, createTime);
        this.pipeInfos.putIfAbsent(pipeName, new HashMap());
        this.pipeInfos.get(pipeName).putIfAbsent(remoteIp, new HashMap());
        this.pipeInfos.get(pipeName).get(remoteIp).put(createTime, Pipe.PipeStatus.STOP);
    }

    public void startPipe(String pipeName, String remoteIp, long createTime) throws IOException {
        this.log.startPipe(pipeName, remoteIp, createTime);
        this.pipeInfos.get(pipeName).get(remoteIp).put(createTime, Pipe.PipeStatus.RUNNING);
    }

    public void stopPipe(String pipeName, String remoteIp, long createTime) throws IOException {
        this.log.stopPipe(pipeName, remoteIp, createTime);
        this.pipeInfos.get(pipeName).get(remoteIp).put(createTime, Pipe.PipeStatus.STOP);
    }

    public void dropPipe(String pipeName, String remoteIp, long createTime) throws IOException {
        this.log.dropPipe(pipeName, remoteIp, createTime);
        this.pipeInfos.get(pipeName).get(remoteIp).put(createTime, Pipe.PipeStatus.DROP);
    }

    public List<PipeInfo> getPipeInfosByPipeName(String pipeName) {
        if (!this.pipeInfos.containsKey(pipeName)) {
            return Collections.emptyList();
        }
        ArrayList<PipeInfo> res = new ArrayList<PipeInfo>();
        for (Map.Entry<String, Map<Long, Pipe.PipeStatus>> remoteIpEntry : this.pipeInfos.get(pipeName).entrySet()) {
            for (Map.Entry<Long, Pipe.PipeStatus> createTimeEntry : remoteIpEntry.getValue().entrySet()) {
                res.add(new PipeInfo(pipeName, remoteIpEntry.getKey(), createTimeEntry.getValue(), createTimeEntry.getKey()));
            }
        }
        return res;
    }

    public PipeInfo getPipeInfo(String pipeName, String remoteIp, long createTime) {
        if (this.pipeInfos.containsKey(pipeName) && this.pipeInfos.get(pipeName).containsKey(remoteIp) && this.pipeInfos.get(pipeName).get(remoteIp).containsKey(createTime)) {
            return new PipeInfo(pipeName, remoteIp, this.pipeInfos.get(pipeName).get(remoteIp).get(createTime), createTime);
        }
        return null;
    }

    public List<PipeInfo> getAllPipeInfos() {
        ArrayList<PipeInfo> res = new ArrayList<PipeInfo>();
        for (String pipeName : this.pipeInfos.keySet()) {
            res.addAll(this.getPipeInfosByPipeName(pipeName));
        }
        return res;
    }

    public synchronized void writePipeMessage(String pipeName, String remoteIp, long createTime, PipeMessage message) {
        String pipeIdentifier = SyncPathUtil.getReceiverPipeDirName(pipeName, remoteIp, createTime);
        try {
            this.log.writePipeMsg(pipeIdentifier, message);
        }
        catch (IOException e) {
            logger.error("Can not write pipe message {} from {} to disk because {}", new Object[]{message, pipeIdentifier, e.getMessage()});
        }
        this.pipeMessageMap.computeIfAbsent(pipeIdentifier, i -> new ArrayList()).add(message);
    }

    public synchronized List<PipeMessage> getPipeMessages(String pipeName, String remoteIp, long createTime, boolean consume) {
        List<PipeMessage> pipeMessageList = new ArrayList<PipeMessage>();
        String pipeIdentifier = SyncPathUtil.getReceiverPipeDirName(pipeName, remoteIp, createTime);
        if (consume) {
            try {
                this.log.comsumePipeMsg(pipeIdentifier);
            }
            catch (IOException e) {
                logger.error("Can not read pipe message about {} from disk because {}", (Object)pipeIdentifier, (Object)e.getMessage());
            }
        }
        if (this.pipeMessageMap.containsKey(pipeIdentifier)) {
            pipeMessageList = this.pipeMessageMap.get(pipeIdentifier);
            if (consume) {
                this.pipeMessageMap.remove(pipeIdentifier);
            }
        }
        return pipeMessageList;
    }

    public PipeMessage getPipeMessage(String pipeName, String remoteIp, long createTime, boolean consume) {
        List<PipeMessage> pipeMessageList = this.getPipeMessages(pipeName, remoteIp, createTime, consume);
        PipeMessage message = new PipeMessage(PipeMessage.MsgType.INFO, "");
        if (!pipeMessageList.isEmpty()) {
            for (PipeMessage pipeMessage : pipeMessageList) {
                if (pipeMessage.getType().getValue() <= message.getType().getValue()) continue;
                message = pipeMessage;
            }
        }
        return message;
    }

    public boolean isPipeServerEnable() {
        return this.pipeServerEnable;
    }

    public void setPipeServerEnable(boolean pipeServerEnable) {
        this.pipeServerEnable = pipeServerEnable;
    }

    public static ReceiverManager getInstance() {
        return ReceiverManagerHolder.INSTANCE;
    }

    private ReceiverManager() {
    }

    private static class ReceiverManagerHolder {
        private static final ReceiverManager INSTANCE = new ReceiverManager();

        private ReceiverManagerHolder() {
        }
    }
}

