/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver.recovery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.db.sync.receiver.manager.PipeMessage;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiverLogAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(ReceiverLogAnalyzer.class);
    private boolean pipeServerEnable = false;
    private Map<String, Map<String, Map<Long, Pipe.PipeStatus>>> pipeInfos = new ConcurrentHashMap<String, Map<String, Map<Long, Pipe.PipeStatus>>>();
    private Map<String, List<PipeMessage>> pipeMessageMap = new ConcurrentHashMap<String, List<PipeMessage>>();

    /*
     * Exception decompiling
     */
    public void scan() throws StartupException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isPipeServerEnable() {
        return this.pipeServerEnable;
    }

    public Map<String, Map<String, Map<Long, Pipe.PipeStatus>>> getPipeInfos() {
        return this.pipeInfos;
    }

    public Map<String, List<PipeMessage>> getPipeMessageMap() {
        return this.pipeMessageMap;
    }

    private void analyzeServiceLog(String logLine) {
        if (logLine.equals("on")) {
            this.pipeServerEnable = true;
        } else if (logLine.equals("off")) {
            this.pipeServerEnable = false;
        } else {
            String[] items = logLine.split(",");
            String pipeName = items[0];
            String remoteIp = items[1];
            long createTime = Long.parseLong(items[2]);
            if (items.length == 4) {
                Pipe.PipeStatus status = Pipe.PipeStatus.valueOf(items[3]);
                if (status.equals((Object)Pipe.PipeStatus.RUNNING)) {
                    this.pipeInfos.get(pipeName).get(remoteIp).put(createTime, Pipe.PipeStatus.STOP);
                } else {
                    this.pipeInfos.get(pipeName).get(remoteIp).put(createTime, status);
                }
            } else {
                this.pipeInfos.putIfAbsent(pipeName, new HashMap());
                this.pipeInfos.get(pipeName).putIfAbsent(remoteIp, new HashMap());
                this.pipeInfos.get(pipeName).get(remoteIp).put(createTime, Pipe.PipeStatus.STOP);
            }
        }
    }

    private void analyzeMsgLog(String logLine) {
        String[] items = logLine.split(",");
        String pipeIdentifier = items[0];
        if (items.length == 3) {
            PipeMessage message = new PipeMessage(PipeMessage.MsgType.valueOf(items[1]), items[2]);
            this.pipeMessageMap.computeIfAbsent(pipeIdentifier, i -> new ArrayList()).add(message);
        } else {
            this.pipeMessageMap.remove(pipeIdentifier);
        }
    }
}

