/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.recovery;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.sync.PipeException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.sys.CreatePipePlan;
import org.apache.iotdb.db.qp.physical.sys.CreatePipeSinkPlan;
import org.apache.iotdb.db.sync.conf.SyncPathUtil;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.sender.pipe.PipeSink;
import org.apache.iotdb.db.sync.sender.service.MsgManager;
import org.apache.iotdb.db.sync.sender.service.SenderService;

public class SenderLogAnalyzer {
    private final File senderLog = new File(SyncPathUtil.getSysDir(), "senderService.log");
    private final Map<String, PipeSink> pipeSinks;
    private final List<Pipe> pipes;
    private Pipe runningPipe;
    private Pipe.PipeStatus runningPipeStatus;
    private MsgManager msgManager;

    public SenderLogAnalyzer() throws IOException {
        if (!this.senderLog.exists()) {
            this.senderLog.createNewFile();
        }
        this.pipeSinks = new HashMap<String, PipeSink>();
        this.pipes = new ArrayList<Pipe>();
        this.msgManager = new MsgManager();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recover() throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(this.senderLog));
        int lineNumber = 0;
        String readLine = "";
        try {
            block17: while ((readLine = br.readLine()) != null) {
                ++lineNumber;
                String[] parseStrings = readLine.split("#");
                Operator.OperatorType type = Operator.OperatorType.valueOf(parseStrings[0]);
                switch (type) {
                    case CREATE_PIPESINK: {
                        readLine = br.readLine();
                        ++lineNumber;
                        CreatePipeSinkPlan pipeSinkPlan = CreatePipeSinkPlan.parseString(readLine);
                        this.pipeSinks.put(pipeSinkPlan.getPipeSinkName(), SenderService.getInstance().parseCreatePipeSinkPlan(pipeSinkPlan));
                        continue block17;
                    }
                    case DROP_PIPESINK: {
                        this.pipeSinks.remove(parseStrings[1]);
                        continue block17;
                    }
                    case CREATE_PIPE: {
                        readLine = br.readLine();
                        ++lineNumber;
                        CreatePipePlan pipePlan = CreatePipePlan.parseString(readLine);
                        this.runningPipe = SenderService.getInstance().parseCreatePipePlan(pipePlan, this.pipeSinks.get(pipePlan.getPipeSinkName()), Long.parseLong(parseStrings[1]));
                        this.pipes.add(this.runningPipe);
                        this.runningPipeStatus = this.runningPipe.getStatus();
                        this.msgManager.addPipe(this.runningPipe);
                        continue block17;
                    }
                    case STOP_PIPE: {
                        this.runningPipeStatus = Pipe.PipeStatus.STOP;
                        this.msgManager.recoverMsg(parseStrings);
                        continue block17;
                    }
                    case START_PIPE: {
                        this.runningPipeStatus = Pipe.PipeStatus.RUNNING;
                        this.msgManager.recoverMsg(parseStrings);
                        continue block17;
                    }
                    case DROP_PIPE: {
                        this.runningPipeStatus = Pipe.PipeStatus.DROP;
                        this.runningPipe.drop();
                        this.msgManager.removeAllPipe();
                        continue block17;
                    }
                }
                throw new UnsupportedOperationException(String.format("Can not recognize type %s.", type.name()));
            }
        }
        catch (Exception e) {
            throw new IOException(String.format("Recover error in line %d : %s, because %s", lineNumber, readLine, e));
        }
        if (this.pipes.size() > 0) {
            try {
                switch (this.runningPipeStatus) {
                    case RUNNING: {
                        this.runningPipe.start();
                        break;
                    }
                    case STOP: {
                        this.runningPipe.stop();
                        break;
                    }
                    case DROP: {
                        this.runningPipe.drop();
                        break;
                    }
                    default: {
                        throw new IOException(String.format("Can not recognize running pipe status %s.", new Object[]{this.runningPipeStatus}));
                    }
                }
            }
            catch (PipeException e) {
                throw new IOException((Throwable)((Object)e));
            }
        }
        br.close();
    }

    public Map<String, PipeSink> getRecoveryAllPipeSinks() {
        return this.pipeSinks;
    }

    public List<Pipe> getRecoveryAllPipes() {
        return this.pipes;
    }

    public Pipe getRecoveryRunningPipe() {
        return this.runningPipe;
    }

    public MsgManager getMsgManager() {
        return this.msgManager;
    }
}

