/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.io;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.wal.buffer.WALEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WALReader
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(WALReader.class);
    private static final int STREAM_BUFFER_SIZE = (int)IoTDBDescriptor.getInstance().getConfig().getWalFileSizeThresholdInByte() / 10;
    private static final int BATCH_LIMIT = 1000;
    private final File logFile;
    private final DataInputStream logStream;
    private final List<WALEntry> walEntries;
    private Iterator<WALEntry> itr = null;
    private boolean fileCorrupted = false;

    public WALReader(File logFile) throws FileNotFoundException {
        this.logFile = logFile;
        this.logStream = new DataInputStream(new BufferedInputStream(new FileInputStream(logFile), STREAM_BUFFER_SIZE));
        this.walEntries = new LinkedList<WALEntry>();
    }

    public boolean hasNext() {
        if (this.itr != null && this.itr.hasNext()) {
            return true;
        }
        try {
            if (this.fileCorrupted) {
                return false;
            }
            this.walEntries.clear();
            while (this.walEntries.size() < 1000) {
                WALEntry walEntry = WALEntry.deserialize(this.logStream);
                this.walEntries.add(walEntry);
            }
        }
        catch (EOFException e) {
            this.fileCorrupted = true;
        }
        catch (IllegalPathException e) {
            this.fileCorrupted = true;
            logger.warn("WALEntry of wal file {} contains illegal path, skip illegal WALEntries.", (Object)this.logFile, (Object)e);
        }
        catch (Exception e) {
            this.fileCorrupted = true;
            logger.warn("Fail to read WALEntry from wal file {}, skip broken WALEntries.", (Object)this.logFile, (Object)e);
        }
        if (this.walEntries.size() != 0) {
            this.itr = this.walEntries.iterator();
            return true;
        }
        return false;
    }

    public WALEntry next() {
        if (this.itr == null) {
            throw new NoSuchElementException();
        }
        return this.itr.next();
    }

    @Override
    public void close() throws IOException {
        this.logStream.close();
    }
}

