/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.recover.file;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.metadata.DataTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFilePlanRedoer {
    private static final Logger logger = LoggerFactory.getLogger(TsFilePlanRedoer.class);
    private final TsFileResource tsFileResource;
    private final boolean sequence;
    private final IDTable idTable;
    private IMemTable recoveryMemTable = new PrimitiveMemTable();

    public TsFilePlanRedoer(TsFileResource tsFileResource, boolean sequence, IDTable idTable) {
        this.tsFileResource = tsFileResource;
        this.sequence = sequence;
        this.idTable = idTable;
    }

    void redoDelete(DeletePlan deletePlan) throws IOException, MetadataException {
        List<PartialPath> paths = deletePlan.getPaths();
        for (PartialPath path : paths) {
            for (PartialPath device : IoTDB.schemaProcessor.getBelongedDevices(path)) {
                this.recoveryMemTable.delete(path, device, deletePlan.getDeleteStartTime(), deletePlan.getDeleteEndTime());
            }
            this.tsFileResource.getModFile().write(new Deletion(path, this.tsFileResource.getTsFileSize(), deletePlan.getDeleteStartTime(), deletePlan.getDeleteEndTime()));
        }
    }

    void redoInsert(InsertPlan plan) throws WriteProcessException, QueryProcessException {
        String deviceId;
        long lastEndTime;
        if (this.tsFileResource != null && (lastEndTime = this.tsFileResource.getEndTime(deviceId = plan.isAligned() ? plan.getDevicePath().getDevicePath().getFullPath() : plan.getDevicePath().getFullPath())) != Long.MIN_VALUE && lastEndTime >= plan.getMinTime() && this.sequence) {
            return;
        }
        plan.setMeasurementMNodes(new IMeasurementMNode[plan.getMeasurements().length]);
        try {
            if (IoTDBDescriptor.getInstance().getConfig().isEnableIDTable()) {
                this.idTable.getSeriesSchemas(plan);
            } else {
                IoTDB.schemaProcessor.getSeriesSchemasAndReadLockDevice(plan);
                plan.setDeviceID(DeviceIDFactory.getInstance().getDeviceID(plan.getDevicePath()));
            }
        }
        catch (IOException | MetadataException e) {
            throw new QueryProcessException("can't replay insert logs, ", e);
        }
        this.checkDataTypeAndMarkFailed(plan.getMeasurementMNodes(), plan);
        if (plan instanceof InsertRowPlan) {
            if (plan.isAligned()) {
                this.recoveryMemTable.insertAlignedRow((InsertRowPlan)plan);
            } else {
                this.recoveryMemTable.insert((InsertRowPlan)plan);
            }
        } else if (plan.isAligned()) {
            this.recoveryMemTable.insertAlignedTablet((InsertTabletPlan)plan, 0, ((InsertTabletPlan)plan).getRowCount());
        } else {
            this.recoveryMemTable.insertTablet((InsertTabletPlan)plan, 0, ((InsertTabletPlan)plan).getRowCount());
        }
    }

    void redoInsert(InsertNode node) throws WriteProcessException, QueryProcessException {
        if (this.tsFileResource != null) {
            String deviceId = node.isAligned() ? node.getDevicePath().getDevicePath().getFullPath() : node.getDevicePath().getFullPath();
            long lastEndTime = this.tsFileResource.getEndTime(deviceId);
            long minTimeInNode = node instanceof InsertRowNode ? ((InsertRowNode)node).getTime() : ((InsertTabletNode)node).getTimes()[0];
            if (lastEndTime != Long.MIN_VALUE && lastEndTime >= minTimeInNode && this.sequence) {
                return;
            }
        }
        if (!IoTDBDescriptor.getInstance().getConfig().isEnableIDTable()) {
            node.setDeviceID(DeviceIDFactory.getInstance().getDeviceID(node.getDevicePath()));
        }
        if (node instanceof InsertRowNode) {
            if (node.isAligned()) {
                this.recoveryMemTable.insertAlignedRow((InsertRowNode)node);
            } else {
                this.recoveryMemTable.insert((InsertRowNode)node);
            }
        } else if (node.isAligned()) {
            this.recoveryMemTable.insertAlignedTablet((InsertTabletNode)node, 0, ((InsertTabletNode)node).getRowCount());
        } else {
            this.recoveryMemTable.insertTablet((InsertTabletNode)node, 0, ((InsertTabletNode)node).getRowCount());
        }
    }

    private void checkDataTypeAndMarkFailed(IMeasurementMNode[] mNodes, InsertPlan tPlan) {
        for (int i = 0; i < mNodes.length; ++i) {
            if (mNodes[i] == null) {
                tPlan.markFailedMeasurementInsertion(i, (Exception)((Object)new PathNotExistException(tPlan.getDevicePath().getFullPath() + '.' + tPlan.getMeasurements()[i])));
                continue;
            }
            if (mNodes[i].getSchema().getType() == tPlan.getDataTypes()[i]) continue;
            tPlan.markFailedMeasurementInsertion(i, (Exception)((Object)new DataTypeMismatchException(tPlan.getDevicePath().getFullPath(), mNodes[i].getName(), tPlan.getDataTypes()[i], mNodes[i].getSchema().getType(), tPlan.getMinTime(), tPlan.getFirstValueOfIndex(i))));
        }
    }

    void resetRecoveryMemTable(IMemTable memTable) {
        this.recoveryMemTable = memTable;
    }

    IMemTable getRecoveryMemTable() {
        return this.recoveryMemTable;
    }
}

