/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.directories;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.strategy.DirectoryStrategy;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.LoadConfigurationException;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryManager {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryManager.class);
    private List<String> sequenceFileFolders = new ArrayList<String>(Arrays.asList(IoTDBDescriptor.getInstance().getConfig().getDataDirs()));
    private List<String> unsequenceFileFolders;
    private DirectoryStrategy sequenceStrategy;
    private DirectoryStrategy unsequenceStrategy;

    private DirectoryManager() {
        int i;
        for (i = 0; i < this.sequenceFileFolders.size(); ++i) {
            this.sequenceFileFolders.set(i, this.sequenceFileFolders.get(i) + File.separator + "sequence");
        }
        this.mkDataDirs(this.sequenceFileFolders);
        this.unsequenceFileFolders = new ArrayList<String>(Arrays.asList(IoTDBDescriptor.getInstance().getConfig().getDataDirs()));
        for (i = 0; i < this.unsequenceFileFolders.size(); ++i) {
            this.unsequenceFileFolders.set(i, this.unsequenceFileFolders.get(i) + File.separator + "unsequence");
        }
        this.mkDataDirs(this.unsequenceFileFolders);
        String strategyName = "";
        try {
            strategyName = IoTDBDescriptor.getInstance().getConfig().getMultiDirStrategyClassName();
            Class<?> clazz = Class.forName(strategyName);
            this.sequenceStrategy = (DirectoryStrategy)clazz.newInstance();
            this.sequenceStrategy.setFolders(this.sequenceFileFolders);
            this.unsequenceStrategy = (DirectoryStrategy)clazz.newInstance();
            this.unsequenceStrategy.setFolders(this.unsequenceFileFolders);
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("All disks of folders are full.", (Throwable)((Object)e));
        }
        catch (Exception e) {
            logger.error("Can't find strategy {} for mult-directories.", (Object)strategyName, (Object)e);
        }
    }

    public void updateFileFolders() throws LoadConfigurationException {
        try {
            ArrayList<String> sequenceFileFolders = new ArrayList<String>(Arrays.asList(IoTDBDescriptor.getInstance().getConfig().getDataDirs()));
            for (int i = 0; i < sequenceFileFolders.size(); ++i) {
                sequenceFileFolders.set(i, (String)sequenceFileFolders.get(i) + File.separator + "sequence");
            }
            this.mkDataDirs(sequenceFileFolders);
            ArrayList<String> unsequenceFileFolders = new ArrayList<String>(Arrays.asList(IoTDBDescriptor.getInstance().getConfig().getDataDirs()));
            for (int i = 0; i < unsequenceFileFolders.size(); ++i) {
                unsequenceFileFolders.set(i, (String)unsequenceFileFolders.get(i) + File.separator + "unsequence");
            }
            this.mkDataDirs(unsequenceFileFolders);
            this.sequenceStrategy.setFolders(sequenceFileFolders);
            this.unsequenceStrategy.setFolders(unsequenceFileFolders);
            this.sequenceFileFolders = sequenceFileFolders;
            this.unsequenceFileFolders = unsequenceFileFolders;
            logger.info("Success to update file folders.");
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("Fail to update file folders, use previous folders.", (Throwable)((Object)e));
            throw new LoadConfigurationException("Fail to update file folders because all disks of folders are full, use previous folders.");
        }
    }

    public void updateDirectoryStrategy() throws LoadConfigurationException {
        String strategyName = "";
        try {
            strategyName = IoTDBDescriptor.getInstance().getConfig().getMultiDirStrategyClassName();
            Class<?> clazz = Class.forName(strategyName);
            this.sequenceStrategy = (DirectoryStrategy)clazz.newInstance();
            this.sequenceStrategy.setFolders(this.sequenceFileFolders);
            this.unsequenceStrategy = (DirectoryStrategy)clazz.newInstance();
            this.unsequenceStrategy.setFolders(this.unsequenceFileFolders);
            logger.info("Success to update directory strategy.");
        }
        catch (Exception e) {
            logger.error("Fail to update directory strategy {}, use previous strategy", (Object)strategyName, (Object)e);
            throw new LoadConfigurationException(String.format("Fail to update directory strategy because can't find strategy %s for mult-directories, use previous strategy", strategyName));
        }
    }

    public static DirectoryManager getInstance() {
        return DirectoriesHolder.INSTANCE;
    }

    private void mkDataDirs(List<String> folders) {
        for (String folder : folders) {
            File file = FSFactoryProducer.getFSFactory().getFile(folder);
            if (file.mkdirs()) {
                logger.info("folder {} doesn't exist, create it", (Object)file.getPath());
                continue;
            }
            logger.info("create folder {} failed. Is the folder existed: {}", (Object)file.getPath(), (Object)file.exists());
        }
    }

    public String getNextFolderForSequenceFile() throws DiskSpaceInsufficientException {
        try {
            return this.sequenceFileFolders.get(this.sequenceStrategy.nextFolderIndex());
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("All disks of wal folders are full, change system mode to read-only.", (Throwable)((Object)e));
            CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.ReadOnly);
            throw e;
        }
    }

    public List<String> getAllSequenceFileFolders() {
        return new ArrayList<String>(this.sequenceFileFolders);
    }

    public String getNextFolderForUnSequenceFile() throws DiskSpaceInsufficientException {
        try {
            return this.unsequenceFileFolders.get(this.unsequenceStrategy.nextFolderIndex());
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("All disks of wal folders are full, change system mode to read-only.", (Throwable)((Object)e));
            CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.ReadOnly);
            throw e;
        }
    }

    public List<String> getAllUnSequenceFileFolders() {
        return new ArrayList<String>(this.unsequenceFileFolders);
    }

    public List<String> getAllFilesFolders() {
        ArrayList<String> folders = new ArrayList<String>(this.sequenceFileFolders);
        folders.addAll(this.unsequenceFileFolders);
        return folders;
    }

    public void resetFolders() {
        int i;
        this.sequenceFileFolders = new ArrayList<String>(Arrays.asList(IoTDBDescriptor.getInstance().getConfig().getDataDirs()));
        for (i = 0; i < this.sequenceFileFolders.size(); ++i) {
            this.sequenceFileFolders.set(i, this.sequenceFileFolders.get(i) + File.separator + "sequence");
        }
        this.unsequenceFileFolders = new ArrayList<String>(Arrays.asList(IoTDBDescriptor.getInstance().getConfig().getDataDirs()));
        for (i = 0; i < this.unsequenceFileFolders.size(); ++i) {
            this.unsequenceFileFolders.set(i, this.unsequenceFileFolders.get(i) + File.separator + "unsequence");
        }
    }

    private static class DirectoriesHolder {
        private static final DirectoryManager INSTANCE = new DirectoryManager();

        private DirectoriesHolder() {
        }
    }
}

