/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cq;

import java.io.IOException;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.commons.concurrent.WrappedRunnable;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.selectinto.InsertTabletPlansIterator;
import org.apache.iotdb.db.exception.ContinuousQueryException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertMultiTabletsPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateContinuousQueryPlan;
import org.apache.iotdb.db.qp.strategy.LogicalGenerator;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousQueryTask
extends WrappedRunnable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ContinuousQueryTask.class);
    protected static final Pattern PATH_NODE_NAME_PATTERN = Pattern.compile("\\$\\{\\w+}");
    protected static final int EXECUTION_BATCH_SIZE = 5000;
    protected final ServiceProvider serviceProvider;
    protected final CreateContinuousQueryPlan continuousQueryPlan;
    protected final long windowEndTimestamp;

    public ContinuousQueryTask(CreateContinuousQueryPlan continuousQueryPlan, long windowEndTimestamp) {
        this.continuousQueryPlan = continuousQueryPlan;
        this.windowEndTimestamp = windowEndTimestamp;
        this.serviceProvider = IoTDB.serviceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runMayThrow() throws QueryProcessException, StorageEngineException, IOException, InterruptedException, QueryFilterOptimizationException, MetadataException, TException, SQLException {
        String sql = this.generateSQL();
        Operator operator = LogicalGenerator.generate(sql, ZoneId.systemDefault());
        if (!operator.isQuery()) {
            throw new ContinuousQueryException(String.format("unsupported operation in cq task: %s", operator.getType().name()));
        }
        QueryOperator queryOperator = (QueryOperator)operator;
        GroupByTimePlan queryPlan = (GroupByTimePlan)this.serviceProvider.getPlanner().operatorToPhysicalPlan(queryOperator);
        if (queryPlan.getDeduplicatedPaths().isEmpty()) {
            if (this.continuousQueryPlan.isDebug()) {
                LOGGER.info(this.continuousQueryPlan.getContinuousQueryName() + ": deduplicated paths empty.");
            }
            return;
        }
        long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
        try {
            QueryContext queryContext = this.serviceProvider.genQueryContext(queryId, queryPlan.isDebug(), System.currentTimeMillis(), sql, 0L);
            QueryDataSet queryDataSet = this.serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
            if (queryDataSet == null || queryDataSet.getPaths().size() == 0) {
                if (this.continuousQueryPlan.isDebug()) {
                    LOGGER.info(this.continuousQueryPlan.getContinuousQueryName() + ": query result empty.");
                }
                return;
            }
            this.doInsert(sql, queryOperator, queryPlan, queryDataSet);
        }
        finally {
            ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
        }
    }

    protected String generateSQL() {
        return this.continuousQueryPlan.getQuerySqlBeforeGroupByClause() + "group by ([" + (this.windowEndTimestamp - this.continuousQueryPlan.getForInterval()) + ',' + this.windowEndTimestamp + ")," + this.continuousQueryPlan.getGroupByTimeIntervalString() + ") " + (this.continuousQueryPlan.getQuerySqlAfterGroupByClause().equals("") ? "" : ", ") + this.continuousQueryPlan.getQuerySqlAfterGroupByClause();
    }

    protected void doInsert(String sql, QueryOperator queryOperator, GroupByTimePlan queryPlan, QueryDataSet queryDataSet) throws MetadataException, QueryProcessException, StorageEngineException, IOException {
        InsertTabletPlansIterator insertTabletPlansIterator = new InsertTabletPlansIterator(queryPlan, queryDataSet, queryOperator.getFromComponent().getPrefixPaths().get(0), this.generateTargetPaths(queryDataSet.getPaths()), false);
        while (insertTabletPlansIterator.hasNext()) {
            List<InsertTabletPlan> insertTabletPlans = insertTabletPlansIterator.next();
            if (insertTabletPlans.isEmpty() || this.serviceProvider.executeNonQuery(new InsertMultiTabletsPlan(insertTabletPlans))) continue;
            throw new ContinuousQueryException(String.format("failed to execute cq task %s, sql: %s", this.continuousQueryPlan.getContinuousQueryName(), sql));
        }
    }

    protected List<PartialPath> generateTargetPaths(List<Path> rawPaths) throws IllegalPathException {
        ArrayList<PartialPath> targetPaths = new ArrayList<PartialPath>(rawPaths.size());
        for (Path rawPath : rawPaths) {
            targetPaths.add(new PartialPath(this.fillTargetPathTemplate((PartialPath)rawPath)));
        }
        return targetPaths;
    }

    protected String fillTargetPathTemplate(PartialPath rawPath) throws IllegalPathException {
        int indexOfRightBracket;
        String fullPath = rawPath.getFullPath();
        int indexOfLeftBracket = fullPath.indexOf("(");
        if (indexOfLeftBracket != -1) {
            fullPath = fullPath.substring(indexOfLeftBracket + 1);
        }
        if ((indexOfRightBracket = fullPath.lastIndexOf(")")) != -1) {
            fullPath = fullPath.substring(0, indexOfRightBracket);
        }
        String[] nodes = new PartialPath(fullPath).getNodes();
        StringBuffer sb = new StringBuffer();
        Matcher m = PATH_NODE_NAME_PATTERN.matcher(this.continuousQueryPlan.getTargetPath().getFullPath());
        while (m.find()) {
            String param = m.group();
            String value = nodes[Integer.parseInt(param.substring(2, param.length() - 1).trim())];
            m.appendReplacement(sb, value == null ? "" : value);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public void onRejection() {
        LOGGER.warn("continuous query task {} was rejected, sql: {}", (Object)this.continuousQueryPlan.getContinuousQueryName(), (Object)this.generateSQL());
    }
}

