/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.db.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.wal.utils.WALWriteUtils;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlignedWritableMemChunk
implements IWritableMemChunk {
    private final Map<String, Integer> measurementIndexMap = new LinkedHashMap<String, Integer>();
    private final List<IMeasurementSchema> schemaList;
    private AlignedTVList list;
    private static final String UNSUPPORTED_TYPE = "Unsupported data type:";
    private static final Logger LOGGER = LoggerFactory.getLogger(AlignedWritableMemChunk.class);

    public AlignedWritableMemChunk(List<IMeasurementSchema> schemaList) {
        ArrayList<TSDataType> dataTypeList = new ArrayList<TSDataType>();
        this.schemaList = schemaList;
        for (int i = 0; i < schemaList.size(); ++i) {
            this.measurementIndexMap.put(schemaList.get(i).getMeasurementId(), i);
            dataTypeList.add(schemaList.get(i).getType());
        }
        this.list = AlignedTVList.newAlignedList(dataTypeList);
    }

    private AlignedWritableMemChunk(List<IMeasurementSchema> schemaList, AlignedTVList list) {
        this.schemaList = schemaList;
        for (int i = 0; i < schemaList.size(); ++i) {
            this.measurementIndexMap.put(schemaList.get(i).getMeasurementId(), i);
        }
        this.list = list;
    }

    public Set<String> getAllMeasurements() {
        return this.measurementIndexMap.keySet();
    }

    public boolean containsMeasurement(String measurementId) {
        return this.measurementIndexMap.containsKey(measurementId);
    }

    @Override
    public void putLong(long t, long v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putInt(long t, int v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putFloat(long t, float v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putDouble(long t, double v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putBinary(long t, Binary v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putBoolean(long t, boolean v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putAlignedValue(long t, Object[] v, int[] columnIndexArray) {
        this.list.putAlignedValue(t, v, columnIndexArray);
    }

    @Override
    public void putLongs(long[] t, long[] v, BitMap bitMap, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putInts(long[] t, int[] v, BitMap bitMap, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putFloats(long[] t, float[] v, BitMap bitMap, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putDoubles(long[] t, double[] v, BitMap bitMap, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putBinaries(long[] t, Binary[] v, BitMap bitMap, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putBooleans(long[] t, boolean[] v, BitMap bitMap, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putAlignedValues(long[] t, Object[] v, BitMap[] bitMaps, int[] columnIndexArray, int start, int end) {
        this.list.putAlignedValues(t, v, bitMaps, columnIndexArray, start, end);
    }

    @Override
    public void write(long insertTime, Object objectValue) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void writeAlignedValue(long insertTime, Object[] objectValue, List<IMeasurementSchema> schemaList) {
        int[] columnIndexArray = this.checkColumnsInInsertPlan(schemaList);
        this.putAlignedValue(insertTime, objectValue, columnIndexArray);
    }

    @Override
    public void write(long[] times, Object valueList, BitMap bitMap, TSDataType dataType, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void writeAlignedValues(long[] times, Object[] valueList, BitMap[] bitMaps, List<IMeasurementSchema> schemaList, int start, int end) {
        int[] columnIndexArray = this.checkColumnsInInsertPlan(schemaList);
        this.putAlignedValues(times, valueList, bitMaps, columnIndexArray, start, end);
    }

    private int[] checkColumnsInInsertPlan(List<IMeasurementSchema> schemaListInInsertPlan) {
        HashMap<String, Integer> measurementIdsInInsertPlan = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < schemaListInInsertPlan.size(); ++i2) {
            if (schemaListInInsertPlan.get(i2) == null) continue;
            measurementIdsInInsertPlan.put(schemaListInInsertPlan.get(i2).getMeasurementId(), i2);
            if (this.containsMeasurement(schemaListInInsertPlan.get(i2).getMeasurementId())) continue;
            this.measurementIndexMap.put(schemaListInInsertPlan.get(i2).getMeasurementId(), this.measurementIndexMap.size());
            this.schemaList.add(schemaListInInsertPlan.get(i2));
            this.list.extendColumn(schemaListInInsertPlan.get(i2).getType());
        }
        int[] columnIndexArray = new int[this.measurementIndexMap.size()];
        this.measurementIndexMap.forEach((measurementId, i) -> {
            columnIndexArray[i.intValue()] = measurementIdsInInsertPlan.getOrDefault(measurementId, -1);
        });
        return columnIndexArray;
    }

    @Override
    public TVList getTVList() {
        return this.list;
    }

    @Override
    public long count() {
        return (long)this.list.rowCount() * (long)this.measurementIndexMap.size();
    }

    public long alignedListSize() {
        return this.list.rowCount();
    }

    @Override
    public IMeasurementSchema getSchema() {
        return null;
    }

    @Override
    public synchronized TVList getSortedTvListForQuery() {
        this.sortTVList();
        this.list.increaseReferenceCount();
        return this.list;
    }

    @Override
    public synchronized TVList getSortedTvListForQuery(List<IMeasurementSchema> schemaList) {
        this.sortTVList();
        this.list.increaseReferenceCount();
        ArrayList<Integer> columnIndexList = new ArrayList<Integer>();
        ArrayList<TSDataType> dataTypeList = new ArrayList<TSDataType>();
        for (IMeasurementSchema measurementSchema : schemaList) {
            columnIndexList.add(this.measurementIndexMap.getOrDefault(measurementSchema.getMeasurementId(), -1));
            dataTypeList.add(measurementSchema.getType());
        }
        return this.list.getTvListByColumnIndex(columnIndexList, dataTypeList);
    }

    private void sortTVList() {
        if (this.list.getReferenceCount() > 0 && !this.list.isSorted()) {
            this.list = this.list.clone();
        }
        if (!this.list.isSorted()) {
            this.list.sort();
        }
    }

    @Override
    public synchronized void sortTvListForFlush() {
        this.sortTVList();
    }

    @Override
    public int delete(long lowerBound, long upperBound) {
        return this.list.delete(lowerBound, upperBound);
    }

    public Pair<Integer, Boolean> deleteDataFromAColumn(long lowerBound, long upperBound, String measurementId) {
        return this.list.delete(lowerBound, upperBound, this.measurementIndexMap.get(measurementId));
    }

    public void removeColumn(String measurementId) {
        this.list.deleteColumn(this.measurementIndexMap.get(measurementId));
        IMeasurementSchema schemaToBeRemoved = this.schemaList.get(this.measurementIndexMap.get(measurementId));
        this.schemaList.remove(schemaToBeRemoved);
        this.measurementIndexMap.clear();
        for (int i = 0; i < this.schemaList.size(); ++i) {
            this.measurementIndexMap.put(this.schemaList.get(i).getMeasurementId(), i);
        }
    }

    @Override
    public IChunkWriter createIChunkWriter() {
        return new AlignedChunkWriterImpl(this.schemaList);
    }

    @Override
    public void encode(IChunkWriter chunkWriter) {
        AlignedChunkWriterImpl alignedChunkWriter = (AlignedChunkWriterImpl)chunkWriter;
        ArrayList<Integer> timeDuplicateAlignedRowIndexList = null;
        for (int sortedRowIndex = 0; sortedRowIndex < this.list.rowCount(); ++sortedRowIndex) {
            long time = this.list.getTime(sortedRowIndex);
            if (sortedRowIndex + 1 < this.list.rowCount() && time == this.list.getTime(sortedRowIndex + 1)) {
                if (timeDuplicateAlignedRowIndexList == null) {
                    timeDuplicateAlignedRowIndexList = new ArrayList<Integer>();
                    timeDuplicateAlignedRowIndexList.add(this.list.getValueIndex(sortedRowIndex));
                }
                timeDuplicateAlignedRowIndexList.add(this.list.getValueIndex(sortedRowIndex + 1));
                continue;
            }
            List<TSDataType> dataTypes = this.list.getTsDataTypes();
            int originRowIndex = this.list.getValueIndex(sortedRowIndex);
            block9: for (int columnIndex = 0; columnIndex < dataTypes.size(); ++columnIndex) {
                if (timeDuplicateAlignedRowIndexList != null && !timeDuplicateAlignedRowIndexList.isEmpty()) {
                    originRowIndex = this.list.getValidRowIndexForTimeDuplicatedRows(timeDuplicateAlignedRowIndexList, columnIndex);
                }
                boolean isNull = this.list.isNullValue(originRowIndex, columnIndex);
                switch (dataTypes.get(columnIndex)) {
                    case BOOLEAN: {
                        alignedChunkWriter.write(time, this.list.getBooleanByValueIndex(originRowIndex, columnIndex), isNull);
                        continue block9;
                    }
                    case INT32: {
                        alignedChunkWriter.write(time, this.list.getIntByValueIndex(originRowIndex, columnIndex), isNull);
                        continue block9;
                    }
                    case INT64: {
                        alignedChunkWriter.write(time, this.list.getLongByValueIndex(originRowIndex, columnIndex), isNull);
                        continue block9;
                    }
                    case FLOAT: {
                        alignedChunkWriter.write(time, this.list.getFloatByValueIndex(originRowIndex, columnIndex), isNull);
                        continue block9;
                    }
                    case DOUBLE: {
                        alignedChunkWriter.write(time, this.list.getDoubleByValueIndex(originRowIndex, columnIndex), isNull);
                        continue block9;
                    }
                    case TEXT: {
                        alignedChunkWriter.write(time, this.list.getBinaryByValueIndex(originRowIndex, columnIndex), isNull);
                        continue block9;
                    }
                    default: {
                        LOGGER.error("AlignedWritableMemChunk does not support data type: {}", (Object)dataTypes.get(columnIndex));
                    }
                }
            }
            alignedChunkWriter.write(time);
            timeDuplicateAlignedRowIndexList = null;
        }
    }

    @Override
    public void release() {
        if (this.list.getReferenceCount() == 0) {
            this.list.clear();
        }
    }

    @Override
    public long getFirstPoint() {
        if (this.list.rowCount() == 0) {
            return Long.MAX_VALUE;
        }
        return this.getSortedTvListForQuery().getTimeValuePair(0).getTimestamp();
    }

    @Override
    public long getLastPoint() {
        if (this.list.rowCount() == 0) {
            return Long.MIN_VALUE;
        }
        return this.getSortedTvListForQuery().getTimeValuePair(this.getSortedTvListForQuery().rowCount() - 1).getTimestamp();
    }

    @Override
    public int serializedSize() {
        int size = 0;
        size += 4;
        for (IMeasurementSchema schema : this.schemaList) {
            size += schema.serializedSize();
        }
        return size += this.list.serializedSize();
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        WALWriteUtils.write(this.schemaList.size(), buffer);
        for (IMeasurementSchema schema : this.schemaList) {
            byte[] bytes = new byte[schema.serializedSize()];
            schema.serializeTo(ByteBuffer.wrap(bytes));
            buffer.put(bytes);
        }
        this.list.serializeToWAL(buffer);
    }

    public static AlignedWritableMemChunk deserialize(DataInputStream stream) throws IOException {
        int schemaListSize = stream.readInt();
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>(schemaListSize);
        for (int i = 0; i < schemaListSize; ++i) {
            MeasurementSchema schema = MeasurementSchema.deserializeFrom((InputStream)stream);
            schemaList.add((IMeasurementSchema)schema);
        }
        AlignedTVList list = (AlignedTVList)TVList.deserialize(stream);
        return new AlignedWritableMemChunk(schemaList, list);
    }
}

