/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.cache;

import org.apache.iotdb.db.metadata.lastCache.container.ILastCacheContainer;
import org.apache.iotdb.db.metadata.lastCache.container.LastCacheContainer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class SchemaCacheEntry {
    private final MeasurementSchema measurementSchema;
    private final boolean isAligned;
    private volatile ILastCacheContainer lastCacheContainer = null;

    SchemaCacheEntry(MeasurementSchema measurementSchema, boolean isAligned) {
        this.measurementSchema = measurementSchema;
        this.isAligned = isAligned;
    }

    public String getSchemaEntryId() {
        return this.measurementSchema.getMeasurementId();
    }

    public MeasurementSchema getMeasurementSchema() {
        return this.measurementSchema;
    }

    public TSDataType getTsDataType() {
        return this.measurementSchema.getType();
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILastCacheContainer getLastCacheContainer() {
        if (this.lastCacheContainer == null) {
            SchemaCacheEntry schemaCacheEntry = this;
            synchronized (schemaCacheEntry) {
                if (this.lastCacheContainer == null) {
                    this.lastCacheContainer = new LastCacheContainer();
                }
            }
        }
        return this.lastCacheContainer;
    }

    public void setLastCacheContainer(ILastCacheContainer lastCacheContainer) {
        this.lastCacheContainer = lastCacheContainer;
    }

    public static int estimateSize(SchemaCacheEntry schemaCacheEntry) {
        return 100 + 2 * schemaCacheEntry.getMeasurementSchema().getMeasurementId().length();
    }
}

