/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.cache;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.cache.CacheEntry;
import org.apache.iotdb.db.metadata.mtree.store.disk.cache.CacheManager;

public class LRUCacheManager
extends CacheManager {
    private static final int NUM_OF_LIST = 17;
    private LRUCacheList[] lruCacheLists = new LRUCacheList[17];

    public LRUCacheManager() {
        for (int i = 0; i < 17; ++i) {
            this.lruCacheLists[i] = new LRUCacheList();
        }
    }

    @Override
    public void updateCacheStatusAfterAccess(CacheEntry cacheEntry) {
        LRUCacheEntry lruCacheEntry = this.getAsLRUCacheEntry(cacheEntry);
        this.getTargetCacheList(lruCacheEntry).updateCacheStatusAfterAccess(lruCacheEntry);
    }

    @Override
    protected void updateCacheStatusAfterUpdate(CacheEntry cacheEntry, IMNode node) {
        this.getAsLRUCacheEntry(cacheEntry).setNode(node);
    }

    @Override
    protected void initCacheEntryForNode(IMNode node) {
        LRUCacheEntry cacheEntry = new LRUCacheEntry(node);
        node.setCacheEntry(cacheEntry);
    }

    @Override
    protected boolean isInNodeCache(CacheEntry cacheEntry) {
        LRUCacheEntry lruCacheEntry = this.getAsLRUCacheEntry(cacheEntry);
        return this.getTargetCacheList(lruCacheEntry).isInCacheList(lruCacheEntry);
    }

    @Override
    protected void addToNodeCache(CacheEntry cacheEntry, IMNode node) {
        LRUCacheEntry lruCacheEntry = this.getAsLRUCacheEntry(cacheEntry);
        this.getTargetCacheList(lruCacheEntry).addToCacheList(lruCacheEntry, node);
    }

    @Override
    protected void removeFromNodeCache(CacheEntry cacheEntry) {
        LRUCacheEntry lruCacheEntry = this.getAsLRUCacheEntry(cacheEntry);
        this.getTargetCacheList(lruCacheEntry).removeFromCacheList(lruCacheEntry);
    }

    @Override
    protected IMNode getPotentialNodeTobeEvicted() {
        LRUCacheList cacheList;
        IMNode result = null;
        LRUCacheList[] lRUCacheListArray = this.lruCacheLists;
        int n = lRUCacheListArray.length;
        for (int i = 0; i < n && (result = (cacheList = lRUCacheListArray[i]).getPotentialNodeTobeEvicted()) == null; ++i) {
        }
        return result;
    }

    @Override
    protected void clearNodeCache() {
        for (LRUCacheList lruCacheList : this.lruCacheLists) {
            lruCacheList.clear();
        }
    }

    private LRUCacheEntry getAsLRUCacheEntry(CacheEntry cacheEntry) {
        return (LRUCacheEntry)cacheEntry;
    }

    private LRUCacheList getTargetCacheList(LRUCacheEntry lruCacheEntry) {
        return this.lruCacheLists[this.getCacheListLoc(lruCacheEntry)];
    }

    private int getCacheListLoc(LRUCacheEntry lruCacheEntry) {
        int hash = lruCacheEntry.hashCode() % 17;
        return hash < 0 ? hash + 17 : hash;
    }

    private static class LRUCacheList {
        private volatile LRUCacheEntry first;
        private volatile LRUCacheEntry last;
        private final Lock lock = new ReentrantLock();

        private LRUCacheList() {
        }

        private void updateCacheStatusAfterAccess(LRUCacheEntry lruCacheEntry) {
            this.lock.lock();
            try {
                if (this.isInCacheList(lruCacheEntry)) {
                    this.moveToFirst(lruCacheEntry);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private void addToCacheList(LRUCacheEntry lruCacheEntry, IMNode node) {
            this.lock.lock();
            try {
                lruCacheEntry.setNode(node);
                this.moveToFirst(lruCacheEntry);
            }
            finally {
                this.lock.unlock();
            }
        }

        private void removeFromCacheList(LRUCacheEntry lruCacheEntry) {
            this.lock.lock();
            try {
                this.removeOne(lruCacheEntry);
            }
            finally {
                this.lock.unlock();
            }
        }

        private IMNode getPotentialNodeTobeEvicted() {
            this.lock.lock();
            try {
                LRUCacheEntry target;
                for (target = this.last; target != null && target.isPinned(); target = target.getPre()) {
                }
                IMNode iMNode = target == null ? null : target.getNode();
                return iMNode;
            }
            finally {
                this.lock.unlock();
            }
        }

        private void clear() {
            this.first = null;
            this.last = null;
        }

        private void moveToFirst(LRUCacheEntry entry) {
            if (this.first == null || this.last == null) {
                this.first = this.last = entry;
                return;
            }
            if (this.first == entry) {
                return;
            }
            if (entry.getPre() != null) {
                entry.getPre().setNext(entry.getNext());
            }
            if (entry.getNext() != null) {
                entry.getNext().setPre(entry.getPre());
            }
            if (entry == this.last) {
                this.last = this.last.getPre();
            }
            entry.setNext(this.first);
            this.first.setPre(entry);
            this.first = entry;
            this.first.setPre(null);
        }

        private void removeOne(LRUCacheEntry entry) {
            if (entry.getPre() != null) {
                entry.getPre().setNext(entry.getNext());
            }
            if (entry.getNext() != null) {
                entry.getNext().setPre(entry.getPre());
            }
            if (entry == this.first) {
                this.first = entry.getNext();
            }
            if (entry == this.last) {
                this.last = entry.getPre();
            }
            entry.setPre(null);
            entry.setNext(null);
        }

        private boolean isInCacheList(LRUCacheEntry entry) {
            return entry.getPre() != null || entry.getNext() != null || this.first == entry || this.last == entry;
        }
    }

    private static class LRUCacheEntry
    extends CacheEntry {
        protected volatile IMNode node;
        private volatile LRUCacheEntry pre = null;
        private volatile LRUCacheEntry next = null;

        public LRUCacheEntry(IMNode node) {
            this.node = node;
        }

        public IMNode getNode() {
            return this.node;
        }

        public void setNode(IMNode node) {
            this.node = node;
        }

        LRUCacheEntry getPre() {
            return this.pre;
        }

        void setPre(LRUCacheEntry pre) {
            this.pre = pre;
        }

        LRUCacheEntry getNext() {
            return this.next;
        }

        void setNext(LRUCacheEntry next) {
            this.next = next;
        }

        public int hashCode() {
            return this.node.getName().hashCode();
        }
    }
}

