/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.schemafile;

import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.metadata.mnode.EntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.ICachedMNodeContainer;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.template.TemplateManager;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class RecordUtils {
    static short INTERNAL_NODE_LENGTH = (short)16;
    static short MEASUREMENT_BASIC_LENGTH = (short)19;
    static short LENGTH_OFFSET = 1;
    static short ALIAS_OFFSET = (short)19;
    static short SEG_ADDRESS_OFFSET = (short)3;
    static short SCHEMA_OFFSET = (short)11;
    static short INTERNAL_BITFLAG_OFFSET = (short)15;
    static byte INTERNAL_TYPE = 0;
    static byte ENTITY_TYPE = 1;
    static byte MEASUREMENT_TYPE = (byte)4;

    public static ByteBuffer node2Buffer(IMNode node) {
        if (node.isMeasurement()) {
            return RecordUtils.measurement2Buffer(node.getAsMeasurementMNode());
        }
        return RecordUtils.internal2Buffer(node);
    }

    private static ByteBuffer internal2Buffer(IMNode node) {
        byte nodeType = INTERNAL_TYPE;
        boolean isAligned = false;
        if (node.isEntity()) {
            nodeType = ENTITY_TYPE;
            isAligned = node.getAsEntityMNode().isAligned();
        }
        ByteBuffer buffer = ByteBuffer.allocate(INTERNAL_NODE_LENGTH);
        ReadWriteIOUtils.write((byte)nodeType, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((short)INTERNAL_NODE_LENGTH, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((long)ICachedMNodeContainer.getCachedMNodeContainer(node).getSegmentAddress(), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((int)RecordUtils.convertTemplate2Int(node.getSchemaTemplate()), (ByteBuffer)buffer);
        byte useAndAligned = RecordUtils.encodeInternalStatus(node.isUseTemplate(), isAligned);
        ReadWriteIOUtils.write((byte)useAndAligned, (ByteBuffer)buffer);
        return buffer;
    }

    private static ByteBuffer measurement2Buffer(IMeasurementMNode node) {
        int bufferLength = node.getAlias() == null ? 4 + MEASUREMENT_BASIC_LENGTH : node.getAlias().getBytes().length + 4 + MEASUREMENT_BASIC_LENGTH;
        ByteBuffer buffer = ByteBuffer.allocate(bufferLength);
        ReadWriteIOUtils.write((byte)MEASUREMENT_TYPE, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((short)((short)bufferLength), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((long)RecordUtils.convertTags2Long(node), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((long)RecordUtils.convertSchema2Long(node), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((String)node.getAlias(), (ByteBuffer)buffer);
        return buffer;
    }

    public static IMNode buffer2Node(String nodeName, ByteBuffer buffer) throws MetadataException {
        byte nodeType = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
        if (nodeType < 2) {
            InternalMNode resNode;
            short recLen = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
            long segAddr = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
            int templateHash = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            byte bitFlag = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
            boolean usingTemplate = RecordUtils.usingTemplate(bitFlag);
            boolean isAligned = RecordUtils.isAligned(bitFlag);
            if (nodeType == 0) {
                resNode = new InternalMNode(null, nodeName);
            } else {
                resNode = new EntityMNode(null, nodeName);
                resNode.getAsEntityMNode().setAligned(isAligned);
            }
            ICachedMNodeContainer.getCachedMNodeContainer(resNode).setSegmentAddress(segAddr);
            resNode.setUseTemplate(usingTemplate);
            return RecordUtils.paddingTemplate(resNode, templateHash);
        }
        short recLenth = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
        long tagIndex = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        long schemaByte = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        String alias = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        return RecordUtils.paddingMeasurement(nodeName, tagIndex, schemaByte, alias);
    }

    public static short getRecordLength(ByteBuffer recBuf) {
        int oriPos = recBuf.position();
        recBuf.position(oriPos + LENGTH_OFFSET);
        short len = ReadWriteIOUtils.readShort((ByteBuffer)recBuf);
        recBuf.position(oriPos);
        return len;
    }

    public static byte getRecordType(ByteBuffer recBuf) {
        int oriPos = recBuf.position();
        recBuf.position(oriPos);
        byte type = ReadWriteIOUtils.readByte((ByteBuffer)recBuf);
        recBuf.position(oriPos);
        return type;
    }

    public static long getRecordSegAddr(ByteBuffer recBuf) {
        int oriPos = recBuf.position();
        recBuf.position(oriPos + SEG_ADDRESS_OFFSET);
        long addr = ReadWriteIOUtils.readLong((ByteBuffer)recBuf);
        recBuf.position(oriPos);
        return addr;
    }

    public static byte[] getSchemaBytes(ByteBuffer recBuf) {
        byte[] res = new byte[3];
        int oriPos = recBuf.position();
        recBuf.position(oriPos + SCHEMA_OFFSET);
        long schemaBytes = ReadWriteIOUtils.readLong((ByteBuffer)recBuf);
        res[0] = (byte)(schemaBytes >>> 16);
        res[1] = (byte)(schemaBytes >>> 8 & 0xFFL);
        res[2] = (byte)(schemaBytes & 0xFFL);
        recBuf.position(oriPos);
        return res;
    }

    public static boolean getAlignment(ByteBuffer recBuf) {
        int oriPos = recBuf.position();
        recBuf.position(oriPos + INTERNAL_BITFLAG_OFFSET);
        byte flag = ReadWriteIOUtils.readByte((ByteBuffer)recBuf);
        recBuf.position(oriPos);
        return RecordUtils.isAligned(flag);
    }

    public static String getRecordAlias(ByteBuffer recBuf) {
        int oriPos = recBuf.position();
        recBuf.position(oriPos + ALIAS_OFFSET);
        String alias = ReadWriteIOUtils.readString((ByteBuffer)recBuf);
        recBuf.position(oriPos);
        return alias;
    }

    public static void updateSegAddr(ByteBuffer recBuf, long newSegAddr) {
        int oriPos = recBuf.position();
        recBuf.position(oriPos + SEG_ADDRESS_OFFSET);
        ReadWriteIOUtils.write((long)newSegAddr, (ByteBuffer)recBuf);
        recBuf.position(oriPos);
    }

    public static String buffer2String(ByteBuffer buffer) throws MetadataException {
        StringBuilder builder = new StringBuilder("[");
        IMNode node = RecordUtils.buffer2Node("unspecified", buffer);
        if (node.isMeasurement()) {
            builder.append("measurementNode, ");
            builder.append(String.format("alias: %s, ", node.getAsMeasurementMNode().getAlias() == null ? "" : node.getAsMeasurementMNode().getAlias()));
            builder.append(String.format("type: %s, ", node.getAsMeasurementMNode().getDataType("").toString()));
            builder.append(String.format("encoding: %s, ", node.getAsMeasurementMNode().getSchema().getEncodingType().toString()));
            builder.append(String.format("compressor: %s]", node.getAsMeasurementMNode().getSchema().getCompressor().toString()));
            return builder.toString();
        }
        if (node.isEntity()) {
            builder.append("entityNode, ");
            if (node.getAsEntityMNode().isAligned()) {
                builder.append("aligned, ");
            } else {
                builder.append("not aligned, ");
            }
        } else {
            builder.append("internalNode, ");
        }
        if (node.isUseTemplate()) {
            builder.append("using template.]");
        } else {
            builder.append("not using template.]");
        }
        return builder.toString();
    }

    private static long convertTags2Long(IMeasurementMNode node) {
        return node.getOffset();
    }

    private static int convertTemplate2Int(Template temp) {
        return temp == null ? 0 : temp.hashCode();
    }

    private static IMNode paddingTemplate(IMNode node, int templateHashCode) throws MetadataException {
        if (templateHashCode != 0) {
            node.setSchemaTemplate(TemplateManager.getInstance().getTemplateFromHash(templateHashCode));
        }
        return node;
    }

    private static long convertSchema2Long(IMeasurementMNode node) {
        byte dataType = node.getSchema().getTypeInByte();
        byte encoding = node.getSchema().getEncodingType().serialize();
        byte compressor = node.getSchema().getCompressor().serialize();
        return dataType << 16 | encoding << 8 | compressor;
    }

    private static IMNode paddingMeasurement(String nodeName, long tagIndex, long schemaBytes, String alias) {
        byte dataType = (byte)(schemaBytes >>> 16);
        byte encoding = (byte)(schemaBytes >>> 8 & 0xFFL);
        byte compressor = (byte)(schemaBytes & 0xFFL);
        MeasurementSchema schema = new MeasurementSchema(nodeName, TSDataType.values()[dataType], TSEncoding.values()[encoding], CompressionType.values()[compressor]);
        IMeasurementMNode res = MeasurementMNode.getMeasurementMNode(null, nodeName, (IMeasurementSchema)schema, alias);
        res.getAsMeasurementMNode().setOffset(tagIndex);
        return res;
    }

    private static byte encodeInternalStatus(boolean usingTemplate, boolean isAligned) {
        byte flag = 0;
        if (usingTemplate) {
            flag = (byte)(flag | 1);
        }
        if (isAligned) {
            flag = (byte)(flag | 2);
        }
        return flag;
    }

    private static boolean isAligned(byte flag) {
        return (flag & 2) == 2;
    }

    private static boolean usingTemplate(byte flag) {
        return (flag & 1) == 1;
    }
}

