/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.upgrade;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.metadata.logfile.MLogReader;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.MNodeUtils;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.container.MNodeContainerMapImpl;
import org.apache.iotdb.db.metadata.tag.TagLogFile;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeTagOffsetPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.MNodePlan;
import org.apache.iotdb.db.qp.physical.sys.MeasurementMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.StorageGroupMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataUpgrader {
    private static final Logger logger = LoggerFactory.getLogger(MetadataUpgrader.class);
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private String schemaDirPath = this.config.getSchemaDir();
    private String mlogFilePath = this.schemaDirPath + File.separator + "mlog.bin";
    private File mlogFile = new File(this.mlogFilePath);
    private String tagFilePath = this.schemaDirPath + File.separator + "tlog.txt";
    private File tagFile = new File(this.tagFilePath);
    private String mtreeSnapshotPath = this.schemaDirPath + File.separator + "mtree-1.snapshot.bin";
    private String mtreeSnapshotTmpPath = this.schemaDirPath + File.separator + "mtree-1.snapshot.bin.tmp";
    private File snapshotFile = new File(this.mtreeSnapshotPath);
    private File snapshotTmpFile = new File(this.mtreeSnapshotTmpPath);
    LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;

    public static synchronized void upgrade() throws IOException {
        MetadataUpgrader upgrader = new MetadataUpgrader();
        logger.info("Start upgrading metadata files.");
        if (upgrader.clearEnvBeforeUpgrade()) {
            logger.info("Metadata files have already been upgraded.");
            return;
        }
        IoTDB.configManager.init();
        try {
            upgrader.reloadMetadataFromSnapshot();
            upgrader.redoMLog();
            upgrader.clearOldFiles();
            logger.info("Finish upgrading metadata files.");
        }
        finally {
            IoTDB.configManager.clear();
        }
    }

    private MetadataUpgrader() {
    }

    public boolean clearEnvBeforeUpgrade() throws IOException {
        if (this.mlogFile.exists()) {
            File dir = new File(this.schemaDirPath);
            File[] sgDirs = dir.listFiles((dir1, name) -> name.startsWith("root."));
            if (sgDirs == null) {
                return false;
            }
            for (File sgDir : sgDirs) {
                File[] sgFiles = sgDir.listFiles();
                if (sgFiles == null) continue;
                for (File sgFile : sgFiles) {
                    if (sgFile.delete()) continue;
                    String errorMessage = String.format("Cannot delete file %s in dir %s during metadata upgrade", sgFile.getName(), sgDir.getName());
                    logger.error(errorMessage);
                    throw new IOException(errorMessage);
                }
            }
            return false;
        }
        this.clearOldFiles();
        return true;
    }

    public void clearOldFiles() throws IOException {
        this.backupFile(this.mlogFile);
        this.backupFile(this.snapshotFile);
        this.backupFile(this.tagFile);
        this.backupFile(this.snapshotTmpFile);
    }

    private void backupFile(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        File backupFile = new File(file.getAbsolutePath() + ".bak");
        if (backupFile.exists()) {
            throw new IOException("The backup file " + backupFile.getAbsolutePath() + " has already existed, please remove it first");
        }
        if (!file.renameTo(backupFile)) {
            String errorMessage = String.format("Cannot backup file %s during metadata upgrade", file.getName());
            logger.error(errorMessage);
            throw new IOException(errorMessage);
        }
    }

    public void reloadMetadataFromSnapshot() throws IOException {
        if (!this.snapshotFile.exists()) {
            return;
        }
        Map<IStorageGroupMNode, List<IMeasurementMNode>> sgMeasurementMap = this.deserializeFrom(this.snapshotFile);
        Map tags = null;
        Map attributes = null;
        try (TagLogFile tagLogFile = new TagLogFile(this.schemaDirPath, "tlog.txt");){
            for (IStorageGroupMNode storageGroupMNode : sgMeasurementMap.keySet()) {
                try {
                    this.schemaProcessor.setStorageGroup(storageGroupMNode.getPartialPath());
                    for (IMeasurementMNode measurementMNode : sgMeasurementMap.get(storageGroupMNode)) {
                        Pair<Map<String, String>, Map<String, String>> tagAttributePair;
                        IMeasurementSchema schema = measurementMNode.getSchema();
                        if (measurementMNode.getOffset() != -1L && (tagAttributePair = tagLogFile.read(this.config.getTagAttributeTotalSize(), measurementMNode.getOffset())) != null) {
                            tags = (Map)tagAttributePair.left;
                            attributes = (Map)tagAttributePair.right;
                        }
                        CreateTimeSeriesPlan createTimeSeriesPlan = new CreateTimeSeriesPlan(measurementMNode.getPartialPath(), schema.getType(), schema.getEncodingType(), schema.getCompressor(), schema.getProps(), tags, attributes, measurementMNode.getAlias());
                        this.schemaProcessor.createTimeseries(createTimeSeriesPlan);
                    }
                }
                catch (MetadataException e) {
                    logger.error("Error occurred during recovering metadata from snapshot", (Throwable)e);
                }
            }
        }
    }

    private Map<IStorageGroupMNode, List<IMeasurementMNode>> deserializeFrom(File mtreeSnapshot) throws IOException {
        try (MLogReader mLogReader = new MLogReader(mtreeSnapshot);){
            HashMap<IStorageGroupMNode, List<IMeasurementMNode>> sgMeasurementMap = new HashMap<IStorageGroupMNode, List<IMeasurementMNode>>();
            this.deserializeFromReader(mLogReader, sgMeasurementMap);
            HashMap<IStorageGroupMNode, List<IMeasurementMNode>> hashMap = sgMeasurementMap;
            return hashMap;
        }
    }

    private void deserializeFromReader(MLogReader mLogReader, Map<IStorageGroupMNode, List<IMeasurementMNode>> sgMeasurementMap) throws IOException {
        ArrayDeque<IMNode> nodeStack = new ArrayDeque<IMNode>();
        IMNode node = null;
        LinkedList<IMeasurementMNode> measurementMNodeList = new LinkedList<IMeasurementMNode>();
        while (mLogReader.hasNext()) {
            PhysicalPlan plan = mLogReader.next();
            if (plan == null) continue;
            int childrenSize = 0;
            if (plan instanceof StorageGroupMNodePlan) {
                node = StorageGroupMNode.deserializeFrom((StorageGroupMNodePlan)plan);
                childrenSize = ((StorageGroupMNodePlan)plan).getChildSize();
                sgMeasurementMap.put(node.getAsStorageGroupMNode(), measurementMNodeList);
                measurementMNodeList = new LinkedList();
            } else if (plan instanceof MeasurementMNodePlan) {
                node = MeasurementMNode.deserializeFrom((MeasurementMNodePlan)plan);
                childrenSize = ((MeasurementMNodePlan)plan).getChildSize();
                measurementMNodeList.add(node.getAsMeasurementMNode());
            } else if (plan instanceof MNodePlan) {
                node = InternalMNode.deserializeFrom((MNodePlan)plan);
                childrenSize = ((MNodePlan)plan).getChildSize();
            }
            if (childrenSize != 0) {
                MNodeContainerMapImpl childrenMap = new MNodeContainerMapImpl();
                for (int i = 0; i < childrenSize; ++i) {
                    IMNode child = (IMNode)nodeStack.removeFirst();
                    childrenMap.put(child.getName(), child);
                    if (child.isMeasurement()) {
                        String alias;
                        if (!node.isEntity()) {
                            node = MNodeUtils.setToEntity(node);
                        }
                        if ((alias = child.getAsMeasurementMNode().getAlias()) != null) {
                            node.getAsEntityMNode().addAlias(alias, child.getAsMeasurementMNode());
                        }
                    }
                    child.setParent(node);
                }
                node.setChildren(childrenMap);
            }
            nodeStack.push(node);
        }
        if (node == null || !"root".equals(node.getName())) {
            logger.error("Snapshot file corrupted!");
            throw new IOException("Snapshot file corrupted!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void redoMLog() throws IOException {
        HashMap<String, Map<String, SetTemplatePlan>> setTemplatePlanAboveSG = new HashMap<String, Map<String, SetTemplatePlan>>();
        try (MLogReader mLogReader = new MLogReader(this.mlogFilePath);
             TagLogFile tagLogFile = new TagLogFile(this.schemaDirPath, "tlog.txt");){
            block19: while (mLogReader.hasNext()) {
                PhysicalPlan plan = mLogReader.next();
                try {
                    switch (plan.getOperatorType()) {
                        case CREATE_TIMESERIES: {
                            this.processCreateTimeseries((CreateTimeSeriesPlan)plan, this.schemaProcessor, tagLogFile);
                            continue block19;
                        }
                        case CHANGE_TAG_OFFSET: {
                            this.processChangeTagOffset((ChangeTagOffsetPlan)plan, this.schemaProcessor, tagLogFile);
                            continue block19;
                        }
                        case SET_STORAGE_GROUP: {
                            this.processSetStorageGroup((SetStorageGroupPlan)plan, this.schemaProcessor, setTemplatePlanAboveSG);
                            continue block19;
                        }
                        case SET_TEMPLATE: {
                            this.processSetTemplate((SetTemplatePlan)plan, this.schemaProcessor, setTemplatePlanAboveSG);
                            continue block19;
                        }
                        case UNSET_TEMPLATE: {
                            this.processUnSetTemplate((UnsetTemplatePlan)plan, this.schemaProcessor, setTemplatePlanAboveSG);
                            continue block19;
                        }
                    }
                    this.schemaProcessor.operation(plan);
                }
                catch (MetadataException e) {
                    logger.error("Error occurred during redo mlog: ", (Throwable)e);
                }
            }
            return;
        }
    }

    private void processCreateTimeseries(CreateTimeSeriesPlan createTimeSeriesPlan, LocalSchemaProcessor schemaProcessor, TagLogFile tagLogFile) throws MetadataException, IOException {
        long offset = createTimeSeriesPlan.getTagOffset();
        createTimeSeriesPlan.setTagOffset(-1L);
        createTimeSeriesPlan.setTags(null);
        createTimeSeriesPlan.setAttributes(null);
        schemaProcessor.operation(createTimeSeriesPlan);
        if (offset != -1L) {
            this.rewriteTagAndAttribute(createTimeSeriesPlan.getPath(), offset, schemaProcessor, tagLogFile);
        }
    }

    private void processChangeTagOffset(ChangeTagOffsetPlan changeTagOffsetPlan, LocalSchemaProcessor schemaProcessor, TagLogFile tagLogFile) throws MetadataException, IOException {
        this.rewriteTagAndAttribute(changeTagOffsetPlan.getPath(), changeTagOffsetPlan.getOffset(), schemaProcessor, tagLogFile);
    }

    private void rewriteTagAndAttribute(PartialPath path, long offset, LocalSchemaProcessor schemaProcessor, TagLogFile tagLogFile) throws IOException, MetadataException {
        Pair<Map<String, String>, Map<String, String>> pair = tagLogFile.read(this.config.getTagAttributeTotalSize(), offset);
        schemaProcessor.addTags((Map)pair.left, path);
        schemaProcessor.addAttributes((Map)pair.right, path);
    }

    private void processSetStorageGroup(SetStorageGroupPlan setStorageGroupPlan, LocalSchemaProcessor schemaProcessor, Map<String, Map<String, SetTemplatePlan>> setTemplatePlanAboveSG) throws IOException, MetadataException {
        schemaProcessor.operation(setStorageGroupPlan);
        String storageGroupPath = setStorageGroupPlan.getPath().getFullPath();
        for (Map<String, SetTemplatePlan> pathPlanMap : setTemplatePlanAboveSG.values()) {
            for (SetTemplatePlan setTemplatePlan : pathPlanMap.values()) {
                String templatePath = setTemplatePlan.getPrefixPath();
                if (!storageGroupPath.startsWith(templatePath)) continue;
                schemaProcessor.setSchemaTemplate(new SetTemplatePlan(setTemplatePlan.getTemplateName(), storageGroupPath));
            }
        }
    }

    private void processSetTemplate(SetTemplatePlan setTemplatePlan, LocalSchemaProcessor schemaProcessor, Map<String, Map<String, SetTemplatePlan>> setTemplatePlanAboveSG) throws MetadataException {
        PartialPath path = new PartialPath(setTemplatePlan.getPrefixPath());
        List<PartialPath> storageGroupPathList = schemaProcessor.getMatchedStorageGroups(path, true);
        if (storageGroupPathList.size() > 1 || !path.equals((Object)storageGroupPathList.get(0))) {
            String templateName = setTemplatePlan.getTemplateName();
            if (!setTemplatePlanAboveSG.containsKey(templateName)) {
                setTemplatePlanAboveSG.put(templateName, new HashMap());
            }
            setTemplatePlanAboveSG.get(templateName).put(setTemplatePlan.getPrefixPath(), setTemplatePlan);
        }
        for (PartialPath storageGroupPath : storageGroupPathList) {
            schemaProcessor.setSchemaTemplate(new SetTemplatePlan(setTemplatePlan.getTemplateName(), storageGroupPath.getFullPath()));
        }
    }

    private void processUnSetTemplate(UnsetTemplatePlan unsetTemplatePlan, LocalSchemaProcessor schemaProcessor, Map<String, Map<String, SetTemplatePlan>> setTemplatePlanAboveSG) throws MetadataException {
        PartialPath path = new PartialPath(unsetTemplatePlan.getPrefixPath());
        List<PartialPath> storageGroupPathList = schemaProcessor.getMatchedStorageGroups(path, true);
        if (storageGroupPathList.size() > 1 || !path.equals((Object)storageGroupPathList.get(0))) {
            setTemplatePlanAboveSG.get(unsetTemplatePlan.getTemplateName()).remove(unsetTemplatePlan.getPrefixPath());
        }
        for (PartialPath storageGroupPath : storageGroupPathList) {
            schemaProcessor.unsetSchemaTemplate(new UnsetTemplatePlan(storageGroupPath.getFullPath(), unsetTemplatePlan.getTemplateName()));
        }
    }
}

