/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation;

import org.apache.iotdb.db.mpp.aggregation.FirstValueAccumulator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.column.Column;

public class FirstValueDescAccumulator
extends FirstValueAccumulator {
    public FirstValueDescAccumulator(TSDataType seriesDataType) {
        super(seriesDataType);
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    protected int addIntInput(Column[] column, TimeRange timeRange) {
        for (int i = 0; i < column[0].getPositionCount(); ++i) {
            long curTime = column[0].getLong(i);
            if (curTime > timeRange.getMax() || curTime < timeRange.getMin()) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.updateIntFirstValue(column[1].getInt(i), curTime);
        }
        return column[0].getPositionCount();
    }

    @Override
    protected int addLongInput(Column[] column, TimeRange timeRange) {
        for (int i = 0; i < column[0].getPositionCount(); ++i) {
            long curTime = column[0].getLong(i);
            if (curTime > timeRange.getMax() || curTime < timeRange.getMin()) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.updateLongFirstValue(column[1].getLong(i), curTime);
        }
        return column[0].getPositionCount();
    }

    @Override
    protected int addFloatInput(Column[] column, TimeRange timeRange) {
        for (int i = 0; i < column[0].getPositionCount(); ++i) {
            long curTime = column[0].getLong(i);
            if (curTime > timeRange.getMax() || curTime < timeRange.getMin()) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.updateFloatFirstValue(column[1].getFloat(i), curTime);
        }
        return column[0].getPositionCount();
    }

    @Override
    protected int addDoubleInput(Column[] column, TimeRange timeRange) {
        for (int i = 0; i < column[0].getPositionCount(); ++i) {
            long curTime = column[0].getLong(i);
            if (curTime > timeRange.getMax() || curTime < timeRange.getMin()) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.updateDoubleFirstValue(column[1].getDouble(i), curTime);
        }
        return column[0].getPositionCount();
    }

    @Override
    protected int addBooleanInput(Column[] column, TimeRange timeRange) {
        for (int i = 0; i < column[0].getPositionCount(); ++i) {
            long curTime = column[0].getLong(i);
            if (curTime > timeRange.getMax() || curTime < timeRange.getMin()) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.updateBooleanFirstValue(column[1].getBoolean(i), curTime);
        }
        return column[0].getPositionCount();
    }

    @Override
    protected int addBinaryInput(Column[] column, TimeRange timeRange) {
        for (int i = 0; i < column[0].getPositionCount(); ++i) {
            long curTime = column[0].getLong(i);
            if (curTime > timeRange.getMax() || curTime < timeRange.getMin()) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.updateBinaryFirstValue(column[1].getBinary(i), curTime);
        }
        return column[0].getPositionCount();
    }
}

