/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation.slidingwindow;

import java.util.Comparator;
import java.util.List;
import org.apache.iotdb.db.mpp.aggregation.Accumulator;
import org.apache.iotdb.db.mpp.aggregation.slidingwindow.SlidingWindowAggregator;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.tsfile.read.common.block.column.Column;

public class MonotonicQueueSlidingWindowAggregator
extends SlidingWindowAggregator {
    private final Comparator<Column> comparator;

    public MonotonicQueueSlidingWindowAggregator(Accumulator accumulator, List<InputLocation[]> inputLocationList, AggregationStep step, Comparator<Column> comparator) {
        super(accumulator, inputLocationList, step);
        this.comparator = comparator;
    }

    @Override
    protected void evictingExpiredValue() {
        while (!this.deque.isEmpty() && !this.curTimeRange.contains(((SlidingWindowAggregator.PartialAggregationResult)this.deque.getFirst()).getTime())) {
            this.deque.removeFirst();
        }
        this.accumulator.reset();
        if (!this.deque.isEmpty()) {
            this.accumulator.addIntermediate(((SlidingWindowAggregator.PartialAggregationResult)this.deque.getFirst()).getPartialResult());
        }
    }

    @Override
    public void processPartialResult(SlidingWindowAggregator.PartialAggregationResult partialResult) {
        if (partialResult.isNull()) {
            return;
        }
        while (!this.deque.isEmpty() && this.comparator.compare(partialResult.getPartialResult()[0], ((SlidingWindowAggregator.PartialAggregationResult)this.deque.getLast()).getPartialResult()[0]) > 0) {
            this.deque.removeLast();
        }
        this.deque.addLast(partialResult);
        this.accumulator.addIntermediate(((SlidingWindowAggregator.PartialAggregationResult)this.deque.getFirst()).getPartialResult());
    }
}

