/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common.schematree.visitor;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.mpp.common.schematree.MeasurementSchemaInfo;
import org.apache.iotdb.db.mpp.common.schematree.node.SchemaMeasurementNode;
import org.apache.iotdb.db.mpp.common.schematree.node.SchemaNode;
import org.apache.iotdb.db.mpp.common.schematree.visitor.SchemaTreeVisitor;

public class SchemaTreeDeviceVisitor
extends SchemaTreeVisitor<DeviceSchemaInfo> {
    public SchemaTreeDeviceVisitor(SchemaNode root, PartialPath pathPattern, boolean isPrefixMatch) {
        super(root, pathPattern, 0, 0, isPrefixMatch);
    }

    protected boolean processInternalMatchedNode(SchemaNode node) {
        return true;
    }

    protected boolean processFullMatchedNode(SchemaNode node) {
        if (node.isEntity()) {
            this.nextMatchedNode = node;
        }
        return true;
    }

    protected DeviceSchemaInfo generateResult() {
        PartialPath path = new PartialPath(this.generateFullPathNodes((SchemaNode)this.nextMatchedNode));
        ArrayList<MeasurementSchemaInfo> measurementSchemaInfoList = new ArrayList<MeasurementSchemaInfo>();
        Iterator<SchemaNode> iterator = this.getChildrenIterator((SchemaNode)this.nextMatchedNode);
        while (iterator.hasNext()) {
            SchemaNode node = iterator.next();
            if (!node.isMeasurement()) continue;
            SchemaMeasurementNode measurementNode = node.getAsMeasurementNode();
            measurementSchemaInfoList.add(new MeasurementSchemaInfo(measurementNode.getName(), measurementNode.getSchema(), measurementNode.getAlias()));
        }
        return new DeviceSchemaInfo(path, ((SchemaNode)this.nextMatchedNode).getAsEntityNode().isAligned(), measurementSchemaInfoList);
    }
}

