/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common.schematree.visitor;

import java.util.regex.Pattern;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.tree.AbstractTreeVisitor;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.common.schematree.node.SchemaMeasurementNode;
import org.apache.iotdb.db.mpp.common.schematree.node.SchemaNode;
import org.apache.iotdb.db.mpp.common.schematree.visitor.SchemaTreeVisitor;

public class SchemaTreeMeasurementVisitor
extends SchemaTreeVisitor<MeasurementPath> {
    public SchemaTreeMeasurementVisitor(SchemaNode root, PartialPath pathPattern, int slimit, int soffset, boolean isPrefixMatch) {
        super(root, pathPattern, slimit, soffset, isPrefixMatch);
    }

    protected boolean checkOneLevelWildcardMatch(String regex, SchemaNode node) {
        if (!node.isMeasurement()) {
            return Pattern.matches(regex, node.getName());
        }
        SchemaMeasurementNode measurementNode = node.getAsMeasurementNode();
        return Pattern.matches(regex, measurementNode.getName()) || Pattern.matches(regex, measurementNode.getAlias());
    }

    protected boolean checkNameMatch(String targetName, SchemaNode node) {
        if (node.isMeasurement()) {
            return targetName.equals(node.getName()) || targetName.equals(node.getAsMeasurementNode().getAlias());
        }
        return targetName.equals(node.getName());
    }

    protected boolean processInternalMatchedNode(SchemaNode node) {
        return true;
    }

    protected boolean processFullMatchedNode(SchemaNode node) {
        if (node.isMeasurement()) {
            this.nextMatchedNode = node;
            return false;
        }
        return true;
    }

    protected MeasurementPath generateResult() {
        MeasurementPath result = new MeasurementPath(this.generateFullPathNodes((SchemaNode)this.nextMatchedNode), ((SchemaNode)this.nextMatchedNode).getAsMeasurementNode().getSchema());
        result.setUnderAlignedEntity(((SchemaNode)((AbstractTreeVisitor.AncestorStackEntry)this.ancestorStack.peek()).getNode()).getAsEntityNode().isAligned());
        String alias = ((SchemaNode)this.nextMatchedNode).getAsMeasurementNode().getAlias();
        if (this.nodes[this.nodes.length - 1].equals(alias)) {
            result.setMeasurementAlias(alias);
        }
        return result;
    }
}

