/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.source;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.universal.DescPriorityMergeReader;
import org.apache.iotdb.db.query.reader.universal.PriorityMergeReader;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.basic.UnaryFilter;
import org.apache.iotdb.tsfile.read.reader.IAlignedPageReader;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class SeriesScanUtil {
    private final FragmentInstanceContext context;
    private final PartialPath seriesPath;
    protected final Set<String> allSensors;
    protected final TSDataType dataType;
    private TimeOrderUtils orderUtils;
    private Filter timeFilter;
    private Filter valueFilter;
    private QueryDataSource dataSource;
    protected int curSeqFileIndex;
    protected int curUnseqFileIndex;
    protected ITimeSeriesMetadata firstTimeSeriesMetadata;
    protected final List<ITimeSeriesMetadata> seqTimeSeriesMetadata = new LinkedList<ITimeSeriesMetadata>();
    protected final PriorityQueue<ITimeSeriesMetadata> unSeqTimeSeriesMetadata;
    protected IChunkMetadata firstChunkMetadata;
    protected final PriorityQueue<IChunkMetadata> cachedChunkMetadata;
    protected VersionPageReader firstPageReader;
    protected final List<VersionPageReader> seqPageReaders = new LinkedList<VersionPageReader>();
    protected final PriorityQueue<VersionPageReader> unSeqPageReaders;
    protected final PriorityMergeReader mergeReader;
    protected boolean hasCachedNextOverlappedPage;
    protected TsBlock cachedTsBlock;

    public SeriesScanUtil(PartialPath seriesPath, Set<String> allSensors, TSDataType dataType, FragmentInstanceContext context, Filter timeFilter, Filter valueFilter, boolean ascending) {
        this.seriesPath = IDTable.translateQueryPath(seriesPath);
        this.allSensors = allSensors;
        this.dataType = dataType;
        this.context = context;
        this.timeFilter = timeFilter;
        this.valueFilter = valueFilter;
        if (ascending) {
            this.orderUtils = new AscTimeOrderUtils();
            this.mergeReader = this.getPriorityMergeReader();
        } else {
            this.orderUtils = new DescTimeOrderUtils();
            this.mergeReader = this.getDescPriorityMergeReader();
        }
        this.curUnseqFileIndex = 0;
        this.unSeqTimeSeriesMetadata = new PriorityQueue<ITimeSeriesMetadata>(this.orderUtils.comparingLong(timeSeriesMetadata -> this.orderUtils.getOrderTime((Statistics<? extends Object>)timeSeriesMetadata.getStatistics())));
        this.cachedChunkMetadata = new PriorityQueue<IChunkMetadata>(this.orderUtils.comparingLong(chunkMetadata -> this.orderUtils.getOrderTime((Statistics<? extends Object>)chunkMetadata.getStatistics())));
        this.unSeqPageReaders = new PriorityQueue<VersionPageReader>(this.orderUtils.comparingLong(versionPageReader -> this.orderUtils.getOrderTime((Statistics<? extends Object>)versionPageReader.getStatistics())));
    }

    public void initQueryDataSource(QueryDataSource dataSource) {
        QueryUtils.fillOrderIndexes(dataSource, this.seriesPath.getDevice(), this.orderUtils.getAscending());
        this.dataSource = dataSource;
        this.timeFilter = dataSource.updateFilterUsingTTL(this.timeFilter);
        if (this.valueFilter != null) {
            this.valueFilter = dataSource.updateFilterUsingTTL(this.valueFilter);
        }
        this.orderUtils.setCurSeqFileIndex(dataSource);
    }

    public void initQueryDataSource(List<TsFileResource> seqFileResource, List<TsFileResource> unseqFileResource) {
        this.dataSource = new QueryDataSource(seqFileResource, unseqFileResource);
        QueryUtils.fillOrderIndexes(this.dataSource, this.seriesPath.getDevice(), this.orderUtils.getAscending());
        this.orderUtils.setCurSeqFileIndex(this.dataSource);
    }

    protected PriorityMergeReader getPriorityMergeReader() {
        return new PriorityMergeReader();
    }

    protected DescPriorityMergeReader getDescPriorityMergeReader() {
        return new DescPriorityMergeReader();
    }

    public boolean isEmpty() throws IOException {
        return !this.hasNextPage() && !this.hasNextChunk() && !this.hasNextFile();
    }

    public boolean hasNextFile() throws IOException {
        if (!this.unSeqPageReaders.isEmpty() || this.firstPageReader != null || this.mergeReader.hasNextTimeValuePair()) {
            throw new IOException("all cached pages should be consumed first unSeqPageReaders.isEmpty() is " + this.unSeqPageReaders.isEmpty() + " firstPageReader != null is " + (this.firstPageReader != null) + " mergeReader.hasNextTimeValuePair() = " + this.mergeReader.hasNextTimeValuePair());
        }
        if (this.firstChunkMetadata != null || !this.cachedChunkMetadata.isEmpty()) {
            throw new IOException("all cached chunks should be consumed first");
        }
        if (this.firstTimeSeriesMetadata != null) {
            return true;
        }
        while (this.firstTimeSeriesMetadata == null && (this.orderUtils.hasNextSeqResource() || this.orderUtils.hasNextUnseqResource() || !this.seqTimeSeriesMetadata.isEmpty() || !this.unSeqTimeSeriesMetadata.isEmpty())) {
            this.tryToUnpackAllOverlappedFilesToTimeSeriesMetadata();
        }
        return this.firstTimeSeriesMetadata != null;
    }

    boolean isFileOverlapped() throws IOException {
        if (this.firstTimeSeriesMetadata == null) {
            throw new IOException("no first file");
        }
        Statistics fileStatistics = this.firstTimeSeriesMetadata.getStatistics();
        return !this.seqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)fileStatistics, (Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics()) || !this.unSeqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)fileStatistics, (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics());
    }

    Statistics currentFileStatistics() {
        return this.firstTimeSeriesMetadata.getStatistics();
    }

    protected Statistics currentFileStatistics(int index) throws IOException {
        Preconditions.checkArgument((index == 0 ? 1 : 0) != 0, (Object)"Only one sensor in non-aligned SeriesScanUtil.");
        return this.currentFileStatistics();
    }

    protected Statistics currentFileTimeStatistics() throws IOException {
        return this.currentFileStatistics();
    }

    boolean currentFileModified() throws IOException {
        if (this.firstTimeSeriesMetadata == null) {
            throw new IOException("no first file");
        }
        return this.firstTimeSeriesMetadata.isModified();
    }

    void skipCurrentFile() {
        this.firstTimeSeriesMetadata = null;
    }

    public boolean hasNextChunk() throws IOException {
        if (!this.unSeqPageReaders.isEmpty() || this.firstPageReader != null || this.mergeReader.hasNextTimeValuePair()) {
            throw new IOException("all cached pages should be consumed first unSeqPageReaders.isEmpty() is " + this.unSeqPageReaders.isEmpty() + " firstPageReader != null is " + (this.firstPageReader != null) + " mergeReader.hasNextTimeValuePair() = " + this.mergeReader.hasNextTimeValuePair());
        }
        if (this.firstChunkMetadata != null) {
            return true;
        }
        if (this.firstTimeSeriesMetadata == null && this.cachedChunkMetadata.isEmpty()) {
            return false;
        }
        while (this.firstChunkMetadata == null && (!this.cachedChunkMetadata.isEmpty() || this.hasNextFile())) {
            this.initFirstChunkMetadata();
        }
        return this.firstChunkMetadata != null;
    }

    private void initFirstChunkMetadata() throws IOException {
        if (this.firstTimeSeriesMetadata != null) {
            this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstTimeSeriesMetadata.getStatistics()));
            this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstTimeSeriesMetadata.getStatistics()), true);
        } else {
            while (!this.cachedChunkMetadata.isEmpty()) {
                this.firstChunkMetadata = this.cachedChunkMetadata.peek();
                this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstChunkMetadata.getStatistics()));
                this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstChunkMetadata.getStatistics()), false);
                if (!this.firstChunkMetadata.equals(this.cachedChunkMetadata.peek())) continue;
                this.firstChunkMetadata = this.cachedChunkMetadata.poll();
                break;
            }
        }
        if (!(this.valueFilter == null || this.firstChunkMetadata == null || this.isChunkOverlapped() || this.firstChunkMetadata.isModified() || this.valueFilter.satisfy(this.firstChunkMetadata.getStatistics()))) {
            this.skipCurrentChunk();
        }
    }

    private void unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(long endpointTime, boolean init) throws IOException {
        while (!this.seqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics())) {
            this.unpackOneTimeSeriesMetadata(this.seqTimeSeriesMetadata.remove(0));
        }
        while (!this.unSeqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics())) {
            this.unpackOneTimeSeriesMetadata(this.unSeqTimeSeriesMetadata.poll());
        }
        if (this.firstTimeSeriesMetadata != null && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.firstTimeSeriesMetadata.getStatistics())) {
            this.unpackOneTimeSeriesMetadata(this.firstTimeSeriesMetadata);
            this.firstTimeSeriesMetadata = null;
        }
        if (init && this.firstChunkMetadata == null && !this.cachedChunkMetadata.isEmpty()) {
            this.firstChunkMetadata = this.cachedChunkMetadata.poll();
        }
    }

    protected void unpackOneTimeSeriesMetadata(ITimeSeriesMetadata timeSeriesMetadata) throws IOException {
        List<IChunkMetadata> chunkMetadataList = FileLoaderUtils.loadChunkMetadataList(timeSeriesMetadata);
        chunkMetadataList.forEach(chunkMetadata -> chunkMetadata.setSeq(timeSeriesMetadata.isSeq()));
        this.cachedChunkMetadata.addAll(chunkMetadataList);
    }

    boolean isChunkOverlapped() throws IOException {
        if (this.firstChunkMetadata == null) {
            throw new IOException("no first chunk");
        }
        Statistics chunkStatistics = this.firstChunkMetadata.getStatistics();
        return !this.cachedChunkMetadata.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)chunkStatistics, (Statistics<? extends Object>)this.cachedChunkMetadata.peek().getStatistics());
    }

    Statistics currentChunkStatistics() {
        return this.firstChunkMetadata.getStatistics();
    }

    protected Statistics currentChunkStatistics(int index) throws IOException {
        Preconditions.checkArgument((index == 0 ? 1 : 0) != 0, (Object)"Only one sensor in non-aligned SeriesScanUtil.");
        return this.currentChunkStatistics();
    }

    protected Statistics currentChunkTimeStatistics() throws IOException {
        return this.currentChunkStatistics();
    }

    boolean currentChunkModified() throws IOException {
        if (this.firstChunkMetadata == null) {
            throw new IOException("no first chunk");
        }
        return this.firstChunkMetadata.isModified();
    }

    void skipCurrentChunk() {
        this.firstChunkMetadata = null;
    }

    public boolean hasNextPage() throws IOException {
        if (this.hasCachedNextOverlappedPage) {
            return true;
        }
        if ((this.mergeReader.hasNextTimeValuePair() || this.firstPageOverlapped()) && this.hasNextOverlappedPage()) {
            this.cachedTsBlock = this.nextOverlappedPage();
            if (this.cachedTsBlock != null && !this.cachedTsBlock.isEmpty()) {
                this.hasCachedNextOverlappedPage = true;
                return true;
            }
        }
        if (this.firstPageReader != null) {
            return true;
        }
        if (this.firstChunkMetadata != null) {
            this.unpackAllOverlappedChunkMetadataToPageReaders(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstChunkMetadata.getStatistics()), true);
        } else {
            this.initFirstPageReader();
        }
        if (this.isExistOverlappedPage()) {
            return true;
        }
        while (!(this.firstPageReader != null || this.seqPageReaders.isEmpty() && this.unSeqPageReaders.isEmpty())) {
            this.initFirstPageReader();
            if (!this.isExistOverlappedPage()) continue;
            return true;
        }
        return this.firstPageReader != null;
    }

    private boolean isExistOverlappedPage() throws IOException {
        if (this.firstPageOverlapped() && this.hasNextOverlappedPage()) {
            this.cachedTsBlock = this.nextOverlappedPage();
            if (this.cachedTsBlock != null && !this.cachedTsBlock.isEmpty()) {
                this.hasCachedNextOverlappedPage = true;
                return true;
            }
        }
        return false;
    }

    private boolean firstPageOverlapped() throws IOException {
        if (this.firstPageReader == null) {
            return false;
        }
        long endpointTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstPageReader.getStatistics());
        this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(endpointTime);
        this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(endpointTime, false);
        this.unpackAllOverlappedChunkMetadataToPageReaders(endpointTime, false);
        return !this.seqPageReaders.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)this.firstPageReader.getStatistics(), (Statistics<? extends Object>)this.seqPageReaders.get(0).getStatistics()) || !this.unSeqPageReaders.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)this.firstPageReader.getStatistics(), (Statistics<? extends Object>)this.unSeqPageReaders.peek().getStatistics()) || this.mergeReader.hasNextTimeValuePair() && this.orderUtils.isOverlapped(this.mergeReader.currentTimeValuePair().getTimestamp(), (Statistics<? extends Object>)this.firstPageReader.getStatistics());
    }

    private void unpackAllOverlappedChunkMetadataToPageReaders(long endpointTime, boolean init) throws IOException {
        if (this.firstChunkMetadata != null && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.firstChunkMetadata.getStatistics())) {
            this.unpackOneChunkMetaData(this.firstChunkMetadata);
            this.firstChunkMetadata = null;
        }
        boolean hasMeetSeq = false;
        while (!(this.cachedChunkMetadata.isEmpty() || !this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.cachedChunkMetadata.peek().getStatistics()) || this.cachedChunkMetadata.peek().isSeq() && hasMeetSeq)) {
            if (this.cachedChunkMetadata.peek().isSeq()) {
                hasMeetSeq = true;
            }
            this.unpackOneChunkMetaData(this.cachedChunkMetadata.poll());
        }
        if (!(!init || this.firstPageReader != null || this.seqPageReaders.isEmpty() && this.unSeqPageReaders.isEmpty())) {
            this.initFirstPageReader();
        }
    }

    private void unpackOneChunkMetaData(IChunkMetadata chunkMetaData) throws IOException {
        List<IPageReader> pageReaderList = FileLoaderUtils.loadPageReaderList(chunkMetaData, this.timeFilter);
        pageReaderList.forEach(p -> p.initTsBlockBuilder(this.getTsDataTypeList()));
        if (chunkMetaData.isSeq()) {
            if (this.orderUtils.getAscending()) {
                for (IPageReader iPageReader : pageReaderList) {
                    this.seqPageReaders.add(new VersionPageReader(chunkMetaData.getVersion(), chunkMetaData.getOffsetOfChunkHeader(), iPageReader, true));
                }
            } else {
                for (int i = pageReaderList.size() - 1; i >= 0; --i) {
                    this.seqPageReaders.add(new VersionPageReader(chunkMetaData.getVersion(), chunkMetaData.getOffsetOfChunkHeader(), pageReaderList.get(i), true));
                }
            }
        } else {
            pageReaderList.forEach(pageReader -> this.unSeqPageReaders.add(new VersionPageReader(chunkMetaData.getVersion(), chunkMetaData.getOffsetOfChunkHeader(), (IPageReader)pageReader, false)));
        }
    }

    boolean isPageOverlapped() throws IOException {
        if (this.hasCachedNextOverlappedPage) {
            return true;
        }
        if (this.mergeReader.hasNextTimeValuePair() && (this.orderUtils.getAscending() && this.mergeReader.currentTimeValuePair().getTimestamp() <= this.firstPageReader.getStatistics().getEndTime() || !this.orderUtils.getAscending() && this.mergeReader.currentTimeValuePair().getTimestamp() >= this.firstPageReader.getStatistics().getStartTime())) {
            throw new IOException("overlapped data should be consumed first");
        }
        Statistics firstPageStatistics = this.firstPageReader.getStatistics();
        return !this.unSeqPageReaders.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)firstPageStatistics, (Statistics<? extends Object>)this.unSeqPageReaders.peek().getStatistics());
    }

    Statistics currentPageStatistics() {
        if (this.firstPageReader == null) {
            return null;
        }
        return this.firstPageReader.getStatistics();
    }

    protected Statistics currentPageStatistics(int index) throws IOException {
        Preconditions.checkArgument((index == 0 ? 1 : 0) != 0, (Object)"Only one sensor in non-aligned SeriesScanUtil.");
        return this.currentPageStatistics();
    }

    protected Statistics currentPageTimeStatistics() throws IOException {
        return this.currentPageStatistics();
    }

    boolean currentPageModified() throws IOException {
        if (this.firstPageReader == null) {
            throw new IOException("no first page");
        }
        return this.firstPageReader.isModified();
    }

    void skipCurrentPage() {
        this.firstPageReader = null;
    }

    public TsBlock nextPage() throws IOException {
        if (this.hasCachedNextOverlappedPage) {
            this.hasCachedNextOverlappedPage = false;
            TsBlock res = this.cachedTsBlock;
            this.cachedTsBlock = null;
            return res;
        }
        if (this.valueFilter != null) {
            this.firstPageReader.setFilter(this.valueFilter);
        }
        TsBlock tsBlock = this.firstPageReader.getAllSatisfiedPageData(this.orderUtils.getAscending());
        this.firstPageReader = null;
        return tsBlock;
    }

    private boolean hasNextOverlappedPage() throws IOException {
        if (this.hasCachedNextOverlappedPage) {
            return true;
        }
        this.tryToPutAllDirectlyOverlappedUnseqPageReadersIntoMergeReader();
        while (this.mergeReader.hasNextTimeValuePair()) {
            TsBlockBuilder builder = new TsBlockBuilder(this.getTsDataTypeList());
            TimeColumnBuilder timeBuilder = builder.getTimeColumnBuilder();
            long currentPageEndPointTime = this.mergeReader.getCurrentReadStopTime();
            while (this.mergeReader.hasNextTimeValuePair()) {
                TimeValuePair timeValuePair = this.mergeReader.currentTimeValuePair();
                if (this.orderUtils.isExcessEndpoint(timeValuePair.getTimestamp(), currentPageEndPointTime)) {
                    if (!builder.isEmpty() || this.firstPageReader != null || !this.seqPageReaders.isEmpty()) break;
                    currentPageEndPointTime = this.mergeReader.getCurrentReadStopTime();
                }
                this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(timeValuePair.getTimestamp());
                this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(timeValuePair.getTimestamp(), false);
                this.unpackAllOverlappedChunkMetadataToPageReaders(timeValuePair.getTimestamp(), false);
                this.unpackAllOverlappedUnseqPageReadersToMergeReader(timeValuePair.getTimestamp());
                timeValuePair = this.mergeReader.currentTimeValuePair();
                if (this.firstPageReader != null) {
                    if (this.orderUtils.getAscending() && timeValuePair.getTimestamp() > this.firstPageReader.getStatistics().getEndTime() || !this.orderUtils.getAscending() && timeValuePair.getTimestamp() < this.firstPageReader.getStatistics().getStartTime()) {
                        this.hasCachedNextOverlappedPage = !builder.isEmpty();
                        this.cachedTsBlock = builder.build();
                        return this.hasCachedNextOverlappedPage;
                    }
                    if (this.orderUtils.isOverlapped(timeValuePair.getTimestamp(), (Statistics<? extends Object>)this.firstPageReader.getStatistics())) {
                        this.mergeReader.addReader(this.getPointReader(this.firstPageReader.getAllSatisfiedPageData(this.orderUtils.getAscending())), this.firstPageReader.version, this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstPageReader.getStatistics()), this.context);
                        currentPageEndPointTime = this.updateEndPointTime(currentPageEndPointTime, this.firstPageReader);
                        this.firstPageReader = null;
                    }
                }
                if (!this.seqPageReaders.isEmpty()) {
                    if (this.orderUtils.getAscending() && timeValuePair.getTimestamp() > this.seqPageReaders.get(0).getStatistics().getEndTime() || !this.orderUtils.getAscending() && timeValuePair.getTimestamp() < this.seqPageReaders.get(0).getStatistics().getStartTime()) {
                        this.hasCachedNextOverlappedPage = !builder.isEmpty();
                        this.cachedTsBlock = builder.build();
                        return this.hasCachedNextOverlappedPage;
                    }
                    if (this.orderUtils.isOverlapped(timeValuePair.getTimestamp(), (Statistics<? extends Object>)this.seqPageReaders.get(0).getStatistics())) {
                        VersionPageReader pageReader = this.seqPageReaders.remove(0);
                        this.mergeReader.addReader(this.getPointReader(pageReader.getAllSatisfiedPageData(this.orderUtils.getAscending())), pageReader.version, this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)pageReader.getStatistics()), this.context);
                        currentPageEndPointTime = this.updateEndPointTime(currentPageEndPointTime, pageReader);
                    }
                }
                timeValuePair = this.mergeReader.nextTimeValuePair();
                Object valueForFilter = timeValuePair.getValue().getValue();
                if (timeValuePair.getValue().getDataType() == TSDataType.VECTOR) {
                    for (TsPrimitiveType tsPrimitiveType : timeValuePair.getValue().getVector()) {
                        if (tsPrimitiveType == null) continue;
                        valueForFilter = tsPrimitiveType.getValue();
                        break;
                    }
                }
                if (this.valueFilter != null && !this.valueFilter.satisfy(timeValuePair.getTimestamp(), valueForFilter)) continue;
                timeBuilder.writeLong(timeValuePair.getTimestamp());
                switch (this.dataType) {
                    case BOOLEAN: {
                        builder.getColumnBuilder(0).writeBoolean(timeValuePair.getValue().getBoolean());
                        break;
                    }
                    case INT32: {
                        builder.getColumnBuilder(0).writeInt(timeValuePair.getValue().getInt());
                        break;
                    }
                    case INT64: {
                        builder.getColumnBuilder(0).writeLong(timeValuePair.getValue().getLong());
                        break;
                    }
                    case FLOAT: {
                        builder.getColumnBuilder(0).writeFloat(timeValuePair.getValue().getFloat());
                        break;
                    }
                    case DOUBLE: {
                        builder.getColumnBuilder(0).writeDouble(timeValuePair.getValue().getDouble());
                        break;
                    }
                    case TEXT: {
                        builder.getColumnBuilder(0).writeBinary(timeValuePair.getValue().getBinary());
                        break;
                    }
                    case VECTOR: {
                        TsPrimitiveType[] values = timeValuePair.getValue().getVector();
                        for (int i = 0; i < values.length; ++i) {
                            if (values[i] == null) {
                                builder.getColumnBuilder(i).appendNull();
                                continue;
                            }
                            builder.getColumnBuilder(i).writeTsPrimitiveType(values[i]);
                        }
                        break;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.valueOf(this.dataType));
                    }
                }
                builder.declarePosition();
            }
            this.hasCachedNextOverlappedPage = !builder.isEmpty();
            this.cachedTsBlock = builder.build();
            if (this.hasCachedNextOverlappedPage) {
                return true;
            }
            if (!this.mergeReader.hasNextTimeValuePair()) continue;
            return false;
        }
        return false;
    }

    private long updateEndPointTime(long currentPageEndPointTime, VersionPageReader pageReader) {
        if (this.orderUtils.getAscending()) {
            return Math.min(currentPageEndPointTime, pageReader.getStatistics().getEndTime());
        }
        return Math.max(currentPageEndPointTime, pageReader.getStatistics().getStartTime());
    }

    private void tryToPutAllDirectlyOverlappedUnseqPageReadersIntoMergeReader() throws IOException {
        if (this.firstPageReader == null && this.unSeqPageReaders.isEmpty() && this.seqPageReaders.isEmpty()) {
            return;
        }
        if (this.firstPageReader == null) {
            this.initFirstPageReader();
        }
        long currentPageEndpointTime = this.mergeReader.hasNextTimeValuePair() ? this.mergeReader.getCurrentReadStopTime() : this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstPageReader.getStatistics());
        this.unpackAllOverlappedUnseqPageReadersToMergeReader(currentPageEndpointTime);
    }

    private void initFirstPageReader() throws IOException {
        while (this.firstPageReader == null) {
            VersionPageReader firstPageReader = this.getFirstPageReaderFromCachedReaders();
            if (firstPageReader != null) {
                long overlapCheckTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)firstPageReader.getStatistics());
                this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(overlapCheckTime);
                this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(overlapCheckTime, false);
                this.unpackAllOverlappedChunkMetadataToPageReaders(overlapCheckTime, false);
                if (!firstPageReader.equals(this.getFirstPageReaderFromCachedReaders())) continue;
                this.firstPageReader = firstPageReader;
                if (!this.seqPageReaders.isEmpty() && firstPageReader.equals(this.seqPageReaders.get(0))) {
                    this.seqPageReaders.remove(0);
                    break;
                }
                if (this.unSeqPageReaders.isEmpty() || !firstPageReader.equals(this.unSeqPageReaders.peek())) continue;
                this.unSeqPageReaders.poll();
                break;
            }
            return;
        }
    }

    private VersionPageReader getFirstPageReaderFromCachedReaders() {
        VersionPageReader firstPageReader = null;
        if (!this.seqPageReaders.isEmpty() && !this.unSeqPageReaders.isEmpty()) {
            firstPageReader = this.orderUtils.isTakeSeqAsFirst((Statistics<? extends Object>)this.seqPageReaders.get(0).getStatistics(), (Statistics<? extends Object>)this.unSeqPageReaders.peek().getStatistics()) ? this.seqPageReaders.get(0) : this.unSeqPageReaders.peek();
        } else if (!this.seqPageReaders.isEmpty()) {
            firstPageReader = this.seqPageReaders.get(0);
        } else if (!this.unSeqPageReaders.isEmpty()) {
            firstPageReader = this.unSeqPageReaders.peek();
        }
        return firstPageReader;
    }

    private void unpackAllOverlappedUnseqPageReadersToMergeReader(long endpointTime) throws IOException {
        while (!this.unSeqPageReaders.isEmpty() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.unSeqPageReaders.peek().data.getStatistics())) {
            this.putPageReaderToMergeReader(this.unSeqPageReaders.poll());
        }
        if (this.firstPageReader != null && !this.firstPageReader.isSeq() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.firstPageReader.getStatistics())) {
            this.putPageReaderToMergeReader(this.firstPageReader);
            this.firstPageReader = null;
        }
    }

    private void putPageReaderToMergeReader(VersionPageReader pageReader) throws IOException {
        this.mergeReader.addReader(this.getPointReader(pageReader.getAllSatisfiedPageData(this.orderUtils.getAscending())), pageReader.version, this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)pageReader.getStatistics()), this.context);
    }

    private TsBlock nextOverlappedPage() throws IOException {
        if (this.hasCachedNextOverlappedPage || this.hasNextOverlappedPage()) {
            this.hasCachedNextOverlappedPage = false;
            return this.cachedTsBlock;
        }
        throw new IOException("No more batch data");
    }

    private LinkedList<TsFileResource> sortUnSeqFileResources(List<TsFileResource> tsFileResources) {
        return tsFileResources.stream().sorted(this.orderUtils.comparingLong(tsFileResource -> this.orderUtils.getOrderTime((TsFileResource)tsFileResource))).collect(Collectors.toCollection(LinkedList::new));
    }

    protected void tryToUnpackAllOverlappedFilesToTimeSeriesMetadata() throws IOException {
        while (this.seqTimeSeriesMetadata.isEmpty() && this.orderUtils.hasNextSeqResource()) {
            this.unpackSeqTsFileResource();
        }
        while (this.unSeqTimeSeriesMetadata.isEmpty() && this.orderUtils.hasNextUnseqResource()) {
            this.unpackUnseqTsFileResource();
        }
        long endTime = -1L;
        if (!this.seqTimeSeriesMetadata.isEmpty() && this.unSeqTimeSeriesMetadata.isEmpty()) {
            endTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics());
        } else if (this.seqTimeSeriesMetadata.isEmpty() && !this.unSeqTimeSeriesMetadata.isEmpty()) {
            endTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics());
        } else if (!this.seqTimeSeriesMetadata.isEmpty()) {
            endTime = this.orderUtils.getCurrentEndPoint((Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics(), (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics());
        }
        if (endTime != -1L) {
            this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(endTime);
        }
        if (!this.seqTimeSeriesMetadata.isEmpty() && this.unSeqTimeSeriesMetadata.isEmpty()) {
            this.firstTimeSeriesMetadata = this.seqTimeSeriesMetadata.remove(0);
        } else if (this.seqTimeSeriesMetadata.isEmpty() && !this.unSeqTimeSeriesMetadata.isEmpty()) {
            this.firstTimeSeriesMetadata = this.unSeqTimeSeriesMetadata.poll();
        } else if (!this.seqTimeSeriesMetadata.isEmpty()) {
            this.firstTimeSeriesMetadata = this.orderUtils.isTakeSeqAsFirst((Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics(), (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics()) ? this.seqTimeSeriesMetadata.remove(0) : this.unSeqTimeSeriesMetadata.poll();
        }
        if (!(this.valueFilter == null || this.firstTimeSeriesMetadata == null || this.isFileOverlapped() || this.firstTimeSeriesMetadata.isModified() || this.valueFilter.satisfy(this.firstTimeSeriesMetadata.getStatistics()))) {
            this.firstTimeSeriesMetadata = null;
        }
    }

    protected void unpackAllOverlappedTsFilesToTimeSeriesMetadata(long endpointTime) throws IOException {
        while (this.orderUtils.hasNextUnseqResource() && this.orderUtils.isOverlapped(endpointTime, this.orderUtils.getNextUnseqFileResource(false))) {
            this.unpackUnseqTsFileResource();
        }
        while (this.orderUtils.hasNextSeqResource() && this.orderUtils.isOverlapped(endpointTime, this.orderUtils.getNextSeqFileResource(false))) {
            this.unpackSeqTsFileResource();
        }
    }

    private void unpackSeqTsFileResource() throws IOException {
        ITimeSeriesMetadata timeseriesMetadata = this.loadTimeSeriesMetadata(this.orderUtils.getNextSeqFileResource(true), this.seriesPath, this.context, this.getAnyFilter(), this.allSensors);
        if (timeseriesMetadata != null) {
            timeseriesMetadata.setSeq(true);
            this.seqTimeSeriesMetadata.add(timeseriesMetadata);
        }
    }

    private void unpackUnseqTsFileResource() throws IOException {
        ITimeSeriesMetadata timeseriesMetadata = this.loadTimeSeriesMetadata(this.orderUtils.getNextUnseqFileResource(true), this.seriesPath, this.context, this.getAnyFilter(), this.allSensors);
        if (timeseriesMetadata != null) {
            timeseriesMetadata.setModified(true);
            timeseriesMetadata.setSeq(false);
            this.unSeqTimeSeriesMetadata.add(timeseriesMetadata);
        }
    }

    protected ITimeSeriesMetadata loadTimeSeriesMetadata(TsFileResource resource, PartialPath seriesPath, QueryContext context, Filter filter, Set<String> allSensors) throws IOException {
        return FileLoaderUtils.loadTimeSeriesMetadata(resource, seriesPath, context, filter, allSensors);
    }

    protected List<TSDataType> getTsDataTypeList() {
        return Collections.singletonList(this.dataType);
    }

    protected IPointReader getPointReader(TsBlock tsBlock) {
        return tsBlock.getTsBlockSingleColumnIterator();
    }

    private Filter getAnyFilter() {
        return this.timeFilter != null ? this.timeFilter : this.valueFilter;
    }

    void setTimeFilter(long timestamp) {
        ((UnaryFilter)this.timeFilter).setValue((Comparable)Long.valueOf(timestamp));
    }

    Filter getTimeFilter() {
        return this.timeFilter;
    }

    public TimeOrderUtils getOrderUtils() {
        return this.orderUtils;
    }

    class AscTimeOrderUtils
    implements TimeOrderUtils {
        AscTimeOrderUtils() {
        }

        public long getOrderTime(Statistics statistics) {
            return statistics.getStartTime();
        }

        @Override
        public long getOrderTime(TsFileResource fileResource) {
            return fileResource.getStartTime(SeriesScanUtil.this.seriesPath.getDevice());
        }

        public long getOverlapCheckTime(Statistics range) {
            return range.getEndTime();
        }

        public boolean isOverlapped(Statistics left, Statistics right) {
            return left.getEndTime() >= right.getStartTime();
        }

        public boolean isOverlapped(long time, Statistics right) {
            return time >= right.getStartTime();
        }

        @Override
        public boolean isOverlapped(long time, TsFileResource right) {
            return time >= right.getStartTime(SeriesScanUtil.this.seriesPath.getDevice());
        }

        @Override
        public <T> Comparator<T> comparingLong(ToLongFunction<? super T> keyExtractor) {
            Objects.requireNonNull(keyExtractor);
            return (Comparator & Serializable)(c1, c2) -> Long.compare(keyExtractor.applyAsLong(c1), keyExtractor.applyAsLong(c2));
        }

        @Override
        public long getCurrentEndPoint(long time, Statistics<? extends Object> statistics) {
            return Math.min(time, statistics.getEndTime());
        }

        @Override
        public long getCurrentEndPoint(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return Math.min(seqStatistics.getEndTime(), unseqStatistics.getEndTime());
        }

        @Override
        public boolean isExcessEndpoint(long time, long endpointTime) {
            return time > endpointTime;
        }

        @Override
        public boolean isTakeSeqAsFirst(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return seqStatistics.getStartTime() < unseqStatistics.getStartTime();
        }

        @Override
        public boolean getAscending() {
            return true;
        }

        @Override
        public boolean hasNextSeqResource() {
            TsFileResource tsFileResource;
            while (SeriesScanUtil.this.dataSource.hasNextSeqResource(SeriesScanUtil.this.curSeqFileIndex, this.getAscending()) && ((tsFileResource = SeriesScanUtil.this.dataSource.getSeqResourceByIndex(SeriesScanUtil.this.curSeqFileIndex)) == null || !tsFileResource.isSatisfied(SeriesScanUtil.this.seriesPath.getDevice(), SeriesScanUtil.this.timeFilter, null, true, false))) {
                ++SeriesScanUtil.this.curSeqFileIndex;
            }
            return SeriesScanUtil.this.dataSource.hasNextSeqResource(SeriesScanUtil.this.curSeqFileIndex, this.getAscending());
        }

        @Override
        public boolean hasNextUnseqResource() {
            TsFileResource tsFileResource;
            while (SeriesScanUtil.this.dataSource.hasNextUnseqResource(SeriesScanUtil.this.curUnseqFileIndex) && ((tsFileResource = SeriesScanUtil.this.dataSource.getUnseqResourceByIndex(SeriesScanUtil.this.curUnseqFileIndex)) == null || !tsFileResource.isSatisfied(SeriesScanUtil.this.seriesPath.getDevice(), SeriesScanUtil.this.timeFilter, null, false, false))) {
                ++SeriesScanUtil.this.curUnseqFileIndex;
            }
            return SeriesScanUtil.this.dataSource.hasNextUnseqResource(SeriesScanUtil.this.curUnseqFileIndex);
        }

        @Override
        public TsFileResource getNextSeqFileResource(boolean isDelete) {
            TsFileResource tsFileResource = SeriesScanUtil.this.dataSource.getSeqResourceByIndex(SeriesScanUtil.this.curSeqFileIndex);
            if (isDelete) {
                ++SeriesScanUtil.this.curSeqFileIndex;
            }
            return tsFileResource;
        }

        @Override
        public TsFileResource getNextUnseqFileResource(boolean isDelete) {
            TsFileResource tsFileResource = SeriesScanUtil.this.dataSource.getUnseqResourceByIndex(SeriesScanUtil.this.curUnseqFileIndex);
            if (isDelete) {
                ++SeriesScanUtil.this.curUnseqFileIndex;
            }
            return tsFileResource;
        }

        @Override
        public void setCurSeqFileIndex(QueryDataSource dataSource) {
            SeriesScanUtil.this.curSeqFileIndex = 0;
        }
    }

    class DescTimeOrderUtils
    implements TimeOrderUtils {
        DescTimeOrderUtils() {
        }

        public long getOrderTime(Statistics statistics) {
            return statistics.getEndTime();
        }

        @Override
        public long getOrderTime(TsFileResource fileResource) {
            return fileResource.getEndTime(SeriesScanUtil.this.seriesPath.getDevice());
        }

        public long getOverlapCheckTime(Statistics range) {
            return range.getStartTime();
        }

        public boolean isOverlapped(Statistics left, Statistics right) {
            return left.getStartTime() <= right.getEndTime();
        }

        public boolean isOverlapped(long time, Statistics right) {
            return time <= right.getEndTime();
        }

        @Override
        public boolean isOverlapped(long time, TsFileResource right) {
            return time <= right.getEndTime(SeriesScanUtil.this.seriesPath.getDevice());
        }

        @Override
        public <T> Comparator<T> comparingLong(ToLongFunction<? super T> keyExtractor) {
            Objects.requireNonNull(keyExtractor);
            return (Comparator & Serializable)(c1, c2) -> Long.compare(keyExtractor.applyAsLong(c2), keyExtractor.applyAsLong(c1));
        }

        @Override
        public long getCurrentEndPoint(long time, Statistics<? extends Object> statistics) {
            return Math.max(time, statistics.getStartTime());
        }

        @Override
        public long getCurrentEndPoint(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return Math.max(seqStatistics.getStartTime(), unseqStatistics.getStartTime());
        }

        @Override
        public boolean isExcessEndpoint(long time, long endpointTime) {
            return time < endpointTime;
        }

        @Override
        public boolean isTakeSeqAsFirst(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return seqStatistics.getEndTime() > unseqStatistics.getEndTime();
        }

        @Override
        public boolean getAscending() {
            return false;
        }

        @Override
        public boolean hasNextSeqResource() {
            TsFileResource tsFileResource;
            while (SeriesScanUtil.this.dataSource.hasNextSeqResource(SeriesScanUtil.this.curSeqFileIndex, this.getAscending()) && ((tsFileResource = SeriesScanUtil.this.dataSource.getSeqResourceByIndex(SeriesScanUtil.this.curSeqFileIndex)) == null || !tsFileResource.isSatisfied(SeriesScanUtil.this.seriesPath.getDevice(), SeriesScanUtil.this.timeFilter, null, true, false))) {
                --SeriesScanUtil.this.curSeqFileIndex;
            }
            return SeriesScanUtil.this.dataSource.hasNextSeqResource(SeriesScanUtil.this.curSeqFileIndex, this.getAscending());
        }

        @Override
        public boolean hasNextUnseqResource() {
            TsFileResource tsFileResource;
            while (SeriesScanUtil.this.dataSource.hasNextUnseqResource(SeriesScanUtil.this.curUnseqFileIndex) && ((tsFileResource = SeriesScanUtil.this.dataSource.getUnseqResourceByIndex(SeriesScanUtil.this.curUnseqFileIndex)) == null || !tsFileResource.isSatisfied(SeriesScanUtil.this.seriesPath.getDevice(), SeriesScanUtil.this.timeFilter, null, false, false))) {
                ++SeriesScanUtil.this.curUnseqFileIndex;
            }
            return SeriesScanUtil.this.dataSource.hasNextUnseqResource(SeriesScanUtil.this.curUnseqFileIndex);
        }

        @Override
        public TsFileResource getNextSeqFileResource(boolean isDelete) {
            TsFileResource tsFileResource = SeriesScanUtil.this.dataSource.getSeqResourceByIndex(SeriesScanUtil.this.curSeqFileIndex);
            if (isDelete) {
                --SeriesScanUtil.this.curSeqFileIndex;
            }
            return tsFileResource;
        }

        @Override
        public TsFileResource getNextUnseqFileResource(boolean isDelete) {
            TsFileResource tsFileResource = SeriesScanUtil.this.dataSource.getUnseqResourceByIndex(SeriesScanUtil.this.curUnseqFileIndex);
            if (isDelete) {
                ++SeriesScanUtil.this.curUnseqFileIndex;
            }
            return tsFileResource;
        }

        @Override
        public void setCurSeqFileIndex(QueryDataSource dataSource) {
            SeriesScanUtil.this.curSeqFileIndex = dataSource.getSeqResourcesSize() - 1;
        }
    }

    public static interface TimeOrderUtils {
        public long getOrderTime(Statistics<? extends Object> var1);

        public long getOrderTime(TsFileResource var1);

        public long getOverlapCheckTime(Statistics<? extends Object> var1);

        public boolean isOverlapped(Statistics<? extends Object> var1, Statistics<? extends Object> var2);

        public boolean isOverlapped(long var1, Statistics<? extends Object> var3);

        public boolean isOverlapped(long var1, TsFileResource var3);

        public <T> Comparator<T> comparingLong(ToLongFunction<? super T> var1);

        public long getCurrentEndPoint(long var1, Statistics<? extends Object> var3);

        public long getCurrentEndPoint(Statistics<? extends Object> var1, Statistics<? extends Object> var2);

        public boolean isExcessEndpoint(long var1, long var3);

        public boolean isTakeSeqAsFirst(Statistics<? extends Object> var1, Statistics<? extends Object> var2);

        public boolean getAscending();

        public boolean hasNextSeqResource();

        public boolean hasNextUnseqResource();

        public TsFileResource getNextSeqFileResource(boolean var1);

        public TsFileResource getNextUnseqFileResource(boolean var1);

        public void setCurSeqFileIndex(QueryDataSource var1);
    }

    protected class VersionPageReader {
        protected PriorityMergeReader.MergeReaderPriority version;
        protected IPageReader data;
        protected boolean isSeq;

        VersionPageReader(long version, long offset, IPageReader data, boolean isSeq) {
            this.version = new PriorityMergeReader.MergeReaderPriority(version, offset);
            this.data = data;
            this.isSeq = isSeq;
        }

        public boolean isAlignedPageReader() {
            return this.data instanceof IAlignedPageReader;
        }

        Statistics getStatistics() {
            return this.data.getStatistics();
        }

        Statistics getStatistics(int index) throws IOException {
            if (!(this.data instanceof IAlignedPageReader)) {
                throw new IOException("Can only get statistics by index from AlignedPageReader");
            }
            return ((IAlignedPageReader)this.data).getStatistics(index);
        }

        Statistics getTimeStatistics() throws IOException {
            if (!(this.data instanceof IAlignedPageReader)) {
                throw new IOException("Can only get statistics of time column from AlignedPageReader");
            }
            return ((IAlignedPageReader)this.data).getTimeStatistics();
        }

        TsBlock getAllSatisfiedPageData(boolean ascending) throws IOException {
            TsBlock tsBlock = this.data.getAllSatisfiedData();
            if (!ascending) {
                tsBlock.reverse();
            }
            return tsBlock;
        }

        void setFilter(Filter filter) {
            this.data.setFilter(filter);
        }

        boolean isModified() {
            return this.data.isModified();
        }

        public boolean isSeq() {
            return this.isSeq;
        }
    }
}

