/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.schedule.task;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.driver.IDriver;
import org.apache.iotdb.db.mpp.execution.exchange.ISinkHandle;
import org.apache.iotdb.db.mpp.execution.schedule.ExecutionContext;
import org.apache.iotdb.db.mpp.execution.schedule.queue.ID;
import org.apache.iotdb.db.mpp.execution.schedule.queue.IDIndexedAccessible;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTaskID;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTaskStatus;

public class DriverTask
implements IDIndexedAccessible {
    private DriverTaskID id;
    private DriverTaskStatus status;
    private final IDriver fragmentInstance;
    private volatile double schedulePriority;
    private final long ddl;
    private final Lock lock;
    private long cpuWallNano;
    private String abortCause;

    public DriverTask() {
        this(new StubFragmentInstance(), 0L, null);
    }

    public DriverTask(IDriver instance, long timeoutMs, DriverTaskStatus status) {
        this.fragmentInstance = instance;
        this.id = new DriverTaskID(instance.getInfo());
        this.setStatus(status);
        this.schedulePriority = 0.0;
        this.ddl = System.currentTimeMillis() + timeoutMs;
        this.lock = new ReentrantLock();
    }

    @Override
    public DriverTaskID getId() {
        return this.id;
    }

    @Override
    public void setId(ID id) {
        this.id = (DriverTaskID)id;
    }

    public DriverTaskStatus getStatus() {
        return this.status;
    }

    public boolean isEndState() {
        return this.status == DriverTaskStatus.ABORTED || this.status == DriverTaskStatus.FINISHED;
    }

    public IDriver getFragmentInstance() {
        return this.fragmentInstance;
    }

    public void setStatus(DriverTaskStatus status) {
        this.status = status;
    }

    public void updateSchedulePriority(ExecutionContext context) {
        double penaltyFactor = context.getCpuDuration().getWall().getValue(TimeUnit.NANOSECONDS) / context.getTimeSlice().getValue(TimeUnit.NANOSECONDS);
        long base = System.currentTimeMillis() - this.ddl;
        this.schedulePriority = (double)base * penaltyFactor;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public double getSchedulePriority() {
        return this.schedulePriority;
    }

    public long getDDL() {
        return this.ddl;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof DriverTask && ((DriverTask)o).getId().equals(this.id);
    }

    public String getAbortCause() {
        return this.abortCause;
    }

    public void setAbortCause(String abortCause) {
        this.abortCause = abortCause;
    }

    private static class StubFragmentInstance
    implements IDriver {
        private static final QueryId stubQueryId = new QueryId("stub_query");
        private static final FragmentInstanceId stubInstance = new FragmentInstanceId(new PlanFragmentId(stubQueryId, 0), "stub-instance");

        private StubFragmentInstance() {
        }

        @Override
        public boolean isFinished() {
            return false;
        }

        @Override
        public ListenableFuture<?> processFor(Duration duration) {
            return null;
        }

        @Override
        public FragmentInstanceId getInfo() {
            return stubInstance;
        }

        @Override
        public void close() {
        }

        @Override
        public void failed(Throwable t) {
        }

        @Override
        public ISinkHandle getSinkHandle() {
            return null;
        }
    }

    public static class SchedulePriorityComparator
    implements Comparator<DriverTask> {
        @Override
        public int compare(DriverTask o1, DriverTask o2) {
            if (o1.getId().equals(o2.getId())) {
                return 0;
            }
            if (o1.getSchedulePriority() > o2.getSchedulePriority()) {
                return -1;
            }
            if (o1.getSchedulePriority() < o2.getSchedulePriority()) {
                return 1;
            }
            return o1.getId().compareTo(o2.getId());
        }
    }

    public static class TimeoutComparator
    implements Comparator<DriverTask> {
        @Override
        public int compare(DriverTask o1, DriverTask o2) {
            if (o1.getId().equals(o2.getId())) {
                return 0;
            }
            if (o1.getDDL() < o2.getDDL()) {
                return -1;
            }
            if (o1.getDDL() > o2.getDDL()) {
                return 1;
            }
            return o1.getId().compareTo(o2.getId());
        }
    }
}

