/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config.executor;

import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.consensus.PartitionRegionId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.trigger.enums.TriggerEvent;
import org.apache.iotdb.commons.trigger.enums.TriggerType;
import org.apache.iotdb.confignode.rpc.thrift.TCountStorageGroupResp;
import org.apache.iotdb.confignode.rpc.thrift.TCreateFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteStorageGroupsReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetTemplateResp;
import org.apache.iotdb.confignode.rpc.thrift.TSetStorageGroupReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowClusterResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowConfigNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDataNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowStorageGroupResp;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchemaResp;
import org.apache.iotdb.db.client.ConfigNodeClient;
import org.apache.iotdb.db.client.ConfigNodeInfo;
import org.apache.iotdb.db.client.DataNodeClientPoolFactory;
import org.apache.iotdb.db.localconfignode.LocalConfigNode;
import org.apache.iotdb.db.metadata.template.ClusterTemplateManager;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.CountStorageGroupTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.SetStorageGroupTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowClusterTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowConfigNodesTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowDataNodesTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowRegionTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowStorageGroupTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowTTLTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.template.ShowNodesInSchemaTemplateTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.template.ShowPathSetTemplateTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.template.ShowSchemaTemplateTask;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DeleteStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.SetStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.SetTTLStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowDataNodesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowRegionStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowTTLStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.SetSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowNodesInSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowPathSetTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeSinkStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.DropPipeSinkStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.DropPipeStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.ShowPipeSinkStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.ShowPipeStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.StartPipeStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.StopPipeStatement;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConfigTaskExecutor
implements IConfigTaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterConfigTaskExecutor.class);
    private static final IClientManager<PartitionRegionId, ConfigNodeClient> CONFIG_NODE_CLIENT_MANAGER = new IClientManager.Factory().createClientManager((IClientPoolFactory)new DataNodeClientPoolFactory.ConfigNodeClientPoolFactory());

    public static ClusterConfigTaskExecutor getInstance() {
        return ClusterConfigTaskExecutorHolder.INSTANCE;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setStorageGroup(SetStorageGroupStatement setStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        TStorageGroupSchema storageGroupSchema = SetStorageGroupTask.constructStorageGroupSchema(setStorageGroupStatement);
        TSetStorageGroupReq req = new TSetStorageGroupReq(storageGroupSchema);
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TSStatus tsStatus = configNodeClient.setStorageGroup(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.error("Failed to execute set storage group {} in config node, status is {}.", (Object)setStorageGroupStatement.getStorageGroupPath(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showStorageGroup(ShowStorageGroupStatement showStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        List<String> storageGroupPathPattern = Arrays.asList(showStorageGroupStatement.getPathPattern().getNodes());
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TShowStorageGroupResp resp = client.showStorageGroup(storageGroupPathPattern);
            ShowStorageGroupTask.buildTSBlock(resp.getStorageGroupInfoMap(), (SettableFuture<ConfigTaskResult>)future);
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> countStorageGroup(CountStorageGroupStatement countStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        List<String> storageGroupPathPattern = Arrays.asList(countStorageGroupStatement.getPathPattern().getNodes());
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TCountStorageGroupResp resp = client.countMatchedStorageGroups(storageGroupPathPattern);
            int storageGroupNum = resp.getCount();
            CountStorageGroupTask.buildTSBlock(storageGroupNum, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> deleteStorageGroup(DeleteStorageGroupStatement deleteStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        TDeleteStorageGroupsReq req = new TDeleteStorageGroupsReq(deleteStorageGroupStatement.getPrefixPath());
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TSStatus tsStatus = client.deleteStorageGroups(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.error("Failed to execute delete storage group {} in config node, status is {}.", deleteStorageGroupStatement.getPrefixPath(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createFunction(String udfName, String className, List<String> uris) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TSStatus executionStatus = client.createFunction(new TCreateFunctionReq(udfName, className, uris));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.error("[{}] Failed to create function {}({}) in config node, URI: {}.", new Object[]{executionStatus, udfName, className, uris});
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropFunction(String udfName) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TSStatus executionStatus = client.dropFunction(new TDropFunctionReq(udfName));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.error("[{}] Failed to drop function {} in config node.", (Object)executionStatus, (Object)udfName);
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createTrigger(String triggerName, String className, String jarPath, boolean usingURI, TriggerEvent triggerEvent, TriggerType triggerType, PartialPath pathPattern) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TSStatus executionStatus = client.createTrigger(new TCreateTriggerReq(triggerName, null, null));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.error("[{}] Failed to create trigger {}.", (Object)executionStatus, (Object)triggerName);
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropTrigger(String triggerName) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TSStatus executionStatus = client.dropTrigger(new TDropTriggerReq(triggerName));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.error("[{}] Failed to drop trigger {}.", (Object)executionStatus, (Object)triggerName);
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setTTL(SetTTLStatement setTTLStatement, String taskName) {
        SettableFuture future = SettableFuture.create();
        List<String> storageGroupPathPattern = Arrays.asList(setTTLStatement.getStorageGroupPath().getNodes());
        TSetTTLReq setTTLReq = new TSetTTLReq(storageGroupPathPattern, setTTLStatement.getTTL());
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TSStatus tsStatus = configNodeClient.setTTL(setTTLReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.error("Failed to execute {} {} in config node, status is {}.", new Object[]{taskName, setTTLStatement.getStorageGroupPath(), tsStatus});
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> merge(boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
                tsStatus = client.merge();
            }
            catch (IOException | TException e) {
                future.setException(e);
            }
        } else {
            tsStatus = LocalConfigNode.getInstance().executeMergeOperation();
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> flush(TFlushReq tFlushReq, boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
                tsStatus = client.flush(tFlushReq);
            }
            catch (IOException | TException e) {
                future.setException(e);
            }
        } else {
            tsStatus = LocalConfigNode.getInstance().executeFlushOperation(tFlushReq);
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> clearCache(boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
                tsStatus = client.clearCache();
            }
            catch (IOException | TException e) {
                future.setException(e);
            }
        } else {
            tsStatus = LocalConfigNode.getInstance().executeClearCacheOperation();
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> loadConfiguration(boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
                tsStatus = client.loadConfiguration();
            }
            catch (IOException | TException e) {
                future.setException(e);
            }
        } else {
            tsStatus = LocalConfigNode.getInstance().executeLoadConfigurationOperation();
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new StatementExecutionException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setSystemStatus(boolean onCluster, NodeStatus status) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
                tsStatus = client.setSystemStatus(status.getStatus());
            }
            catch (IOException | TException e) {
                future.setException(e);
            }
        } else {
            tsStatus = LocalConfigNode.getInstance().executeSetSystemStatus(status);
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new StatementExecutionException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showCluster() {
        SettableFuture future = SettableFuture.create();
        TShowClusterResp showClusterResp = new TShowClusterResp();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            showClusterResp = client.showCluster();
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        ShowClusterTask.buildTSBlock(showClusterResp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showTTL(ShowTTLStatement showTTLStatement) {
        SettableFuture future = SettableFuture.create();
        List<PartialPath> storageGroupPaths = showTTLStatement.getPaths();
        HashMap<String, Long> storageGroupToTTL = new HashMap<String, Long>();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            if (showTTLStatement.isAll()) {
                List<String> allStorageGroupPathPattern = Arrays.asList("root", "**");
                TStorageGroupSchemaResp resp = client.getMatchedStorageGroupSchemas(allStorageGroupPathPattern);
                for (Map.Entry entry : resp.getStorageGroupSchemaMap().entrySet()) {
                    storageGroupToTTL.put((String)entry.getKey(), ((TStorageGroupSchema)entry.getValue()).getTTL());
                }
            } else {
                for (PartialPath storageGroupPath : storageGroupPaths) {
                    List<String> storageGroupPathPattern = Arrays.asList(storageGroupPath.getNodes());
                    TStorageGroupSchemaResp resp = client.getMatchedStorageGroupSchemas(storageGroupPathPattern);
                    for (Map.Entry entry : resp.getStorageGroupSchemaMap().entrySet()) {
                        if (storageGroupToTTL.containsKey(entry.getKey())) continue;
                        storageGroupToTTL.put((String)entry.getKey(), ((TStorageGroupSchema)entry.getValue()).getTTL());
                    }
                }
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        ShowTTLTask.buildTSBlock(storageGroupToTTL, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showRegion(ShowRegionStatement showRegionStatement) {
        SettableFuture future = SettableFuture.create();
        TShowRegionResp showRegionResp = new TShowRegionResp();
        TShowRegionReq showRegionReq = new TShowRegionReq();
        showRegionReq.setConsensusGroupType(showRegionStatement.getRegionType());
        if (showRegionStatement.getStorageGroups() == null) {
            showRegionReq.setStorageGroups(null);
        } else {
            showRegionReq.setStorageGroups(showRegionStatement.getStorageGroups().stream().map(PartialPath::getFullPath).collect(Collectors.toList()));
        }
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            showRegionResp = client.showRegion(showRegionReq);
            if (showRegionResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showRegionResp.getStatus().message, showRegionResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        ShowRegionTask.buildTSBlock(showRegionResp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showDataNodes(ShowDataNodesStatement showDataNodesStatement) {
        SettableFuture future = SettableFuture.create();
        TShowDataNodesResp showDataNodesResp = new TShowDataNodesResp();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            showDataNodesResp = client.showDataNodes();
            if (showDataNodesResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showDataNodesResp.getStatus().message, showDataNodesResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        ShowDataNodesTask.buildTSBlock(showDataNodesResp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showConfigNodes() {
        SettableFuture future = SettableFuture.create();
        TShowConfigNodesResp showConfigNodesResp = new TShowConfigNodesResp();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            showConfigNodesResp = client.showConfigNodes();
            if (showConfigNodesResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showConfigNodesResp.getStatus().message, showConfigNodesResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        ShowConfigNodesTask.buildTSBlock(showConfigNodesResp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createSchemaTemplate(CreateSchemaTemplateStatement createSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        try {
            TSStatus tsStatus = ClusterTemplateManager.getInstance().createSchemaTemplate(createSchemaTemplateStatement);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.error("Failed to execute create schema template {} in config node, status is {}.", (Object)createSchemaTemplateStatement.getName(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException(e.getCause());
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showSchemaTemplate(ShowSchemaTemplateStatement showSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            List<Template> templateList = ClusterTemplateManager.getInstance().getAllTemplates();
            ShowSchemaTemplateTask.buildTSBlock(templateList, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showNodesInSchemaTemplate(ShowNodesInSchemaTemplateStatement showNodesInSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        String req = showNodesInSchemaTemplateStatement.getTemplateName();
        TGetTemplateResp tGetTemplateResp = new TGetTemplateResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            Template template = ClusterTemplateManager.getInstance().getTemplate(req);
            ShowNodesInSchemaTemplateTask.buildTSBlock(template, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setSchemaTemplate(SetSchemaTemplateStatement setSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        String templateName = setSchemaTemplateStatement.getTemplateName();
        PartialPath path = setSchemaTemplateStatement.getPath();
        try {
            ClusterTemplateManager.getInstance().setSchemaTemplate(templateName, path);
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        }
        catch (Exception e) {
            future.setException(e.getCause());
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showPathSetTemplate(ShowPathSetTemplateStatement showPathSetTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        String templateName = showPathSetTemplateStatement.getTemplateName();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            List<PartialPath> listPath = ClusterTemplateManager.getInstance().getPathsSetTemplate(templateName);
            ShowPathSetTemplateTask.buildTSBlock(listPath, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createPipe(CreatePipeStatement createPipeStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing create pipe is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createPipeSink(CreatePipeSinkStatement createPipeSinkStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing create pipesink is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropPipe(DropPipeStatement dropPipeStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing drop pipe is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropPipeSink(DropPipeSinkStatement dropPipeSinkStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing drop pipesink is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showPipe(ShowPipeStatement showPipeStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing show pipe is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showPipeSink(ShowPipeSinkStatement showPipeSinkStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing show pipesink is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> startPipe(StartPipeStatement startPipeStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing Start pipe is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> stopPipe(StopPipeStatement stopPipeStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing stop pipe is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    private static final class ClusterConfigTaskExecutorHolder {
        private static final ClusterConfigTaskExecutor INSTANCE = new ClusterConfigTaskExecutor();

        private ClusterConfigTaskExecutorHolder() {
        }
    }
}

