/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.confignode.rpc.thrift.TShowClusterResp;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowClusterStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class ShowClusterTask
implements IConfigTask {
    public ShowClusterTask(ShowClusterStatement showClusterStatement) {
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showCluster();
    }

    private static void buildTsBlock(TsBlockBuilder builder, int nodeId, String nodeType, String nodeStatus, String hostAddress, int port) {
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeInt(nodeId);
        builder.getColumnBuilder(1).writeBinary(new Binary(nodeType));
        builder.getColumnBuilder(2).writeBinary(new Binary(nodeStatus));
        builder.getColumnBuilder(3).writeBinary(new Binary(hostAddress));
        builder.getColumnBuilder(4).writeInt(port);
        builder.declarePosition();
    }

    public static void buildTSBlock(TShowClusterResp clusterNodeInfos, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showClusterColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        clusterNodeInfos.getConfigNodeList().forEach(e -> ShowClusterTask.buildTsBlock(builder, e.getConfigNodeId(), "ConfigNode", (String)clusterNodeInfos.getNodeStatus().get(e.getConfigNodeId()), e.getInternalEndPoint().getIp(), e.getInternalEndPoint().getPort()));
        clusterNodeInfos.getDataNodeList().forEach(e -> ShowClusterTask.buildTsBlock(builder, e.getDataNodeId(), "DataNode", (String)clusterNodeInfos.getNodeStatus().get(e.getDataNodeId()), e.getInternalEndPoint().getIp(), e.getInternalEndPoint().getPort()));
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowClusterHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

